/*
 * Decompiled with CFR 0.152.
 */
package sguest.millenairejei.jei;

import java.util.Collections;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import sguest.millenairejei.config.ModConfig;
import sguest.millenairejei.jei.mudbrick.BrickMouldRecipeCategory;
import sguest.millenairejei.jei.mudbrick.BrickMouldRecipeWrapper;
import sguest.millenairejei.jei.mudbrick.DryingRecipeCategory;
import sguest.millenairejei.jei.mudbrick.DryingRecipeWrapper;
import sguest.millenairejei.jei.painting.PaintingRecipeCategory;
import sguest.millenairejei.jei.painting.PaintingRecipeWrapper;
import sguest.millenairejei.jei.trading.BuyingRecipeCategory;
import sguest.millenairejei.jei.trading.BuyingRecipeWrapper;
import sguest.millenairejei.jei.trading.SellingRecipeCategory;
import sguest.millenairejei.jei.trading.SellingRecipeWrapper;
import sguest.millenairejei.jei.villagercrafting.VillagerCookingRecipeCategory;
import sguest.millenairejei.jei.villagercrafting.VillagerCrafingRecipeWrapper;
import sguest.millenairejei.jei.villagercrafting.VillagerCraftingRecipeCategory;
import sguest.millenairejei.jei.villagercrafting.VillagerHarvestingRecipeCategory;
import sguest.millenairejei.jei.villagercrafting.VillagerSlaughteringRecipeCategory;
import sguest.millenairejei.jei.villagercrafting.VillagerSlaughteringRecipeWrapper;
import sguest.millenairejei.millenairedata.MillenaireDataRegistry;
import sguest.millenairejei.recipes.EmptyRecipeData;
import sguest.millenairejei.recipes.JeiBlacklist;
import sguest.millenairejei.recipes.painting.PaintingRecipeData;
import sguest.millenairejei.recipes.painting.PaintingRecipeLookup;
import sguest.millenairejei.recipes.trading.TradingRecipeData;
import sguest.millenairejei.recipes.trading.TradingRecipeLookup;
import sguest.millenairejei.recipes.villagercrafting.VillagerCraftingRecipeData;
import sguest.millenairejei.recipes.villagercrafting.VillagerCraftingRecipeLookup;
import sguest.millenairejei.recipes.villagercrafting.VillagerSlaughterRecipeData;
import sguest.millenairejei.util.ItemHelper;

@JEIPlugin
public class MillenaireJeiPlugin
implements IModPlugin {
    public static final String BUYING = "millenairejei.buying";
    public static final String SELLING = "millenairejei.selling";
    public static final String PAINTING = "millenairejei.painting";
    public static final String BRICK_MOULD = "millenairejei.brickmould";
    public static final String DRYING = "millenairejei.drying";
    public static final String VILLAGER_CRAFTING = "millenairejei.villagercrafting";
    public static final String VILLAGER_COOKING = "millenairejei.villagercooking";
    public static final String VILLAGER_HARVESTING = "millenairejei.villagerharvesting";
    public static final String VILLAGER_SLAUGHTERING = "millenairejei.villagerslaughtering";

    public void register(@Nonnull IModRegistry registry) {
        IGuiHelper guiHelper = registry.getJeiHelpers().getGuiHelper();
        registry.handleRecipes(TradingRecipeData.class, data -> new BuyingRecipeWrapper((TradingRecipeData)data, guiHelper), BUYING);
        registry.handleRecipes(TradingRecipeData.class, data -> new SellingRecipeWrapper((TradingRecipeData)data, guiHelper), SELLING);
        registry.handleRecipes(PaintingRecipeData.class, PaintingRecipeWrapper::new, PAINTING);
        registry.handleRecipes(EmptyRecipeData.class, o -> new BrickMouldRecipeWrapper(), BRICK_MOULD);
        registry.handleRecipes(EmptyRecipeData.class, o -> new DryingRecipeWrapper(), DRYING);
        registry.handleRecipes(VillagerCraftingRecipeData.class, data -> new VillagerCrafingRecipeWrapper((VillagerCraftingRecipeData)data, guiHelper), VILLAGER_CRAFTING);
        registry.handleRecipes(VillagerCraftingRecipeData.class, data -> new VillagerCrafingRecipeWrapper((VillagerCraftingRecipeData)data, guiHelper), VILLAGER_COOKING);
        registry.handleRecipes(VillagerCraftingRecipeData.class, data -> new VillagerCrafingRecipeWrapper((VillagerCraftingRecipeData)data, guiHelper), VILLAGER_HARVESTING);
        registry.handleRecipes(VillagerSlaughterRecipeData.class, data -> new VillagerSlaughteringRecipeWrapper((VillagerSlaughterRecipeData)data, guiHelper), VILLAGER_SLAUGHTERING);
        registry.addRecipeCatalyst((Object)ItemHelper.getStackFromResource("millenaire:purse"), new String[]{BUYING});
        registry.addRecipeCatalyst((Object)ItemHelper.getStackFromResource("millenaire:denier"), new String[]{BUYING});
        registry.addRecipeCatalyst((Object)ItemHelper.getStackFromResource("millenaire:denierargent"), new String[]{BUYING});
        registry.addRecipeCatalyst((Object)ItemHelper.getStackFromResource("millenaire:denieror"), new String[]{BUYING});
        registry.addRecipeCatalyst((Object)ItemHelper.getStackFromResource("millenaire:brickmould"), new String[]{BRICK_MOULD});
        MillenaireDataRegistry.getInstance().loadMillenaireData();
        TradingRecipeLookup tradingLookup = new TradingRecipeLookup();
        tradingLookup.buildRecipes();
        if (ModConfig.showBuyingRecipes) {
            registry.addRecipes(tradingLookup.getBuyingRecipes(), BUYING);
        }
        if (ModConfig.showSellingRecipes) {
            registry.addRecipes(tradingLookup.getSellingRecipes(), SELLING);
        }
        if (ModConfig.showPaintingRecipes) {
            PaintingRecipeLookup paintingLookup = new PaintingRecipeLookup();
            paintingLookup.buildRecipes();
            registry.addRecipes(paintingLookup.getRecipes(), PAINTING);
        }
        if (ModConfig.showBrickMouldRecipes) {
            registry.addRecipes(Collections.singletonList(new EmptyRecipeData()), BRICK_MOULD);
        }
        if (ModConfig.showDryingRecipes) {
            registry.addRecipes(Collections.singletonList(new EmptyRecipeData()), DRYING);
        }
        VillagerCraftingRecipeLookup villagerCraftingLookup = new VillagerCraftingRecipeLookup();
        villagerCraftingLookup.BuildRecipes();
        if (ModConfig.showVillagerCraftingRecipes) {
            registry.addRecipes(villagerCraftingLookup.getCraftingRecipes(), VILLAGER_CRAFTING);
        }
        if (ModConfig.showVillagerCookingRecipes) {
            registry.addRecipes(villagerCraftingLookup.getCookingRecipes(), VILLAGER_COOKING);
        }
        if (ModConfig.showVillagerHarvestingRecipes) {
            registry.addRecipes(villagerCraftingLookup.getHarvestRecipes(), VILLAGER_HARVESTING);
        }
        if (ModConfig.showVillagerSlaughteringRecipes) {
            registry.addRecipes(villagerCraftingLookup.getSlaughterRecipes(), VILLAGER_SLAUGHTERING);
        }
        if (ModConfig.hideTechnicalItems) {
            JeiBlacklist.blacklistItems(registry.getJeiHelpers().getIngredientBlacklist());
        }
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        IGuiHelper guiHelper = registry.getJeiHelpers().getGuiHelper();
        registry.addRecipeCategories(new IRecipeCategory[]{new BuyingRecipeCategory(guiHelper), new SellingRecipeCategory(guiHelper), new PaintingRecipeCategory(guiHelper), new BrickMouldRecipeCategory(guiHelper), new DryingRecipeCategory(guiHelper), new VillagerCraftingRecipeCategory(guiHelper), new VillagerCookingRecipeCategory(guiHelper), new VillagerHarvestingRecipeCategory(guiHelper), new VillagerSlaughteringRecipeCategory(guiHelper)});
    }
}

