/*
 * Decompiled with CFR 0.152.
 */
package p455w0rd.wct.util;

import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;
import p455w0rd.ae2wtlib.api.ICustomWirelessTerminalItem;
import p455w0rd.ae2wtlib.api.WTApi;
import p455w0rd.wct.api.IWirelessCraftingTerminalItem;
import p455w0rd.wct.api.WCTApi;
import p455w0rd.wct.container.ContainerWCT;
import p455w0rd.wct.init.ModKeybindings;
import p455w0rd.wct.init.ModNetworking;
import p455w0rd.wct.items.ItemMagnet;
import p455w0rd.wct.sync.packets.PacketCycleMagnetKeybind;
import p455w0rdslib.LibGlobals;

public class WCTUtils {
    public static final String SHIFTCRAFT_NBT = "ShiftCraft";

    public static Set<Pair<Boolean, Pair<Integer, ItemStack>>> getCraftingTerminals(EntityPlayer player) {
        return WTApi.instance().getAllWirelessTerminalsByType(player, IWirelessCraftingTerminalItem.class);
    }

    public static ItemStack getWCTBySlot(EntityPlayer player, int slot, boolean isBauble) {
        if (slot >= 0) {
            return WTApi.instance().getWTBySlot(player, isBauble, slot, IWirelessCraftingTerminalItem.class);
        }
        return ItemStack.field_190927_a;
    }

    @Nonnull
    public static Pair<Boolean, Pair<Integer, ItemStack>> getFirstWirelessCraftingTerminal(InventoryPlayer playerInv) {
        boolean isBauble = false;
        int slotID = -1;
        ItemStack wirelessTerm = ItemStack.field_190927_a;
        if (!playerInv.field_70458_d.func_184614_ca().func_190926_b() && (playerInv.field_70458_d.func_184614_ca().func_77973_b() instanceof IWirelessCraftingTerminalItem || WTApi.instance().getWUTUtility().doesWUTSupportType(playerInv.field_70458_d.func_184614_ca(), IWirelessCraftingTerminalItem.class))) {
            slotID = playerInv.field_70461_c;
            wirelessTerm = playerInv.field_70458_d.func_184614_ca();
        } else {
            int invSize;
            Pair bauble;
            if (LibGlobals.Mods.BAUBLES.isLoaded() && !((ItemStack)(bauble = WTApi.instance().getBaublesUtility().getFirstWTBaubleByType(playerInv.field_70458_d, IWirelessCraftingTerminalItem.class)).getRight()).func_190926_b()) {
                wirelessTerm = (ItemStack)bauble.getRight();
                slotID = (Integer)bauble.getLeft();
                if (!wirelessTerm.func_190926_b()) {
                    isBauble = true;
                }
            }
            if (wirelessTerm.func_190926_b() && (invSize = playerInv.func_70302_i_()) > 0) {
                for (int i = 0; i < invSize; ++i) {
                    ItemStack item = playerInv.func_70301_a(i);
                    if (item.func_190926_b() || !WCTUtils.isAnyWCT(item)) continue;
                    wirelessTerm = item;
                    slotID = i;
                    break;
                }
            }
        }
        return Pair.of((Object)isBauble, (Object)Pair.of((Object)slotID, (Object)wirelessTerm));
    }

    public static boolean isAnyWCT(@Nonnull ItemStack wirelessTerm) {
        return wirelessTerm.func_77973_b() instanceof IWirelessCraftingTerminalItem || WTApi.instance().getWUTUtility().doesWUTSupportType(wirelessTerm, IWirelessCraftingTerminalItem.class);
    }

    public static boolean isAnyWCT(@Nonnull ItemStack wirelessTerm, boolean excludeUltimateTerminal) {
        if (!excludeUltimateTerminal) {
            return WCTUtils.isAnyWCT(wirelessTerm);
        }
        return wirelessTerm.func_77973_b() instanceof IWirelessCraftingTerminalItem;
    }

    @SideOnly(value=Side.CLIENT)
    public static void handleKeybind() {
        EntityPlayerSP p = Minecraft.func_71410_x().field_71439_g;
        if (p.field_71070_bA == null) {
            return;
        }
        if (ModKeybindings.openTerminal.func_151468_f()) {
            Pair<Boolean, Pair<Integer, ItemStack>> pair = WCTUtils.getFirstWirelessCraftingTerminal(p.field_71071_by);
            ItemStack is = (ItemStack)((Pair)pair.getRight()).getRight();
            if (is.func_190926_b()) {
                return;
            }
            int slot = (Integer)((Pair)pair.getRight()).getLeft();
            boolean isBauble = (Boolean)pair.getLeft();
            ICustomWirelessTerminalItem wirelessTerm = (ICustomWirelessTerminalItem)is.func_77973_b();
            if (wirelessTerm != null) {
                if (!(p.field_71070_bA instanceof ContainerWCT)) {
                    if (slot >= 0) {
                        WCTApi.instance().openWCTGui((EntityPlayer)p, isBauble, slot);
                    }
                } else {
                    p.func_71053_j();
                }
            }
        } else if (ModKeybindings.cycleMagnetMode.func_151468_f()) {
            Set<Pair<Boolean, Pair<Integer, ItemStack>>> termPairs = WCTUtils.getCraftingTerminals((EntityPlayer)p);
            for (Pair<Boolean, Pair<Integer, ItemStack>> currentPair : termPairs) {
                ItemStack currentTerminal = (ItemStack)((Pair)currentPair.getRight()).getRight();
                ItemStack magnet = ItemMagnet.getMagnetFromWCT(currentTerminal);
                if (magnet.func_190926_b()) continue;
                int slot = (Integer)((Pair)currentPair.getRight()).getLeft();
                boolean isBauble = (Boolean)currentPair.getLeft();
                ItemMagnet.cycleMagnetFunctionModeWCT((EntityPlayer)p, slot, isBauble);
                ModNetworking.instance().sendToServer(new PacketCycleMagnetKeybind(slot, isBauble));
            }
        }
    }

    public static boolean getShiftCraftMode(@Nonnull ItemStack wirelessTerminal) {
        if (!wirelessTerminal.func_190926_b() && wirelessTerminal.func_77942_o() && wirelessTerminal.func_77978_p().func_150297_b(SHIFTCRAFT_NBT, 1)) {
            return !wirelessTerminal.func_77978_p().func_74767_n(SHIFTCRAFT_NBT);
        }
        return false;
    }
}

