/*
 * Decompiled with CFR 0.152.
 */
package org.dave.bonsaitrees.trees;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.dave.bonsaitrees.BonsaiTrees;
import org.dave.bonsaitrees.api.IBonsaiTreeType;
import org.dave.bonsaitrees.misc.ConfigurationHandler;
import org.dave.bonsaitrees.misc.FloodFill;
import org.dave.bonsaitrees.trees.TreeShapeSerializer;

public class TreeShape {
    private Map<BlockPos, IBlockState> blocks;
    private final String typeName;
    private String fileName;
    private int width = 0;
    private int height = 0;
    private int depth = 0;
    private static final Pattern p = Pattern.compile("0*([0-9]+)\\.json$", 2);

    public TreeShape(String typeName) {
        this.typeName = typeName;
        this.blocks = new HashMap<BlockPos, IBlockState>();
    }

    public String getTreeTypeName() {
        return this.typeName;
    }

    public IBonsaiTreeType getTreeType() {
        return BonsaiTrees.instance.typeRegistry.getTypeByName(this.typeName);
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String saveToFile() {
        String json = TreeShapeSerializer.serializePretty(this);
        if (json == null) {
            return null;
        }
        String sane = this.typeName.replaceAll("[^a-zA-Z0-9\\._]+", "_").toLowerCase();
        File dstFile = TreeShape.getNextFile(sane.replace(".json", ""));
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(dstFile));
            writer.write(json);
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        return dstFile.getName();
    }

    private static File getNextFile(String prefix) {
        int highestNum = 0;
        for (File file : ConfigurationHandler.treeShapesDir.listFiles()) {
            int num;
            Matcher m;
            String fileName = file.getName();
            if (!fileName.endsWith(".json") || !fileName.toLowerCase().startsWith(prefix) || !(m = p.matcher(fileName)).find() || (num = Integer.parseInt(m.group(1))) <= highestNum) continue;
            highestNum = num;
        }
        int nextNum = highestNum + 1;
        String fileName = String.format("%s%03d.json", prefix, nextNum);
        return new File(ConfigurationHandler.treeShapesDir, fileName);
    }

    public void setBlocksByFloodFill(World world, BlockPos pos) {
        FloodFill floodFill = new FloodFill(world, pos);
        Map<BlockPos, IBlockState> connectedBlocks = floodFill.getConnectedBlocks();
        if (connectedBlocks.size() == 0) {
            return;
        }
        this.setBlocks(connectedBlocks);
    }

    public void setBlocks(Map<BlockPos, IBlockState> blocks) {
        this.blocks = blocks;
        this.width = 0;
        this.height = 0;
        this.depth = 0;
        for (BlockPos pos : blocks.keySet()) {
            if (pos.func_177958_n() > this.width) {
                this.width = pos.func_177958_n();
            }
            if (pos.func_177956_o() > this.height) {
                this.height = pos.func_177956_o();
            }
            if (pos.func_177952_p() <= this.depth) continue;
            this.depth = pos.func_177952_p();
        }
    }

    public List<BlockPos> getToRenderPositions() {
        return new ArrayList<BlockPos>(this.blocks.keySet());
    }

    public Map<BlockPos, IBlockState> getBlocks() {
        return this.blocks;
    }

    public IBlockState getStateAtPos(BlockPos pos) {
        return this.blocks.get(pos);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getDepth() {
        return this.depth;
    }

    public double getScaleRatio(boolean inclHeight) {
        int dim = Math.max(this.width, this.depth);
        if (inclHeight || this.height > 10) {
            dim = Math.max(this.height, dim);
        }
        if (this.height > 6 || ++dim <= 4) {
            dim = Math.max(6, dim);
        }
        return 1.0 / (double)dim;
    }
}

