/*
 * Decompiled with CFR 0.152.
 */
package org.dave.bonsaitrees.render;

import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.dave.bonsaitrees.init.Blockss;
import org.dave.bonsaitrees.tile.TileBonsaiPot;

public class PotColorizer {
    public static final EnumDyeColor DEFAULT_COLOR = EnumDyeColor.SILVER;

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void init(ColorHandlerEvent.Block event) {
        IBlockColor potColorHandler = (state, blockAccess, pos, tintIndex) -> {
            TileEntity te = Minecraft.func_71410_x().field_71441_e.func_175625_s(pos);
            if (te == null || !(te instanceof TileBonsaiPot)) {
                return DEFAULT_COLOR.func_193350_e();
            }
            TileBonsaiPot bonsaiPot = (TileBonsaiPot)te;
            return bonsaiPot.getColor().func_193350_e();
        };
        event.getBlockColors().func_186722_a(potColorHandler, new Block[]{Blockss.bonsaiPot});
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void init(ColorHandlerEvent.Item event) {
        IItemColor itemBlockColourHandler = (stack, tintIndex) -> {
            if (!stack.func_77942_o()) {
                return DEFAULT_COLOR.func_193350_e();
            }
            NBTTagCompound stackTag = stack.func_77978_p();
            if (!stackTag.func_74764_b("color")) {
                return DEFAULT_COLOR.func_193350_e();
            }
            EnumDyeColor color = EnumDyeColor.func_176764_b((int)stackTag.func_74762_e("color"));
            return color.func_193350_e();
        };
        event.getItemColors().func_186731_a(itemBlockColourHandler, new Block[]{Blockss.bonsaiPot});
    }

    public static TextFormatting textFormattingForDye(EnumDyeColor color) {
        switch (color) {
            case WHITE: {
                return TextFormatting.WHITE;
            }
            case ORANGE: {
                return TextFormatting.GOLD;
            }
            case MAGENTA: {
                return TextFormatting.DARK_PURPLE;
            }
            case LIGHT_BLUE: {
                return TextFormatting.DARK_AQUA;
            }
            case YELLOW: {
                return TextFormatting.YELLOW;
            }
            case LIME: {
                return TextFormatting.GREEN;
            }
            case PINK: {
                return TextFormatting.LIGHT_PURPLE;
            }
            case GRAY: {
                return TextFormatting.DARK_GRAY;
            }
            case SILVER: {
                return TextFormatting.GRAY;
            }
            case CYAN: {
                return TextFormatting.AQUA;
            }
            case PURPLE: {
                return TextFormatting.DARK_PURPLE;
            }
            case BLUE: {
                return TextFormatting.BLUE;
            }
            case BROWN: {
                return TextFormatting.GOLD;
            }
            case GREEN: {
                return TextFormatting.DARK_GREEN;
            }
            case RED: {
                return TextFormatting.DARK_RED;
            }
            case BLACK: {
                return TextFormatting.DARK_GRAY;
            }
        }
        return TextFormatting.WHITE;
    }
}

