/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.util;

import com.ldtteam.structurize.api.util.Log;
import com.ldtteam.structurize.util.PlacementSettings;
import com.ldtteam.structurize.util.StructureLoadingUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.xml.bind.DatatypeConverter;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.datafix.DataFixesManager;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.datafix.IFixType;
import net.minecraft.util.datafix.IFixableData;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.common.util.CompoundDataFixer;
import net.minecraftforge.common.util.ModFixs;
import org.jetbrains.annotations.NotNull;

public final class StructureUtils {
    private static DataFixer fixer;

    private StructureUtils() {
    }

    public static String calculateMD5(byte[] bytes) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            return DatatypeConverter.printHexBinary((byte[])md.digest(bytes));
        }
        catch (NoSuchAlgorithmException e) {
            Log.getLogger().trace((Object)e);
            return null;
        }
    }

    public static byte[] compress(byte[] data) {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream(data.length);
        try (GZIPOutputStream zipStream = new GZIPOutputStream(byteStream);){
            zipStream.write(data);
        }
        catch (IOException e) {
            Log.getLogger().error("Could not compress the data", (Throwable)e);
        }
        return byteStream.toByteArray();
    }

    public static byte[] uncompress(byte[] data) {
        byte[] buffer = new byte[1024];
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (ByteArrayInputStream byteStream = new ByteArrayInputStream(data);
             GZIPInputStream zipStream = new GZIPInputStream(byteStream);){
            int len;
            while ((len = zipStream.read(buffer)) > 0) {
                out.write(buffer, 0, len);
            }
        }
        catch (IOException e) {
            Log.getLogger().warn("Could not uncompress data", (Throwable)e);
        }
        return out.toByteArray();
    }

    public static String calculateMD5(InputStream stream) {
        if (stream == null) {
            Log.getLogger().error("Structure.calculateMD5: stream is null, this should not happen");
            return null;
        }
        return StructureUtils.calculateMD5(StructureLoadingUtils.getStreamAsByteArray(stream));
    }

    public static Vec3d transformedVec3d(PlacementSettings settings, Vec3d vec) {
        Mirror mirrorIn = settings.getMirror();
        Rotation rotationIn = settings.getRotation();
        double xCoord = vec.field_72450_a;
        double yCoord = vec.field_72448_b;
        double zCoord = vec.field_72449_c;
        boolean flag = true;
        switch (mirrorIn) {
            case LEFT_RIGHT: {
                zCoord = 1.0 - zCoord;
                break;
            }
            case FRONT_BACK: {
                xCoord = 1.0 - xCoord;
                break;
            }
            default: {
                flag = false;
            }
        }
        switch (rotationIn) {
            case COUNTERCLOCKWISE_90: {
                return new Vec3d(zCoord, yCoord, 1.0 - xCoord);
            }
            case CLOCKWISE_90: {
                return new Vec3d(1.0 - zCoord, yCoord, xCoord);
            }
            case CLOCKWISE_180: {
                return new Vec3d(1.0 - xCoord, yCoord, 1.0 - zCoord);
            }
        }
        return flag ? new Vec3d(xCoord, yCoord, zCoord) : vec;
    }

    public static DataFixer getFixer() {
        if (fixer == null) {
            fixer = DataFixesManager.func_188279_a();
            ModFixs fixs = ((CompoundDataFixer)fixer).init("structurize", 1);
            fixs.registerFix((IFixType)FixTypes.STRUCTURE, new IFixableData(){

                public int func_188216_a() {
                    return 1;
                }

                @NotNull
                public NBTTagCompound func_188217_a(@NotNull NBTTagCompound compound) {
                    if (compound.func_74764_b("palette")) {
                        NBTTagList list = compound.func_150295_c("palette", 10);
                        for (NBTBase listCompound : list) {
                            String structurizeName;
                            String name;
                            if (!(listCompound instanceof NBTTagCompound) || !((NBTTagCompound)listCompound).func_74764_b("Name") || !(name = ((NBTTagCompound)listCompound).func_74779_i("Name")).contains("minecolonies") || Block.func_149684_b((String)name) != null || Block.func_149684_b((String)(structurizeName = "structurize" + name.substring("minecolonies".length()))) == null) continue;
                            ((NBTTagCompound)listCompound).func_74778_a("Name", structurizeName);
                        }
                    }
                    return compound;
                }
            });
        }
        return fixer;
    }
}

