/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.utils.portals.description;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import divinerpg.objects.blocks.BlockModPortal;
import divinerpg.registry.BlockRegistry;
import divinerpg.utils.portals.description.IPortalDescription;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.BlockWorldState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.block.state.pattern.BlockPattern;
import net.minecraft.block.state.pattern.BlockStateMatcher;
import net.minecraft.block.state.pattern.FactoryBlockPattern;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class VetheaPortalDescription
implements IPortalDescription {
    private final BlockPattern fullPattern = FactoryBlockPattern.func_177660_a().func_177659_a(new String[]{"??x??"}).func_177659_a(new String[]{"?x.x?"}).func_177659_a(new String[]{"x...x"}).func_177659_a(new String[]{"?x.x?"}).func_177659_a(new String[]{"??x??"}).func_177662_a('?', BlockWorldState.func_177510_a((Predicate)BlockStateMatcher.field_185928_a)).func_177662_a('x', BlockWorldState.func_177510_a((Predicate)BlockStateMatcher.func_177638_a((Block)this.getFrame()))).func_177662_a('.', BlockWorldState.func_177510_a((Predicate)BlockStateMatcher.func_177638_a((Block)this.getPortal()))).func_177661_b();
    private final BlockPattern framePattern = FactoryBlockPattern.func_177660_a().func_177659_a(new String[]{"??x??"}).func_177659_a(new String[]{"?x.x?"}).func_177659_a(new String[]{"x...x"}).func_177659_a(new String[]{"?x.x?"}).func_177659_a(new String[]{"??x??"}).func_177662_a('?', BlockWorldState.func_177510_a((Predicate)BlockStateMatcher.field_185928_a)).func_177662_a('.', BlockWorldState.func_177510_a((Predicate)BlockStateMatcher.field_185928_a)).func_177662_a('x', BlockWorldState.func_177510_a((Predicate)BlockStateMatcher.func_177638_a((Block)this.getFrame()))).func_177661_b();

    @Override
    public Block getFrame() {
        return BlockRegistry.mortumBlock;
    }

    @Override
    public Block getPortal() {
        return BlockRegistry.vetheaPortal;
    }

    @Override
    public BlockPos getMaxSize() {
        return new BlockPos(5, 5, 5);
    }

    @Override
    @Nonnull
    public List<BlockPos> checkChunk(World world, BlockPos min, BlockPos max) {
        ArrayList<BlockPos> result = new ArrayList<BlockPos>();
        BlockPos middle = min.func_177982_a(2, 2, 2);
        Iterable poses = Iterables.concat((Iterable)BlockPos.func_177980_a((BlockPos)middle.func_177982_a(-2, 0, 0), (BlockPos)middle.func_177982_a(2, 0, 0)), (Iterable)BlockPos.func_177980_a((BlockPos)middle.func_177982_a(0, 0, -2), (BlockPos)middle.func_177982_a(0, 0, 2)));
        poses.forEach(x -> {
            Block block = world.func_180495_p(x).func_177230_c();
            if (block == this.getFrame() || block == this.getPortal()) {
                result.add((BlockPos)x);
            }
        });
        return result;
    }

    @Override
    public BlockPattern.PatternHelper createPortal(World world, BlockPos pos) {
        pos = pos.func_177982_a(2, 2, 0);
        for (int x = -2; x <= 2; ++x) {
            for (int y = -2; y <= 2; ++y) {
                BlockPos current = pos.func_177982_a(x, y, 0);
                int distance = Math.abs(x) + Math.abs(y);
                if (distance != 2) continue;
                world.func_175656_a(current, this.getFrame().func_176223_P());
            }
        }
        this.lightPortal(world, pos, EnumFacing.EAST);
        return this.matchWorkingPortal(world, pos);
    }

    @Override
    public void lightPortal(World world, BlockPattern.PatternHelper frameMatch) {
        this.lightPortal(world, this.getMiddle(frameMatch), frameMatch.func_177668_c().func_176735_f());
    }

    private BlockPos getMiddle(BlockPattern.PatternHelper frameMatch) {
        BlockPos topLeft = frameMatch.func_181117_a();
        EnumFacing up = frameMatch.func_177669_b();
        EnumFacing corner = frameMatch.func_177668_c().func_176735_f();
        if (up.func_176743_c() == EnumFacing.AxisDirection.NEGATIVE) {
            corner = corner.func_176734_d();
        }
        BlockPos middle = topLeft.func_177967_a(up, 2).func_177967_a(corner, 2);
        return middle;
    }

    private void lightPortal(World world, BlockPos middle, EnumFacing horizontal) {
        IBlockState portal = this.getPortal().func_176223_P().func_177226_a(BlockModPortal.AXIS, (Comparable)horizontal.func_176740_k());
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                BlockPos current = middle.func_177982_a(0, y, 0).func_177967_a(horizontal, x);
                int distance = Math.abs(x) + Math.abs(y);
                if (distance > 1) continue;
                world.func_175656_a(current, portal);
            }
        }
    }

    @Override
    @Nullable
    public BlockPattern.PatternHelper matchWorkingPortal(World world, BlockPos pos) {
        return this.fullPattern.func_177681_a(world, pos);
    }

    @Override
    @Nullable
    public BlockPattern.PatternHelper matchFrame(World world, BlockPos pos) {
        return this.framePattern.func_177681_a(world, pos);
    }
}

