/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.utils.portals.description;

import divinerpg.dimensions.arcana.ArcanaRooms;
import divinerpg.dimensions.arcana.mazegen.ArcanaMazeGenerator;
import divinerpg.dimensions.arcana.mazegen.Cell;
import divinerpg.registry.BlockRegistry;
import divinerpg.registry.DimensionRegistry;
import divinerpg.structure.arcana.ArcanaStructureHandler;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.ITeleporter;

public class ArcanaTeleporter
implements ITeleporter {
    public static final int PORTAL_SEARCH_CHUNK_RADIUS = 4;
    protected WorldServer world;
    protected Random random = new Random();

    public ArcanaTeleporter(WorldServer var1) {
        this.world = var1;
    }

    public void placeInPortal(Entity entity, float rotationYaw) {
        if (this.world.field_73011_w.func_186058_p().func_186068_a() == DimensionRegistry.arcanaDimension.func_186068_a()) {
            int chunkX = (MathHelper.func_76128_c((double)entity.field_70165_t) & 0xFFFFFFF0) / 16;
            int chunkZ = (MathHelper.func_76128_c((double)entity.field_70161_v) & 0xFFFFFFF0) / 16;
            if (!this.placeInExistingPortal(entity, rotationYaw)) {
                this.makePortalRoom(chunkX, chunkZ);
                this.placeInExistingPortal(entity, rotationYaw);
            }
        } else {
            int chunkZ;
            int chunkX = (MathHelper.func_76128_c((double)entity.field_70165_t) - 8 & 0xFFFFFFF0) / 16;
            BlockPos pos = this.locateOverworldPortal((World)this.world, chunkX, chunkZ = (MathHelper.func_76128_c((double)entity.field_70161_v) - 8 & 0xFFFFFFF0) / 16);
            if (pos == null) {
                BlockPos spawnPoint = null;
                if (entity instanceof EntityPlayer) {
                    EntityPlayer player = (EntityPlayer)entity;
                    spawnPoint = player.getBedLocation(0);
                }
                if (spawnPoint == null) {
                    spawnPoint = this.world.func_175672_r(this.world.func_175694_M());
                }
                entity.func_174828_a(spawnPoint, entity.field_70177_z, entity.field_70125_A);
            } else {
                entity.func_174828_a(pos, entity.field_70177_z, entity.field_70125_A);
            }
        }
    }

    private BlockPos locateOverworldPortal(World world, int chunkX, int chunkZ) {
        BlockPos pos = null;
        for (int radius = 0; radius <= 4 && (pos = this.locatePortalByRadius(world, chunkX, chunkZ, radius)) == null; ++radius) {
        }
        return pos;
    }

    @Nullable
    private BlockPos locatePortalByRadius(World world, int chunkX, int chunkZ, int radius) {
        BlockPos result;
        for (int currentChunkX = chunkX - radius; currentChunkX <= chunkX + radius; ++currentChunkX) {
            result = this.locatePortalInChunk(world, currentChunkX, chunkZ - radius);
            if (result != null) {
                return result;
            }
            result = this.locatePortalInChunk(world, currentChunkX, chunkZ + radius);
            if (result == null) continue;
            return result;
        }
        for (int currentChunkZ = chunkZ - radius + 1; currentChunkZ <= chunkZ + radius - 1; ++currentChunkZ) {
            result = this.locatePortalInChunk(world, chunkX - radius, currentChunkZ);
            if (result != null) {
                return result;
            }
            result = this.locatePortalInChunk(world, chunkX + radius, currentChunkZ);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Nullable
    private BlockPos locatePortalInChunk(World world, int chunkX, int chunkZ) {
        BlockPos.MutableBlockPos searchPos = new BlockPos.MutableBlockPos();
        int baseX = chunkX * 16;
        int baseZ = chunkZ * 16;
        for (int y = 0; y < 256; ++y) {
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    searchPos.func_181079_c(baseX + x, y, baseZ + z);
                    if (world.func_180495_p((BlockPos)searchPos).func_177230_c() != BlockRegistry.arcanaPortal) continue;
                    return searchPos;
                }
            }
        }
        return null;
    }

    public boolean placeInExistingPortal(Entity entity, float rotationYaw) {
        if (this.world.field_73011_w.func_186058_p().func_186068_a() == DimensionRegistry.arcanaDimension.func_186068_a()) {
            int chunkZ;
            int portalLocationZ;
            int portalLocationY;
            int chunkX = (MathHelper.func_76128_c((double)entity.field_70165_t) & 0xFFFFFFF0) / 16;
            int portalLocationX = chunkX * 16 + 6 + 8;
            if (this.world.func_180495_p(new BlockPos(portalLocationX, portalLocationY = 9, portalLocationZ = (chunkZ = (MathHelper.func_76128_c((double)entity.field_70161_v) & 0xFFFFFFF0) / 16) * 16 + 5 + 8)).func_177230_c() == BlockRegistry.arcanaHardPortalFrame) {
                entity.func_70012_b((double)portalLocationX + 1.5, (double)portalLocationY, (double)portalLocationZ + 2.5, entity.field_70177_z, 0.0f);
                entity.field_70179_y = 0.0;
                entity.field_70181_x = 0.0;
                entity.field_70159_w = 0.0;
                return true;
            }
            BlockPos.MutableBlockPos searchPos = new BlockPos.MutableBlockPos();
            for (int searchX = portalLocationX - 64; searchX < portalLocationX + 64; searchX += 16) {
                for (int searchZ = portalLocationZ - 64; searchZ < portalLocationZ + 64; searchZ += 16) {
                    searchPos.func_181079_c(searchX, portalLocationY, searchZ);
                    if (this.world.func_180495_p((BlockPos)searchPos).func_177230_c() != BlockRegistry.arcanaHardPortalFrame) continue;
                    entity.func_70012_b((double)searchX + 1.5, (double)portalLocationY, (double)searchZ + 2.5, entity.field_70177_z, 0.0f);
                    entity.field_70179_y = 0.0;
                    entity.field_70181_x = 0.0;
                    entity.field_70159_w = 0.0;
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public void makePortalRoom(int chunkX, int chunkZ) {
        Cell cell = ArcanaMazeGenerator.obtainMazePiece(chunkX, chunkZ, this.world.func_72905_C());
        ArcanaStructureHandler portalRoom = ArcanaRooms.getPortalRoomByType(cell.getPieceType());
        portalRoom.generateWithRotation((World)this.world, this.random, new BlockPos(chunkX * 16 + 8, 8, chunkZ * 16 + 8), cell.getRotation());
    }

    public void placeEntity(World world, Entity entity, float yaw) {
        if (entity instanceof EntityPlayerMP) {
            this.placeInPortal(entity, yaw);
        } else {
            this.placeInExistingPortal(entity, yaw);
        }
    }
}

