/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.utils.portals;

import divinerpg.utils.portals.description.IPortalDescription;
import javax.annotation.Nullable;
import net.minecraft.block.state.pattern.BlockPattern;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class WorkingPortalInfo {
    private final BlockPos pos;
    private final int reCheck = 400;
    private BlockPattern.PatternHelper match;
    private long lastUpdTick;

    public WorkingPortalInfo(World world, BlockPos pos, BlockPattern.PatternHelper match) {
        this.pos = pos;
        this.match = match;
        this.lastUpdTick = world.func_82737_E() + 400L;
    }

    public boolean isWorking(World world, IPortalDescription description) {
        long time;
        if (this.match != null && (time = world.func_82737_E()) > this.lastUpdTick) {
            this.lastUpdTick = time + 400L;
            this.match = description.matchWorkingPortal(world, this.pos);
        }
        return this.match != null;
    }

    public boolean canUse(BlockPos pos, int distance) {
        return Math.sqrt(pos.func_177951_i((Vec3i)pos)) <= (double)distance;
    }

    @Nullable
    public BlockPattern.PatternHelper getMatch() {
        return this.match;
    }
}

