/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.utils.portals;

import divinerpg.compat.baubles.BaublesCompat;
import divinerpg.config.GeneralConfig;
import divinerpg.registry.DimensionRegistry;
import divinerpg.utils.NbtUtil;
import divinerpg.utils.PositionHelper;
import divinerpg.utils.portals.ServerPortal;
import divinerpg.utils.portals.WorkingPortalInfo;
import divinerpg.utils.portals.description.IPortalDescription;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.state.pattern.BlockPattern;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityTravelToDimensionEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class VetheaPortal
extends ServerPortal {
    private final String BedKey = "VetheaBedPos";
    private final String BedDimKey = "VetheaBedDimension";

    public VetheaPortal(int radius, int recheckDelay) {
        super(radius, recheckDelay);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onDimensionChange(EntityTravelToDimensionEvent e) {
        if (e.isCanceled() || !(e.getEntity() instanceof EntityPlayer)) {
            return;
        }
        int sourceDimension = e.getEntity().func_130014_f_().field_73011_w.getDimension();
        int destinationDimension = e.getDimension();
        int vetheaID = GeneralConfig.dimensionIDs.vetheaDimensionID;
        if (vetheaID != sourceDimension && vetheaID != destinationDimension) {
            return;
        }
        EntityPlayer player = (EntityPlayer)e.getEntity();
        NBTTagCompound tag = NbtUtil.getPersistedDivineTag(player);
        List<String> tagNames = Arrays.asList("OverworldInv", "VetheaInv");
        if (sourceDimension == vetheaID) {
            Collections.reverse(tagNames);
        }
        String saveTo = tagNames.get(0);
        tag.func_74782_a(saveTo, (NBTBase)player.field_71071_by.func_70442_a(new NBTTagList()));
        player.field_71071_by.func_174888_l();
        String loadFrom = tagNames.get(1);
        NBTBase newDimensionNBT = tag.func_74781_a(loadFrom);
        if (newDimensionNBT instanceof NBTTagList) {
            player.field_71071_by.func_70443_b((NBTTagList)newDimensionNBT);
        }
        player.field_71069_bz.func_75142_b();
        if (Loader.isModLoaded((String)"baubles")) {
            BaublesCompat.changeBaubles(player, tag, sourceDimension == vetheaID);
        }
    }

    @Override
    public void placeEntity(World world, Entity entity, float yaw) {
        DimensionType destination = world.field_73011_w.func_186058_p();
        if (destination != DimensionRegistry.vetheaDimension) {
            if (entity instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)entity;
                Tuple posTuple = NbtUtil.tryReaPosition(NbtUtil.getPersistedDivineTag(player), "VetheaBedDimension", "VetheaBedPos");
                if (posTuple == null) {
                    BlockPos bedPos = player.getBedLocation(destination.func_186068_a());
                    if (bedPos == null) {
                        bedPos = world.func_175694_M();
                    }
                    posTuple = new Tuple((Object)destination, (Object)bedPos);
                }
                BlockPos pos = (BlockPos)posTuple.func_76340_b();
                if (player instanceof EntityPlayerMP) {
                    ((EntityPlayerMP)player).field_71135_a.func_147364_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), yaw, player.field_70125_A);
                } else {
                    entity.func_70634_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
                }
            } else {
                BlockPos pos = world.func_175694_M();
                entity.func_70634_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
            }
            return;
        }
        if (entity instanceof EntityPlayer) {
            NBTTagCompound tag = NbtUtil.getPersistedDivineTag((EntityPlayer)entity);
            tag.func_74778_a("VetheaBedDimension", entity.func_130014_f_().field_73011_w.func_186058_p().func_186065_b());
            tag.func_74772_a("VetheaBedPos", entity.func_180425_c().func_177986_g());
        }
        super.placeEntity(world, entity, yaw);
        if (entity instanceof EntityPlayer) {
            ((EntityPlayer)entity).setSpawnChunk(entity.func_180425_c(), true, world.field_73011_w.func_186058_p().func_186068_a());
        }
    }

    @Override
    @Nullable
    protected BlockPattern.PatternHelper findFromCache(World world, IPortalDescription description, List<WorkingPortalInfo> activePortals, BlockPos pos, int radius) {
        return super.findFromCache(world, description, activePortals, pos, 1024);
    }

    @Override
    protected BlockPos findSuitablePosition(World destination, IPortalDescription description, Entity e, int radius) {
        int floorHeight = 17;
        BlockPos center = new BlockPos(e.field_70165_t, (double)floorHeight, e.field_70161_v);
        BlockPos portalSize = description.getMaxSize();
        return PositionHelper.searchInRadius(destination, center, radius, pos -> {
            if (pos.func_177956_o() != floorHeight) {
                return false;
            }
            return this.isAirBlocks(destination, new AxisAlignedBB(pos, pos.func_177971_a((Vec3i)portalSize)));
        });
    }
}

