/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.utils;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.DimensionType;

public class NbtUtil {
    public static List<NBTTagCompound> read(NBTTagCompound source, String name) {
        NBTBase raw;
        ArrayList<NBTTagCompound> result = new ArrayList<NBTTagCompound>();
        if (source != null && source.func_74764_b(name) && (raw = source.func_74781_a(name)) instanceof NBTTagList) {
            ((NBTTagList)raw).iterator().forEachRemaining(x -> {
                if (x instanceof NBTTagCompound) {
                    result.add((NBTTagCompound)x);
                }
            });
        }
        return result;
    }

    public static void tryWrite(NBTTagCompound source, String name, List<NBTTagCompound> tags) {
        if (tags == null || tags.isEmpty()) {
            return;
        }
        NBTTagList result = new NBTTagList();
        tags.forEach(arg_0 -> ((NBTTagList)result).func_74742_a(arg_0));
        source.func_74782_a(name, (NBTBase)result);
    }

    public static void writeChunkPos(NBTTagCompound source, ChunkPos pos) {
        if (source != null && pos != null) {
            source.func_74783_a("ChunkPositions", new int[]{pos.field_77276_a, pos.field_77275_b});
        }
    }

    public static ChunkPos readChunkPos(NBTTagCompound source) {
        if (source == null || !source.func_74764_b("ChunkPositions")) {
            return new ChunkPos(0, 0);
        }
        int[] poses = source.func_74759_k("ChunkPositions");
        if (poses.length != 2) {
            return new ChunkPos(0, 0);
        }
        return new ChunkPos(poses[0], poses[1]);
    }

    public static BlockPos readPos(NBTTagCompound tag) {
        NBTBase raw;
        if (tag == null) {
            return BlockPos.field_177992_a;
        }
        if (tag.func_74764_b("Pos") && (raw = tag.func_74781_a("Pos")) instanceof NBTTagList) {
            NBTTagList list = (NBTTagList)raw;
            return new BlockPos(list.func_150309_d(0), list.func_150309_d(1), list.func_150309_d(2));
        }
        if (tag.func_74764_b("x") && tag.func_74764_b("y") && tag.func_74764_b("z")) {
            return new BlockPos(tag.func_74762_e("x"), tag.func_74762_e("y"), tag.func_74762_e("z"));
        }
        return BlockPos.field_177992_a;
    }

    public static NBTTagCompound getPersistedDivineTag(@Nonnull EntityPlayer e) {
        NBTTagCompound persistantData;
        NBTTagCompound playerData = e.getEntityData();
        if (!playerData.func_74764_b("PlayerPersisted")) {
            playerData.func_74782_a("PlayerPersisted", (NBTBase)new NBTTagCompound());
        }
        if (!(persistantData = playerData.func_74775_l("PlayerPersisted")).func_74764_b("divinerpg")) {
            persistantData.func_74782_a("divinerpg", (NBTBase)new NBTTagCompound());
        }
        return persistantData.func_74775_l("divinerpg");
    }

    @Nullable
    public static Tuple<DimensionType, BlockPos> tryReaPosition(NBTTagCompound tag, String dimKey, String posKey) {
        if (tag == null || dimKey == null || posKey == null || !tag.func_74764_b(dimKey) || !tag.func_74764_b(posKey)) {
            return null;
        }
        return new Tuple((Object)DimensionType.func_193417_a((String)tag.func_74779_i(dimKey)), (Object)BlockPos.func_177969_a((long)tag.func_74763_f(posKey)));
    }
}

