/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.structure.base;

import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.gen.structure.StructureComponentTemplate;
import net.minecraft.world.gen.structure.StructureStart;
import net.minecraft.world.gen.structure.template.TemplateManager;

public abstract class DivineStructureStart
extends StructureStart {
    public DivineStructureStart() {
    }

    public DivineStructureStart(ResourceLocation location, TemplateManager manager, Rotation rotation, int chunkX, int altitude, int chunkZ, int structureSizeX, int structureSizeZ) {
        super(chunkX, chunkZ);
        this.setupComponents(location, manager, rotation, chunkX, altitude, chunkZ, structureSizeX, structureSizeZ);
        this.func_75072_c();
    }

    private void setupComponents(ResourceLocation location, TemplateManager manager, Rotation rotation, int chunkX, int y, int chunkZ, int structureSizeX, int structureSizeZ) {
        for (int x = 0; x < structureSizeX; ++x) {
            for (int z = 0; z < structureSizeZ; ++z) {
                String fileName = "[" + x + ", " + z + "]";
                ResourceLocation partLocation = new ResourceLocation(location.func_110624_b(), location.func_110623_a() + "/" + fileName);
                int rotationXOffset = x;
                int rotationZOffset = z;
                if (rotation == Rotation.NONE) {
                    rotationXOffset = x;
                    rotationZOffset = z;
                } else if (rotation == Rotation.CLOCKWISE_90) {
                    rotationXOffset = -z;
                    rotationZOffset = x;
                } else if (rotation == Rotation.CLOCKWISE_180) {
                    rotationXOffset = -x;
                    rotationZOffset = -z;
                } else if (rotation == Rotation.COUNTERCLOCKWISE_90) {
                    rotationXOffset = z;
                    rotationZOffset = -x;
                }
                BlockPos pos = new ChunkPos(chunkX + rotationXOffset, chunkZ + rotationZOffset).func_180331_a(0, y, 0);
                this.field_75075_a.add(this.getComponent(manager, partLocation, rotation, pos));
            }
        }
    }

    protected abstract StructureComponentTemplate getComponent(TemplateManager var1, ResourceLocation var2, Rotation var3, BlockPos var4);
}

