/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.structure.arcana;

import divinerpg.DivineRPG;
import divinerpg.utils.IStructure;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraft.world.gen.structure.template.TemplateManager;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class ArcanaStructureHandler
extends WorldGenerator
implements IStructure {
    protected String structureName;

    public ArcanaStructureHandler(String name) {
        this.structureName = name;
    }

    public String getName() {
        return this.structureName;
    }

    public boolean generateWithRotation(World worldIn, Random rand, BlockPos position, Rotation rotation) {
        BlockPos size = this.getSize(worldIn);
        BlockPos adjustedPosition = this.adjustForRotation(position, size, rotation);
        this.generateStructure(worldIn, rand, rotation, adjustedPosition);
        return true;
    }

    public boolean func_180709_b(World worldIn, Random rand, BlockPos position) {
        return false;
    }

    public void generateStructure(World world, Random random, Rotation rotation, BlockPos pos) {
        Template template = this.load(world);
        if (template != null) {
            PlacementSettings placementSettings = this.getSettings(pos, rotation);
            template.func_186253_b(world, pos, placementSettings);
            Map map = template.func_186258_a(pos, placementSettings);
            Iterator var16 = map.entrySet().iterator();
            if (var16.hasNext()) {
                this.handleDataMarkers(world, random, var16);
            }
        }
    }

    private BlockPos adjustForRotation(BlockPos position, BlockPos size, Rotation rotation) {
        switch (rotation) {
            case NONE: {
                return position;
            }
            case CLOCKWISE_90: {
                return position.func_177982_a(size.func_177952_p() - 1, 0, 0);
            }
            case CLOCKWISE_180: {
                return position.func_177982_a(size.func_177958_n() - 1, 0, size.func_177952_p() - 1);
            }
            case COUNTERCLOCKWISE_90: {
                return position.func_177982_a(0, 0, size.func_177958_n() - 1);
            }
        }
        DivineRPG.logger.warn("Invalid structure rotation passed in somehow, please report this.");
        return position;
    }

    public void handleDataMarkers(World world, Random random, Iterator iterator) {
    }

    @Override
    public WorldServer getWorldServer(World world) {
        return FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(world.field_73011_w.getDimension());
    }

    @Override
    public PlacementSettings getSettings(BlockPos pos, Rotation rotation) {
        return new PlacementSettings().func_186222_a(false).func_186226_b(false).func_186214_a(Mirror.NONE).func_186220_a(rotation);
    }

    @Override
    public BlockPos getSize(World world) {
        Template template = this.load(world);
        if (template != null) {
            return template.func_186259_a();
        }
        return null;
    }

    @Nullable
    private Template load(World world) {
        MinecraftServer mcServer = world.func_73046_m();
        TemplateManager manager = this.getWorldServer(world).func_184163_y();
        ResourceLocation location = new ResourceLocation("divinerpg", this.structureName);
        return manager.func_189942_b(mcServer, location);
    }
}

