/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.registry;

import divinerpg.DivineRPG;
import divinerpg.api.ArmorHandlers;
import divinerpg.api.DivineAPI;
import divinerpg.api.arcana.IArcana;
import divinerpg.api.armor.IEquipped;
import divinerpg.api.armor.cap.IArmorPowers;
import divinerpg.api.armor.registry.IArmorDescription;
import divinerpg.capabilities.armor.ArmorDescription;
import divinerpg.objects.blocks.twilight.BlockTwilightOre;
import divinerpg.registry.ArmorRegistry;
import divinerpg.registry.DimensionRegistry;
import divinerpg.registry.ItemRegistry;
import divinerpg.utils.Utils;
import java.util.Collections;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.registries.IForgeRegistry;

@Mod.EventBusSubscriber
public class ArmorDescriptionRegistry {
    public static final ResourceLocation AWAKENED_HALITE = new ResourceLocation("divinerpg", "awakened_halite");
    public static final ResourceLocation CORRUPTED = new ResourceLocation("divinerpg", "corrupted");
    public static final ResourceLocation JACKOMAN = new ResourceLocation("divinerpg", "jackoman");

    @SubscribeEvent
    public static void registerArmors(RegistryEvent.Register<IArmorDescription> registryEvent) {
        DivineRPG.logger.info("Registering armor descriptions");
        IForgeRegistry registry = registryEvent.getRegistry();
        registry.register(new ArmorDescription().withPossibleItems(EntityEquipmentSlot.HEAD, ArmorRegistry.rupeeHelmet, ArmorRegistry.blueRupeeHelmet, ArmorRegistry.grayRupeeHelmet, ArmorRegistry.greenRupeeHelmet, ArmorRegistry.redRupeeHelmet, ArmorRegistry.yellowRupeeHelmet).withPossibleItems(EntityEquipmentSlot.CHEST, ArmorRegistry.rupeeChestplate, ArmorRegistry.blueRupeeChestplate, ArmorRegistry.grayRupeeChestplate, ArmorRegistry.greenRupeeChestplate, ArmorRegistry.redRupeeChestplate, ArmorRegistry.yellowRupeeChestplate).withPossibleItems(EntityEquipmentSlot.LEGS, ArmorRegistry.rupeeLeggings, ArmorRegistry.blueRupeeLeggings, ArmorRegistry.grayRupeeLeggings, ArmorRegistry.greenRupeeLeggings, ArmorRegistry.redRupeeLeggings, ArmorRegistry.yellowRupeeLeggings).withPossibleItems(EntityEquipmentSlot.FEET, ArmorRegistry.rupeeBoots, ArmorRegistry.blueRupeeBoots, ArmorRegistry.grayRupeeBoots, ArmorRegistry.greenRupeeBoots, ArmorRegistry.redRupeeBoots, ArmorRegistry.yellowRupeeBoots).withHandler(LivingHurtEvent.class, e -> ArmorHandlers.onPlayerReceiveDamage(e, ArmorHandlers::isMeeleeDamage, f -> {
            float multiplier = 0.25f;
            return Float.valueOf(f.floatValue() * multiplier);
        })).setRegistryName("divinerpg", "rupee"));
        registry.register(new ArmorDescription().withPossibleItems(EntityEquipmentSlot.HEAD, ArmorRegistry.enderHelmet, ArmorRegistry.blueEnderHelmet, ArmorRegistry.grayEnderHelmet, ArmorRegistry.greenEnderHelmet, ArmorRegistry.redEnderHelmet, ArmorRegistry.yellowEnderHelmet).withPossibleItems(EntityEquipmentSlot.CHEST, ArmorRegistry.enderChestplate, ArmorRegistry.blueEnderChestplate, ArmorRegistry.grayEnderChestplate, ArmorRegistry.greenEnderChestplate, ArmorRegistry.redEnderChestplate, ArmorRegistry.yellowEnderChestplate).withPossibleItems(EntityEquipmentSlot.LEGS, ArmorRegistry.enderLeggings, ArmorRegistry.blueEnderLeggings, ArmorRegistry.grayEnderLeggings, ArmorRegistry.greenEnderLeggings, ArmorRegistry.redEnderLeggings, ArmorRegistry.yellowEnderLeggings).withPossibleItems(EntityEquipmentSlot.FEET, ArmorRegistry.enderBoots, ArmorRegistry.blueEnderBoots, ArmorRegistry.grayEnderBoots, ArmorRegistry.greenEnderBoots, ArmorRegistry.redEnderBoots, ArmorRegistry.yellowEnderBoots).withHandler(LivingHurtEvent.class, e -> ArmorHandlers.onCancelPlayerReceiveDamage(e, DamageSource::func_94541_c)).withHandler(EnderTeleportEvent.class, e -> e.setAttackDamage(0.0f)).setRegistryName("divinerpg", "ender"));
        registry.register(new ArmorDescription(ArmorHandlers::onCanFlyChanged).withPossibleItems(EntityEquipmentSlot.HEAD, ArmorRegistry.angelicHelmet).withPossibleItems(EntityEquipmentSlot.CHEST, ArmorRegistry.angelicChestplate).withPossibleItems(EntityEquipmentSlot.LEGS, ArmorRegistry.angelicLeggings).withPossibleItems(EntityEquipmentSlot.FEET, ArmorRegistry.angelicBoots).withHandler(TickEvent.PlayerTickEvent.class, e -> ArmorHandlers.onCanFlyChanged((EntityLivingBase)e.player, true)).setRegistryName("divinerpg", "angelic"));
        registry.register(new ArmorDescription().withPossibleItems(EntityEquipmentSlot.HEAD, ArmorRegistry.bedrockHelmet).withPossibleItems(EntityEquipmentSlot.CHEST, ArmorRegistry.bedrockChestplate).withPossibleItems(EntityEquipmentSlot.LEGS, ArmorRegistry.bedrockLeggings).withPossibleItems(EntityEquipmentSlot.FEET, ArmorRegistry.bedrockBoots).withHandler(LivingHurtEvent.class, event -> ArmorHandlers.onCancelPlayerReceiveDamage(event, source -> source.func_76347_k() || source.func_94541_c() || source == DamageSource.field_76371_c)).withHandler(TickEvent.PlayerTickEvent.class, event -> {
            event.player.func_70066_B();
            event.player.func_70690_d(new PotionEffect(MobEffects.field_76426_n, 40, 0, true, false));
        }).setRegistryName("divinerpg", "bedrock"));
        registry.register(new ArmorDescription().withPossibleItems(EntityEquipmentSlot.HEAD, ArmorRegistry.divineHelmet).withPossibleItems(EntityEquipmentSlot.CHEST, ArmorRegistry.divineChestplate).withPossibleItems(EntityEquipmentSlot.LEGS, ArmorRegistry.divineLeggings).withPossibleItems(EntityEquipmentSlot.FEET, ArmorRegistry.divineBoots).withHandler(LivingHurtEvent.class, event -> ArmorHandlers.onAddMeleeDamage(event, amount -> Float.valueOf(amount.floatValue() + 6.0f))).withHandler(LivingEvent.LivingJumpEvent.class, event -> event.getEntityLiving().func_70024_g(0.0, 0.2, 0.0)).withHandler(LivingFallEvent.class, ArmorHandlers::disableFallDamage).setRegistryName("divinerpg", "divine"));
        IEquipped stopSpeedUp = (player, isFullEquipped) -> {
            if (!isFullEquipped) {
                ArmorHandlers.removeSpeed(player);
            }
        };
        registry.register(new ArmorDescription(stopSpeedUp).withPossibleItems(EntityEquipmentSlot.HEAD, ArmorRegistry.santaHelmet).withPossibleItems(EntityEquipmentSlot.CHEST, ArmorRegistry.santaChestplate).withPossibleItems(EntityEquipmentSlot.LEGS, ArmorRegistry.santaLeggings).withPossibleItems(EntityEquipmentSlot.FEET, ArmorRegistry.santaBoots).withHandler(LivingHurtEvent.class, event -> {
            if (event.getEntityLiving().field_70170_p.field_73011_w.func_186058_p() == DimensionRegistry.iceikaDimension) {
                ArmorHandlers.onPlayerReceiveDamage(event, ArmorHandlers::isMeeleeDamage, aFloat -> Float.valueOf(aFloat.floatValue() * 0.25f));
                ArmorHandlers.onAddMeleeDamage(event, amount -> Float.valueOf(amount.floatValue() + 6.0f));
            }
        }).withHandler(TickEvent.PlayerTickEvent.class, event -> {
            if (event.player.field_70170_p.field_73011_w.func_186058_p() == DimensionRegistry.iceikaDimension) {
                ArmorHandlers.refillHunger(event);
                ArmorHandlers.speedUpPlayer((EntityLivingBase)event.player, 2.0f, false);
            } else {
                ArmorHandlers.removeSpeed((EntityLivingBase)event.player);
            }
        }).setRegistryName("divinerpg", "santa"));
        registry.register(new ArmorDescription().withPossibleItems(EntityEquipmentSlot.HEAD, ArmorRegistry.skelemanHelmet).withPossibleItems(EntityEquipmentSlot.CHEST, ArmorRegistry.skelemanChestplate).withPossibleItems(EntityEquipmentSlot.LEGS, ArmorRegistry.skelemanLeggings).withPossibleItems(EntityEquipmentSlot.FEET, ArmorRegistry.skelemanBoots).withHandler(TickEvent.PlayerTickEvent.class, ArmorHandlers::refillHunger).setRegistryName(new ResourceLocation("divinerpg", "skeleman")));
        registry.register(new ArmorDescription().withPossibleItems(EntityEquipmentSlot.HEAD, ArmorRegistry.terranHelmet).withPossibleItems(EntityEquipmentSlot.CHEST, ArmorRegistry.terranChestplate).withPossibleItems(EntityEquipmentSlot.LEGS, ArmorRegistry.terranLeggings).withPossibleItems(EntityEquipmentSlot.FEET, ArmorRegistry.terranBoots).withHandler(TickEvent.PlayerTickEvent.class, event -> event.player.func_70690_d(new PotionEffect(MobEffects.field_76422_e, 20, 2, true, false))).setRegistryName(new ResourceLocation("divinerpg", "terrain")));
        registry.register(new ArmorDescription().withPossibleItems(EntityEquipmentSlot.HEAD, ArmorRegistry.frozenHelmet).withPossibleItems(EntityEquipmentSlot.CHEST, ArmorRegistry.frozenChestplate).withPossibleItems(EntityEquipmentSlot.LEGS, ArmorRegistry.frozenLeggings).withPossibleItems(EntityEquipmentSlot.FEET, ArmorRegistry.frozenBoots).withHandler(TickEvent.PlayerTickEvent.class, event -> ArmorHandlers.frozeNearMobs(event, 10, 6)).setRegistryName(new ResourceLocation("divinerpg", "frozen")));
        registry.register(new ArmorDescription(stopSpeedUp).withPossibleItems(EntityEquipmentSlot.HEAD, ArmorRegistry.shadowHelmet).withPossibleItems(EntityEquipmentSlot.CHEST, ArmorRegistry.shadowChestplate).withPossibleItems(EntityEquipmentSlot.LEGS, ArmorRegistry.shadowLeggings).withPossibleItems(EntityEquipmentSlot.FEET, ArmorRegistry.shadowBoots).withHandler(TickEvent.PlayerTickEvent.class, event -> ArmorHandlers.speedUpPlayer((EntityLivingBase)event.player, 3.0f, false)).setRegistryName(new ResourceLocation("divinerpg", "shadow")));
        registry.register(new ArmorDescription().withPossibleItems(EntityEquipmentSlot.HEAD, ArmorRegistry.arlemiteHelmet).withPossibleItems(EntityEquipmentSlot.CHEST, ArmorRegistry.arlemiteChestplate).withPossibleItems(EntityEquipmentSlot.LEGS, ArmorRegistry.arlemiteLeggings).withPossibleItems(EntityEquipmentSlot.FEET, ArmorRegistry.arlemiteBoots).withHandler(LivingHurtEvent.class, event -> ArmorHandlers.onPlayerReceiveDamage(event, source -> source.func_76352_a() || source.field_76373_n.equals("thrown"), aFloat -> {
            float multiplier = 0.2f;
            IArmorPowers powers = DivineAPI.getArmorPowers(event.getEntity());
            if (powers != null && powers.currentItems(EntityEquipmentSlot.OFFHAND).contains(ItemRegistry.arlemite_shield)) {
                multiplier /= 2.0f;
            }
            return Float.valueOf(aFloat.floatValue() * multiplier);
        })).setRegistryName(new ResourceLocation("divinerpg", "arlemite")));
        registry.register(new ArmorDescription().withPossibleItems(EntityEquipmentSlot.HEAD, ArmorRegistry.skythernHelmet).withPossibleItems(EntityEquipmentSlot.CHEST, ArmorRegistry.skythernChestplate).withPossibleItems(EntityEquipmentSlot.LEGS, ArmorRegistry.skythernLeggings).withPossibleItems(EntityEquipmentSlot.FEET, ArmorRegistry.skythernBoots).withHandler(LivingEvent.LivingJumpEvent.class, event -> event.getEntityLiving().func_70024_g(0.0, 0.5, 0.0)).withHandler(LivingFallEvent.class, ArmorHandlers::disableFallDamage).setRegistryName(new ResourceLocation("divinerpg", "skythernm")));
        registry.register(new ArmorDescription().withPossibleItems(EntityEquipmentSlot.HEAD, ArmorRegistry.haliteHelmet).withPossibleItems(EntityEquipmentSlot.CHEST, ArmorRegistry.haliteChestplate).withPossibleItems(EntityEquipmentSlot.LEGS, ArmorRegistry.haliteLeggings).withPossibleItems(EntityEquipmentSlot.FEET, ArmorRegistry.haliteBoots).withHandler(LivingHurtEvent.class, event -> ArmorHandlers.onAddMeleeDamage(event, amount -> Float.valueOf(amount.floatValue() + 16.0f))).setRegistryName(new ResourceLocation("divinerpg", "halite")));
        registry.register(new ArmorDescription().withPossibleItems(EntityEquipmentSlot.HEAD, ArmorRegistry.awakened_haliteHelmet).withPossibleItems(EntityEquipmentSlot.CHEST, ArmorRegistry.awakened_haliteChestplate).withPossibleItems(EntityEquipmentSlot.LEGS, ArmorRegistry.awakened_haliteLeggings).withPossibleItems(EntityEquipmentSlot.FEET, ArmorRegistry.awakened_haliteBoots).withHandler(LivingHurtEvent.class, event -> ArmorHandlers.onAddMeleeDamage(event, amount -> Float.valueOf(amount.floatValue() + 20.0f))).withHandler(LivingHurtEvent.class, event -> ArmorHandlers.onAddRangedDamage(event, AWAKENED_HALITE, x -> Float.valueOf(x.floatValue() * 1.5f))).setRegistryName(AWAKENED_HALITE));
        IEquipped stopSpeedUpInWater = (player, isFullEquipped) -> {
            if (!isFullEquipped) {
                ArmorHandlers.speedUpInWater(player, 0.0f, true);
            }
        };
        registry.register(new ArmorDescription(stopSpeedUpInWater).withPossibleItems(EntityEquipmentSlot.HEAD, ArmorRegistry.aquastriveHelmet).withPossibleItems(EntityEquipmentSlot.CHEST, ArmorRegistry.aquastriveChestplate).withPossibleItems(EntityEquipmentSlot.LEGS, ArmorRegistry.aquastriveLeggings).withPossibleItems(EntityEquipmentSlot.FEET, ArmorRegistry.aquastriveBoots).withHandler(TickEvent.PlayerTickEvent.class, event -> ArmorHandlers.speedUpInWater((EntityLivingBase)event.player, 5.0f, false)).withHandler(LivingHurtEvent.class, event -> ArmorHandlers.onCancelPlayerReceiveDamage(event, source -> source.equals(DamageSource.field_76369_e))).withHandler(TickEvent.PlayerTickEvent.class, ArmorHandlers::breatheUnderwater).setRegistryName(new ResourceLocation("divinerpg", "aqua")));
        registry.register(new ArmorDescription().withPossibleItems(EntityEquipmentSlot.HEAD, ArmorRegistry.krakenHelmet).withPossibleItems(EntityEquipmentSlot.CHEST, ArmorRegistry.krakenChestplate).withPossibleItems(EntityEquipmentSlot.LEGS, ArmorRegistry.krakenLeggings).withPossibleItems(EntityEquipmentSlot.FEET, ArmorRegistry.krakenBoots).withHandler(TickEvent.PlayerTickEvent.class, ArmorHandlers::breatheUnderwater).withHandler(LivingHurtEvent.class, event -> ArmorHandlers.onCancelPlayerReceiveDamage(event, source -> source.equals(DamageSource.field_76369_e))).setRegistryName(new ResourceLocation("divinerpg", "kraken")));
        registry.register(new ArmorDescription().withPossibleItems(EntityEquipmentSlot.HEAD, ArmorRegistry.netheriteHelmet).withPossibleItems(EntityEquipmentSlot.CHEST, ArmorRegistry.netheriteChestplate).withPossibleItems(EntityEquipmentSlot.LEGS, ArmorRegistry.netheriteLeggings).withPossibleItems(EntityEquipmentSlot.FEET, ArmorRegistry.netheriteBoots).withHandler(TickEvent.PlayerTickEvent.class, event -> {
            event.player.func_70066_B();
            event.player.func_70690_d(new PotionEffect(MobEffects.field_76426_n, 40, 0, true, false));
        }).setRegistryName(new ResourceLocation("divinerpg", "netherite")));
        registry.register(new ArmorDescription().withPossibleItems(EntityEquipmentSlot.HEAD, ArmorRegistry.infernoHelmet).withPossibleItems(EntityEquipmentSlot.CHEST, ArmorRegistry.infernoChestplate).withPossibleItems(EntityEquipmentSlot.LEGS, ArmorRegistry.infernoLeggings).withPossibleItems(EntityEquipmentSlot.FEET, ArmorRegistry.infernoBoots).withHandler(TickEvent.PlayerTickEvent.class, event -> {
            event.player.func_70066_B();
            event.player.func_70690_d(new PotionEffect(MobEffects.field_76426_n, 40, 0, true, false));
        }).setRegistryName(new ResourceLocation("divinerpg", "inferno")));
        registry.register(new ArmorDescription().withPossibleItems(EntityEquipmentSlot.HEAD, ArmorRegistry.mortumHelmet).withPossibleItems(EntityEquipmentSlot.CHEST, ArmorRegistry.mortumChestplate).withPossibleItems(EntityEquipmentSlot.LEGS, ArmorRegistry.mortumLeggings).withPossibleItems(EntityEquipmentSlot.FEET, ArmorRegistry.mortumBoots).withHandler(TickEvent.PlayerTickEvent.class, event -> event.player.func_70690_d(new PotionEffect(MobEffects.field_76439_r, 210, 10, true, false))).setRegistryName(new ResourceLocation("divinerpg", "mortum")));
        registry.register(new ArmorDescription().withPossibleItems(EntityEquipmentSlot.HEAD, ArmorRegistry.eliteRealmiteHelmet).withPossibleItems(EntityEquipmentSlot.CHEST, ArmorRegistry.eliteRealmiteChestplate).withPossibleItems(EntityEquipmentSlot.LEGS, ArmorRegistry.eliteRealmiteLeggings).withPossibleItems(EntityEquipmentSlot.FEET, ArmorRegistry.eliteRealmiteBoots).withHandler(LivingFallEvent.class, ArmorHandlers::disableFallDamage).setRegistryName(new ResourceLocation("divinerpg", "realmite")));
        registry.register(new ArmorDescription().withPossibleItems(EntityEquipmentSlot.HEAD, ArmorRegistry.wildwoodHelmet).withPossibleItems(EntityEquipmentSlot.CHEST, ArmorRegistry.wildwoodChestplate).withPossibleItems(EntityEquipmentSlot.LEGS, ArmorRegistry.wildwoodLeggings).withPossibleItems(EntityEquipmentSlot.FEET, ArmorRegistry.wildwoodBoots).withHandler(TickEvent.PlayerTickEvent.class, event -> {
            EntityPlayer player = event.player;
            if (player.func_70090_H()) {
                player.func_70691_i(0.25f);
            }
        }).setRegistryName(new ResourceLocation("divinerpg", "wildwood")));
        registry.register(new ArmorDescription().withPossibleItems(EntityEquipmentSlot.HEAD, ArmorRegistry.kormaHelmet).withPossibleItems(EntityEquipmentSlot.CHEST, ArmorRegistry.kormaChestplate).withPossibleItems(EntityEquipmentSlot.LEGS, ArmorRegistry.kormaLeggings).withPossibleItems(EntityEquipmentSlot.FEET, ArmorRegistry.kormaBoots).withHandler(TickEvent.PlayerTickEvent.class, event -> {
            IArcana arcana = DivineAPI.getArcana((Entity)event.player);
            if (arcana != null) {
                arcana.fill(event.player, 1.0f);
            }
        }).setRegistryName(new ResourceLocation("divinerpg", "korma")));
        registry.register(new ArmorDescription().withPossibleItems(EntityEquipmentSlot.HEAD, ArmorRegistry.vemosHelmet).withPossibleItems(EntityEquipmentSlot.CHEST, ArmorRegistry.vemosChestplate).withPossibleItems(EntityEquipmentSlot.LEGS, ArmorRegistry.vemosLeggings).withPossibleItems(EntityEquipmentSlot.FEET, ArmorRegistry.vemosBoots).withHandler(TickEvent.PlayerTickEvent.class, event -> event.player.func_70691_i(0.1f)).setRegistryName(new ResourceLocation("divinerpg", "vemos")));
        registry.register(new ArmorDescription().withPossibleItems(EntityEquipmentSlot.HEAD, ArmorRegistry.jungleHelmet).withPossibleItems(EntityEquipmentSlot.CHEST, ArmorRegistry.jungleChestplate).withPossibleItems(EntityEquipmentSlot.LEGS, ArmorRegistry.jungleLeggings).withPossibleItems(EntityEquipmentSlot.FEET, ArmorRegistry.jungleBoots).withHandler(LivingHurtEvent.class, event -> ArmorHandlers.onCancelPlayerReceiveDamage(event, DamageSource::func_82725_o)).setRegistryName(new ResourceLocation("divinerpg", "jungle")));
        registry.register(new ArmorDescription().withPossibleItems(EntityEquipmentSlot.HEAD, ArmorRegistry.witherReaperHelmet).withPossibleItems(EntityEquipmentSlot.CHEST, ArmorRegistry.witherReaperChestplate).withPossibleItems(EntityEquipmentSlot.LEGS, ArmorRegistry.witherReaperLeggings).withPossibleItems(EntityEquipmentSlot.FEET, ArmorRegistry.witherReaperBoots).withHandler(LivingHurtEvent.class, event -> ArmorHandlers.onCancelPlayerReceiveDamage(event, source -> source.equals(DamageSource.field_82727_n))).withHandler(LivingHurtEvent.class, event -> {
            if (event.getSource().func_76346_g() instanceof EntityLivingBase) {
                Entity ent = event.getSource().func_76346_g();
                ((EntityLivingBase)ent).func_70690_d(new PotionEffect(MobEffects.field_82731_v, 100, 1));
            }
        }).setRegistryName(new ResourceLocation("divinerpg", "wither")));
        registry.register(new ArmorDescription().withPossibleItems(EntityEquipmentSlot.HEAD, ArmorRegistry.apalachiaHelmet).withPossibleItems(EntityEquipmentSlot.CHEST, ArmorRegistry.apalachiaChestplate).withPossibleItems(EntityEquipmentSlot.LEGS, ArmorRegistry.apalachiaLeggings).withPossibleItems(EntityEquipmentSlot.FEET, ArmorRegistry.apalachiaBoots).withHandler(LivingHurtEvent.class, event -> ArmorHandlers.onCancelPlayerReceiveDamage(event, s -> s.equals(DamageSource.field_76367_g) || s.equals(DamageSource.field_82729_p) || s.equals(DamageSource.field_82728_o) || s.equals(DamageSource.field_76368_d) || s.equals(Utils.trapSource))).setRegistryName(new ResourceLocation("divinerpg", "apalachia")));
        registry.register(new ArmorDescription().withPossibleItems(EntityEquipmentSlot.HEAD, ArmorRegistry.edenHelmet).withPossibleItems(EntityEquipmentSlot.CHEST, ArmorRegistry.edenChestplate).withPossibleItems(EntityEquipmentSlot.LEGS, ArmorRegistry.edenLeggings).withPossibleItems(EntityEquipmentSlot.FEET, ArmorRegistry.edenBoots).withHandler(BlockEvent.HarvestDropsEvent.class, event -> {
            if (event.getState().func_177230_c() instanceof BlockTwilightOre && !event.isSilkTouching()) {
                ItemStack fragment = (ItemStack)event.getDrops().get(0);
                event.getDrops().addAll(Collections.nCopies(3, fragment.func_77946_l()));
            }
        }).setRegistryName(new ResourceLocation("divinerpg", "eden")));
        registry.register(new ArmorDescription().withPossibleItems(EntityEquipmentSlot.HEAD, ArmorRegistry.corruptedHelmet).withPossibleItems(EntityEquipmentSlot.CHEST, ArmorRegistry.corruptedChestplate).withPossibleItems(EntityEquipmentSlot.LEGS, ArmorRegistry.corruptedLeggings).withPossibleItems(EntityEquipmentSlot.FEET, ArmorRegistry.corruptedBoots).withHandler(LivingHurtEvent.class, event -> ArmorHandlers.onAddRangedDamage(event, CORRUPTED, x -> Float.valueOf(x.floatValue() * 1.5f))).setRegistryName(CORRUPTED));
        registry.register(new ArmorDescription().withPossibleItems(EntityEquipmentSlot.HEAD, ArmorRegistry.jackOManHelmet).withPossibleItems(EntityEquipmentSlot.CHEST, ArmorRegistry.jackOManChestplate).withPossibleItems(EntityEquipmentSlot.LEGS, ArmorRegistry.jackOManLeggings).withPossibleItems(EntityEquipmentSlot.FEET, ArmorRegistry.jackOManBoots).setRegistryName(JACKOMAN));
        registry.register(new ArmorDescription().withPossibleItems(EntityEquipmentSlot.HEAD, ArmorRegistry.degradedHood).withPossibleItems(EntityEquipmentSlot.CHEST, ArmorRegistry.degradedChestplate).withPossibleItems(EntityEquipmentSlot.LEGS, ArmorRegistry.degradedLeggings).withPossibleItems(EntityEquipmentSlot.FEET, ArmorRegistry.degradedBoots).withHandler(LivingHurtEvent.class, e -> ArmorHandlers.onPlayerReceiveDamage(e, DamageSource::func_82725_o, x -> Float.valueOf(x.floatValue() * 0.82f))).setRegistryName(new ResourceLocation("divinerpg", "degradedHood")));
        registry.register(new ArmorDescription().withPossibleItems(EntityEquipmentSlot.HEAD, ArmorRegistry.degradedHelmet).withPossibleItems(EntityEquipmentSlot.CHEST, ArmorRegistry.degradedChestplate).withPossibleItems(EntityEquipmentSlot.LEGS, ArmorRegistry.degradedLeggings).withPossibleItems(EntityEquipmentSlot.FEET, ArmorRegistry.degradedBoots).withHandler(LivingHurtEvent.class, e -> ArmorHandlers.onPlayerReceiveDamage(e, x -> !x.func_82725_o() && !x.func_76352_a(), x -> Float.valueOf(x.floatValue() * 0.82f))).setRegistryName(new ResourceLocation("divinerpg", "degradedHelmet")));
        registry.register(new ArmorDescription().withPossibleItems(EntityEquipmentSlot.HEAD, ArmorRegistry.degradedMask).withPossibleItems(EntityEquipmentSlot.CHEST, ArmorRegistry.degradedChestplate).withPossibleItems(EntityEquipmentSlot.LEGS, ArmorRegistry.degradedLeggings).withPossibleItems(EntityEquipmentSlot.FEET, ArmorRegistry.degradedBoots).withHandler(LivingHurtEvent.class, e -> ArmorHandlers.onPlayerReceiveDamage(e, x -> !x.func_82725_o() && x.func_76352_a(), x -> Float.valueOf(x.floatValue() * 0.82f))).setRegistryName(new ResourceLocation("divinerpg", "degradedMask")));
        registry.register(new ArmorDescription().withPossibleItems(EntityEquipmentSlot.HEAD, ArmorRegistry.finishedHood).withPossibleItems(EntityEquipmentSlot.CHEST, ArmorRegistry.finishedChestplate).withPossibleItems(EntityEquipmentSlot.LEGS, ArmorRegistry.finishedLeggings).withPossibleItems(EntityEquipmentSlot.FEET, ArmorRegistry.finishedBoots).withHandler(LivingHurtEvent.class, e -> ArmorHandlers.onPlayerReceiveDamage(e, DamageSource::func_82725_o, x -> Float.valueOf(x.floatValue() * 0.773f))).setRegistryName(new ResourceLocation("divinerpg", "finishedHood")));
        registry.register(new ArmorDescription().withPossibleItems(EntityEquipmentSlot.HEAD, ArmorRegistry.finishedHelmet).withPossibleItems(EntityEquipmentSlot.CHEST, ArmorRegistry.finishedChestplate).withPossibleItems(EntityEquipmentSlot.LEGS, ArmorRegistry.finishedLeggings).withPossibleItems(EntityEquipmentSlot.FEET, ArmorRegistry.finishedBoots).withHandler(LivingHurtEvent.class, e -> ArmorHandlers.onPlayerReceiveDamage(e, x -> !x.func_82725_o() && !x.func_76352_a(), x -> Float.valueOf(x.floatValue() * 0.773f))).setRegistryName(new ResourceLocation("divinerpg", "finishedHelmet")));
        registry.register(new ArmorDescription().withPossibleItems(EntityEquipmentSlot.HEAD, ArmorRegistry.finishedMask).withPossibleItems(EntityEquipmentSlot.CHEST, ArmorRegistry.finishedChestplate).withPossibleItems(EntityEquipmentSlot.LEGS, ArmorRegistry.finishedLeggings).withPossibleItems(EntityEquipmentSlot.FEET, ArmorRegistry.finishedBoots).withHandler(LivingHurtEvent.class, e -> ArmorHandlers.onPlayerReceiveDamage(e, x -> !x.func_82725_o() && x.func_76352_a(), x -> Float.valueOf(x.floatValue() * 0.773f))).setRegistryName(new ResourceLocation("divinerpg", "finishedMask")));
        registry.register(new ArmorDescription().withPossibleItems(EntityEquipmentSlot.HEAD, ArmorRegistry.glisteningHood).withPossibleItems(EntityEquipmentSlot.CHEST, ArmorRegistry.glisteningChestplate).withPossibleItems(EntityEquipmentSlot.LEGS, ArmorRegistry.glisteningLeggings).withPossibleItems(EntityEquipmentSlot.FEET, ArmorRegistry.glisteningBoots).withHandler(LivingHurtEvent.class, e -> ArmorHandlers.onPlayerReceiveDamage(e, DamageSource::func_82725_o, x -> Float.valueOf(x.floatValue() * 0.7f))).withHandler(LivingEvent.LivingJumpEvent.class, event -> event.getEntityLiving().func_70024_g(0.0, 0.2, 0.0)).withHandler(LivingFallEvent.class, ArmorHandlers::disableFallDamage).setRegistryName(new ResourceLocation("divinerpg", "glisteningHood")));
        registry.register(new ArmorDescription().withPossibleItems(EntityEquipmentSlot.HEAD, ArmorRegistry.glisteningHelmet).withPossibleItems(EntityEquipmentSlot.CHEST, ArmorRegistry.glisteningChestplate).withPossibleItems(EntityEquipmentSlot.LEGS, ArmorRegistry.glisteningLeggings).withPossibleItems(EntityEquipmentSlot.FEET, ArmorRegistry.glisteningBoots).withHandler(LivingHurtEvent.class, e -> {
            ArmorHandlers.onPlayerReceiveDamage(e, x -> !x.func_82725_o() && !x.func_76352_a(), x -> Float.valueOf(x.floatValue() * 0.7f));
            ArmorHandlers.onAddMeleeDamage(e, x -> Float.valueOf(x.floatValue() + 3.0f));
        }).setRegistryName(new ResourceLocation("divinerpg", "glisteningHelmet")));
        registry.register(new ArmorDescription(stopSpeedUp).withPossibleItems(EntityEquipmentSlot.HEAD, ArmorRegistry.glisteningMask).withPossibleItems(EntityEquipmentSlot.CHEST, ArmorRegistry.glisteningChestplate).withPossibleItems(EntityEquipmentSlot.LEGS, ArmorRegistry.glisteningLeggings).withPossibleItems(EntityEquipmentSlot.FEET, ArmorRegistry.glisteningBoots).withHandler(LivingHurtEvent.class, e -> ArmorHandlers.onPlayerReceiveDamage(e, x -> !x.func_82725_o() && x.func_76352_a(), x -> Float.valueOf(x.floatValue() * 0.7f))).withHandler(TickEvent.PlayerTickEvent.class, e -> ArmorHandlers.speedUpPlayer((EntityLivingBase)e.player, 1.4f, false)).setRegistryName(new ResourceLocation("divinerpg", "glisteningMask")));
        registry.register(new ArmorDescription().withPossibleItems(EntityEquipmentSlot.HEAD, ArmorRegistry.demonizedHood).withPossibleItems(EntityEquipmentSlot.CHEST, ArmorRegistry.demonizedChestplate).withPossibleItems(EntityEquipmentSlot.LEGS, ArmorRegistry.demonizedLeggings).withPossibleItems(EntityEquipmentSlot.FEET, ArmorRegistry.demonizedBoots).withHandler(LivingHurtEvent.class, e -> ArmorHandlers.onPlayerReceiveDamage(e, DamageSource::func_82725_o, x -> Float.valueOf(x.floatValue() * 0.625f))).withHandler(LivingEvent.LivingJumpEvent.class, event -> event.getEntityLiving().func_70024_g(0.0, 0.3, 0.0)).withHandler(LivingFallEvent.class, ArmorHandlers::disableFallDamage).setRegistryName(new ResourceLocation("divinerpg", "demonizedHood")));
        registry.register(new ArmorDescription().withPossibleItems(EntityEquipmentSlot.HEAD, ArmorRegistry.demonizedHelmet).withPossibleItems(EntityEquipmentSlot.CHEST, ArmorRegistry.demonizedChestplate).withPossibleItems(EntityEquipmentSlot.LEGS, ArmorRegistry.demonizedLeggings).withPossibleItems(EntityEquipmentSlot.FEET, ArmorRegistry.demonizedBoots).withHandler(LivingHurtEvent.class, e -> {
            ArmorHandlers.onPlayerReceiveDamage(e, x -> !x.func_82725_o() && !x.func_76352_a(), x -> Float.valueOf(x.floatValue() * 0.625f));
            ArmorHandlers.onAddMeleeDamage(e, x -> Float.valueOf(x.floatValue() + 6.0f));
        }).setRegistryName(new ResourceLocation("divinerpg", "demonizedHelmet")));
        registry.register(new ArmorDescription(stopSpeedUp).withPossibleItems(EntityEquipmentSlot.HEAD, ArmorRegistry.demonizedMask).withPossibleItems(EntityEquipmentSlot.CHEST, ArmorRegistry.demonizedChestplate).withPossibleItems(EntityEquipmentSlot.LEGS, ArmorRegistry.demonizedLeggings).withPossibleItems(EntityEquipmentSlot.FEET, ArmorRegistry.demonizedBoots).withHandler(LivingHurtEvent.class, e -> ArmorHandlers.onPlayerReceiveDamage(e, x -> !x.func_82725_o() && x.func_76352_a(), x -> Float.valueOf(x.floatValue() * 0.625f))).withHandler(TickEvent.PlayerTickEvent.class, e -> ArmorHandlers.speedUpPlayer((EntityLivingBase)e.player, 1.8f, false)).setRegistryName(new ResourceLocation("divinerpg", "demonizedMask")));
        registry.register(new ArmorDescription().withPossibleItems(EntityEquipmentSlot.HEAD, ArmorRegistry.tormentedHood).withPossibleItems(EntityEquipmentSlot.CHEST, ArmorRegistry.tormentedChestplate).withPossibleItems(EntityEquipmentSlot.LEGS, ArmorRegistry.tormentedLeggings).withPossibleItems(EntityEquipmentSlot.FEET, ArmorRegistry.tormentedBoots).withHandler(LivingHurtEvent.class, e -> ArmorHandlers.onPlayerReceiveDamage(e, DamageSource::func_82725_o, x -> Float.valueOf(x.floatValue() * 0.348f))).withHandler(LivingEvent.LivingJumpEvent.class, event -> event.getEntityLiving().func_70024_g(0.0, 0.4, 0.0)).withHandler(LivingFallEvent.class, ArmorHandlers::disableFallDamage).setRegistryName(new ResourceLocation("divinerpg", "tormentedHood")));
        registry.register(new ArmorDescription().withPossibleItems(EntityEquipmentSlot.HEAD, ArmorRegistry.tormentedHelmet).withPossibleItems(EntityEquipmentSlot.CHEST, ArmorRegistry.tormentedChestplate).withPossibleItems(EntityEquipmentSlot.LEGS, ArmorRegistry.tormentedLeggings).withPossibleItems(EntityEquipmentSlot.FEET, ArmorRegistry.tormentedBoots).withHandler(LivingHurtEvent.class, e -> {
            ArmorHandlers.onPlayerReceiveDamage(e, x -> !x.func_82725_o() && !x.func_76352_a(), x -> Float.valueOf(x.floatValue() * 0.348f));
            ArmorHandlers.onAddMeleeDamage(e, x -> Float.valueOf(x.floatValue() + 9.0f));
        }).setRegistryName(new ResourceLocation("divinerpg", "tormentedHelmet")));
        registry.register(new ArmorDescription(stopSpeedUp).withPossibleItems(EntityEquipmentSlot.HEAD, ArmorRegistry.tormentedMask).withPossibleItems(EntityEquipmentSlot.CHEST, ArmorRegistry.tormentedChestplate).withPossibleItems(EntityEquipmentSlot.LEGS, ArmorRegistry.tormentedLeggings).withPossibleItems(EntityEquipmentSlot.FEET, ArmorRegistry.tormentedBoots).withHandler(LivingHurtEvent.class, e -> ArmorHandlers.onPlayerReceiveDamage(e, x -> !x.func_82725_o() && x.func_76352_a(), x -> Float.valueOf(x.floatValue() * 0.348f))).withHandler(TickEvent.PlayerTickEvent.class, e -> ArmorHandlers.speedUpPlayer((EntityLivingBase)e.player, 2.2f, false)).setRegistryName(new ResourceLocation("divinerpg", "tormentedMask")));
    }
}

