/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.objects.items.vanilla;

import divinerpg.objects.items.vanilla.ItemTeleportationCrystal;
import divinerpg.utils.LocalizeUtils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;

public class ItemTeleportationStar
extends ItemTeleportationCrystal {
    private static final String posKey = "BlockPos";
    private static final String dimKey = "Dim";

    public ItemTeleportationStar(String name) {
        super(name);
        this.func_77656_e(64);
    }

    private NBTTagCompound getFromStack(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        return stack.func_77978_p();
    }

    @Override
    @Nullable
    protected BlockPos getSavedPos(EntityPlayer player, ItemStack stack) {
        NBTTagCompound tag = this.getFromStack(stack);
        if (!tag.func_74764_b(posKey)) {
            return null;
        }
        return BlockPos.func_177969_a((long)tag.func_74763_f(posKey));
    }

    @Override
    protected DimensionType getSavedDimType(EntityPlayer player, ItemStack stack) {
        NBTTagCompound tag = this.getFromStack(stack);
        if (!tag.func_74764_b(dimKey)) {
            return null;
        }
        String dimName = tag.func_74779_i(dimKey);
        try {
            return DimensionType.func_193417_a((String)dimName);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected boolean trySetCords(NBTTagCompound compound, EntityPlayer player, boolean hasInfo) {
        if (hasInfo) {
            return false;
        }
        compound.func_74778_a(dimKey, player.field_70170_p.field_73011_w.func_186058_p().func_186065_b());
        compound.func_74772_a(posKey, player.func_180425_c().func_177986_g());
        return true;
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer player, EnumHand hand) {
        boolean hasInfo;
        ItemStack stack = player.func_184586_b(hand);
        NBTTagCompound compound = this.getFromStack(stack);
        boolean bl = hasInfo = compound.func_74764_b(dimKey) && compound.func_74764_b(posKey);
        if (player.func_70093_af()) {
            if (this.trySetCords(compound, player, hasInfo)) {
                return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
            }
            if (player.field_70170_p.field_72995_K) {
                TextComponentTranslation message = new TextComponentTranslation("messaage.teleportation_star", new Object[0]);
                message.func_150256_b().func_150238_a(TextFormatting.RED);
                player.func_145747_a((ITextComponent)message);
            }
            hasInfo = false;
        }
        return hasInfo ? super.func_77659_a(worldIn, player, hand) : ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)stack);
    }

    @Override
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> list, ITooltipFlag flagIn) {
        NBTTagCompound compound = this.getFromStack(stack);
        if (compound.func_74764_b(dimKey)) {
            list.add(LocalizeUtils.i18n("tooltip.dimension", compound.func_74779_i(dimKey)));
        }
        if (compound.func_74764_b(posKey)) {
            BlockPos pos = BlockPos.func_177969_a((long)compound.func_74763_f(posKey));
            list.add(LocalizeUtils.i18n("tooltip.block_position", pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()));
        }
        list.add("");
        list.add(LocalizeUtils.usesRemaining(stack.func_77958_k() - stack.func_77960_j()));
    }
}

