/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.objects.items.vanilla;

import divinerpg.DivineRPG;
import divinerpg.api.DivineAPI;
import divinerpg.api.armor.cap.IArmorPowers;
import divinerpg.enums.BulletType;
import divinerpg.objects.items.base.RangedWeaponBase;
import divinerpg.registry.ArmorDescriptionRegistry;
import divinerpg.registry.SoundRegistry;
import divinerpg.utils.LocalizeUtils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemScythe
extends RangedWeaponBase {
    public ItemScythe(String name) {
        super(name, null, BulletType.SCYTHE_SHOT, SoundRegistry.DEEP_LAUGH, SoundCategory.MASTER, -1, 0, () -> null, 0);
    }

    @Override
    protected void spawnEntity(World world, EntityPlayer player, ItemStack stack, BulletType bulletType, Class<? extends EntityThrowable> clazz) {
        super.spawnEntity(world, player, stack, this.isJackoman(player) ? BulletType.MEGA_SCYTHE_SHOT : BulletType.SCYTHE_SHOT, null);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> list, ITooltipFlag flagIn) {
        list.add(LocalizeUtils.rangedDam(this.isJackoman(DivineRPG.proxy.getPlayer()) ? (double)BulletType.MEGA_SCYTHE_SHOT.getDamage() : (double)BulletType.SCYTHE_SHOT.getDamage()));
        super.func_77624_a(stack, worldIn, list, flagIn);
    }

    private boolean isJackoman(EntityPlayer player) {
        if (player == null) {
            return false;
        }
        IArmorPowers powers = DivineAPI.getArmorPowers((Entity)player);
        if (powers == null) {
            return false;
        }
        return powers.wearing(ArmorDescriptionRegistry.JACKOMAN);
    }
}

