/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.objects.items.twilight;

import divinerpg.objects.items.base.ItemMod;
import divinerpg.registry.DivineRPGTabs;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentBase;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraftforge.server.command.TextComponentHelper;

public class ItemBossSpawner
extends ItemMod {
    private final Predicate<DimensionType> canSpawn;
    private final Function<World, Entity>[] spawnderEntities;
    private final String langKey;

    public ItemBossSpawner(String name, String langKey, Predicate<DimensionType> canSpawn, Function<World, Entity> ... spawnedEntities) {
        super(name);
        this.canSpawn = canSpawn;
        this.spawnderEntities = spawnedEntities;
        this.func_77625_d(1);
        this.func_77637_a(DivineRPGTabs.BOSS_SPAWNERS);
        this.langKey = langKey;
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            if (!this.canSpawn.test(world.field_73011_w.func_186058_p())) {
                TextComponentBase message = TextComponentHelper.createComponentTranslation((ICommandSender)player, (String)this.langKey, (Object[])new Object[0]);
                message.func_150256_b().func_150238_a(TextFormatting.AQUA);
                player.func_145747_a((ITextComponent)message);
                return EnumActionResult.FAIL;
            }
            List<Entity> toSpawn = Arrays.stream(this.spawnderEntities).map(x -> {
                Entity e = (Entity)x.apply(world);
                e.func_70107_b((double)pos.func_177958_n(), (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p());
                return e;
            }).collect(Collectors.toList());
            if (toSpawn.stream().allMatch(x -> world.func_184144_a(x, x.func_174813_aQ()).isEmpty())) {
                toSpawn.forEach(arg_0 -> ((World)world).func_72838_d(arg_0));
                if (!player.func_184812_l_()) {
                    player.func_184614_ca().func_190918_g(toSpawn.size());
                }
                return EnumActionResult.SUCCESS;
            }
        }
        return EnumActionResult.FAIL;
    }
}

