/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.objects.items.base;

import divinerpg.api.DivineAPI;
import divinerpg.api.arcana.IArcana;
import divinerpg.objects.items.base.ItemMod;
import divinerpg.utils.PositionHelper;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class ItemDivineScepter
extends ItemMod {
    public ItemDivineScepter(String name, CreativeTabs tab) {
        super(name, tab);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        if (this.tryConsumeArcana(DivineAPI.getArcana((Entity)playerIn))) {
            Vec3d end;
            Tuple<Vec3d, Vec3d> vecs;
            Vec3d start;
            RayTraceResult blockHit;
            if (!playerIn.func_184812_l_()) {
                playerIn.func_184586_b(handIn).func_77972_a(1, (EntityLivingBase)playerIn);
            }
            if ((blockHit = worldIn.func_147447_a(start = (Vec3d)(vecs = PositionHelper.getRayTraceVecs((Entity)playerIn, this.getRange())).func_76341_a(), end = (Vec3d)vecs.func_76340_b(), true, false, true)) != null && blockHit.field_72313_a == RayTraceResult.Type.BLOCK && this.onBlockHit(worldIn, playerIn, blockHit.func_178782_a())) {
                return this.trySpawnParticles(playerIn, handIn, blockHit.func_178782_a());
            }
            Entity victim = PositionHelper.rayTrace((Entity)playerIn, this.getRange());
            if (victim != null && this.onEntityHit(worldIn, playerIn, victim)) {
                return this.trySpawnParticles(playerIn, handIn, victim.func_180425_c());
            }
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)playerIn.func_184586_b(handIn));
    }

    private ActionResult<ItemStack> trySpawnParticles(EntityPlayer player, EnumHand hand, BlockPos end) {
        if (player.field_70170_p.field_72995_K) {
            this.spawnParticle(player.field_70170_p, player.func_174824_e(1.0f), end);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
    }

    @SideOnly(value=Side.CLIENT)
    protected void spawnParticle(World world, Vec3d start, BlockPos endRaw) {
        Vec3d end = new Vec3d((Vec3i)endRaw);
        Vec3d step = end.func_178788_d(start).func_72432_b();
        while (start.func_72438_d(end) > 1.0) {
            world.func_175688_a(EnumParticleTypes.FLAME, start.field_72450_a, start.field_72448_b, start.field_72449_c, step.field_72450_a, step.field_72448_b, step.field_72449_c, new int[0]);
            start = start.func_178787_e(step);
        }
    }

    protected abstract float getRange();

    protected boolean tryConsumeArcana(IArcana playerArcana) {
        return true;
    }

    protected boolean onBlockHit(World world, EntityPlayer shooter, BlockPos hitpos) {
        return false;
    }

    protected boolean onEntityHit(World world, EntityPlayer shooter, Entity victim) {
        return false;
    }
}

