/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.objects.items.arcana;

import divinerpg.enums.BulletType;
import divinerpg.objects.entities.entity.projectiles.EntityStar;
import divinerpg.objects.items.base.RangedWeaponBase;
import divinerpg.registry.SoundRegistry;
import divinerpg.utils.LocalizeUtils;
import divinerpg.utils.PositionHelper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;

public class ItemStaffStarlight
extends RangedWeaponBase {
    private final int count;
    private final ITextComponent starsInfo;

    public ItemStaffStarlight(String name, int arcana, int count) {
        super(name, EntityStar.class, null, SoundRegistry.STARLIGHT, SoundCategory.MASTER, -1, 0, null, arcana);
        this.count = count;
        this.func_77664_n();
        this.starsInfo = new TextComponentTranslation(count > 1 ? "tooltip.staff_of_starlight" : "tooltip.starlight", new Object[0]);
    }

    @Override
    protected boolean canUseRangedWeapon(EntityPlayer player, ItemStack stack) {
        if (!player.field_70170_p.field_72995_K) {
            RayTraceResult pos = PositionHelper.rayTrace(player, 32.0, 1);
            if (pos.field_72313_a != RayTraceResult.Type.BLOCK) {
                return false;
            }
        }
        return super.canUseRangedWeapon(player, stack);
    }

    @Override
    protected void spawnEntity(World world, EntityPlayer player, ItemStack stack, BulletType bulletType, Class<? extends EntityThrowable> clazz) {
        RayTraceResult pos = PositionHelper.rayTrace(player, 32.0, 1);
        if (pos.field_72313_a == RayTraceResult.Type.BLOCK) {
            int blockX = pos.func_178782_a().func_177958_n();
            int blockY = pos.func_178782_a().func_177956_o();
            int blockZ = pos.func_178782_a().func_177952_p();
            EnumFacing side = pos.field_178784_b;
            if (side == EnumFacing.DOWN) {
                --blockY;
            }
            if (side == EnumFacing.UP) {
                ++blockY;
            }
            if (side == EnumFacing.EAST) {
                --blockZ;
            }
            if (side == EnumFacing.WEST) {
                ++blockZ;
            }
            if (side == EnumFacing.SOUTH) {
                --blockX;
            }
            if (side == EnumFacing.NORTH) {
                ++blockX;
            }
            if (!world.field_72995_K) {
                for (int i = 0; i < this.count; ++i) {
                    world.func_72838_d((Entity)new EntityStar(world, (double)blockX + 0.5, (double)blockY + 25.0, (double)blockZ + 0.5));
                }
            }
        }
    }

    @Override
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add(LocalizeUtils.rangedDam(20.0));
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        tooltip.add(this.starsInfo.func_150254_d());
    }
}

