/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.objects.entities.entity.boss.ayeraco;

import divinerpg.objects.entities.entity.EntityDivineBoss;
import divinerpg.objects.entities.entity.boss.ayeraco.AyeracoGroup;
import divinerpg.objects.entities.entity.projectiles.EntityEnderTripletsFireball;
import divinerpg.registry.SoundRegistry;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class EntityAyeraco
extends EntityDivineBoss {
    private int waitTick;
    private BlockPos currentFlightTarget;
    private boolean attacks;
    private double moveX;
    private double moveZ;
    private boolean halfHp;
    public float moveSpeed = 0.3f;
    private BlockPos beamLocation;
    private AyeracoGroup group;
    private ResourceLocation loot;

    public EntityAyeraco(World worldIn) {
        this(worldIn, new BlockPos(0, 100, 0), new ResourceLocation(""));
    }

    public EntityAyeraco(World world, BlockPos beam, ResourceLocation loot) {
        super(world);
        this.beamLocation = beam;
        this.loot = loot;
        this.func_70105_a(2.8f, 1.2f);
        this.waitTick = 0;
        this.attacks = false;
        this.halfHp = false;
        this.moveX = this.field_70146_Z.nextGaussian() * 0.25 - 0.125;
        this.moveZ = this.field_70146_Z.nextGaussian() * 0.25 - 0.125;
        this.func_70012_b(beam.func_177958_n(), beam.func_177956_o() + 4, beam.func_177952_p(), this.field_70170_p.field_73012_v.nextFloat() * 360.0f, 0.0f);
        WorldServer serverWorld = world instanceof WorldServer ? (WorldServer)world : null;
        this.group = new AyeracoGroup(serverWorld);
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.addAttackingAI();
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        this.field_70181_x *= (double)0.6f;
    }

    protected void func_70619_bc() {
        EntityPlayer attackablePlayer;
        super.func_70619_bc();
        this.group.tick(this);
        if (this.func_110143_aJ() * 2.0f < this.func_110138_aP() && !this.halfHp) {
            this.func_184185_a(SoundRegistry.AYERACO_HALF_HEALTH, 20.0f, 0.4f / (this.field_70146_Z.nextFloat() * 0.4f + 0.8f));
            this.halfHp = true;
        }
        if ((attackablePlayer = this.field_70170_p.func_184142_a((Entity)this, 128.0, 128.0)) != null) {
            this.func_70624_b((EntityLivingBase)attackablePlayer);
        }
        if (this.waitTick == 0) {
            if (this.func_70638_az() != null) {
                int var1 = (int)this.func_70638_az().field_70165_t;
                int var2 = (int)this.func_70638_az().field_70163_u;
                int var3 = (int)this.func_70638_az().field_70161_v;
                this.currentFlightTarget = this.func_70638_az().func_180425_c();
            }
            this.field_70181_x = 0.0;
            if (this.currentFlightTarget != null) {
                double var1 = (double)this.currentFlightTarget.func_177958_n() - this.field_70165_t;
                double var3 = (double)this.currentFlightTarget.func_177956_o() - this.field_70163_u;
                double var5 = (double)this.currentFlightTarget.func_177952_p() - this.field_70161_v;
                if (Math.signum(var1) != 0.0 || Math.signum(var3) != 0.0 || Math.signum(var5) != 0.0) {
                    this.field_70159_w = Math.signum(var1) * (double)this.moveSpeed;
                    this.field_70181_x += (Math.signum(var3) * 5.699999988079071 - this.field_70181_x) * (double)0.1f;
                    this.field_70179_y = Math.signum(var5) * (double)this.moveSpeed;
                    float var7 = (float)(Math.atan2(this.field_70179_y, this.field_70159_w) * 180.0 / Math.PI) - 90.0f;
                    float var8 = MathHelper.func_76142_g((float)(var7 - this.field_70177_z));
                    this.field_191988_bg = 0.5f;
                    this.field_70177_z += var8;
                }
            }
        } else {
            --this.waitTick;
            this.field_70181_x = 0.3;
            this.field_70159_w = this.moveX;
            this.field_70179_y = this.moveZ;
        }
        if (!this.attacks) {
            this.waitTick = 80;
            this.attacks = true;
            if (this.group.canTeleport((EntityLivingBase)this)) {
                this.waitTick = 0;
                this.teleportRandomUp();
            }
        }
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    protected void func_184231_a(double y, boolean onGroundIn, IBlockState state, BlockPos pos) {
    }

    public boolean func_70097_a(DamageSource damageSource, float par2) {
        if (this.func_180431_b(damageSource) || damageSource.func_76364_f() instanceof EntityEnderTripletsFireball || damageSource.func_76352_a() && this.group.projectileProtected((EntityLivingBase)this)) {
            return false;
        }
        if (damageSource.func_76346_g() instanceof EntityPlayer) {
            this.attacks = true;
        }
        return super.func_70097_a(damageSource, par2);
    }

    public boolean func_70652_k(Entity entity) {
        this.attacks = false;
        return super.func_70652_k(entity);
    }

    @Override
    public int func_70641_bl() {
        return 1;
    }

    protected SoundEvent func_184639_G() {
        return SoundRegistry.AYERACO;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundRegistry.AYERACO_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return SoundRegistry.AYERACO_HURT;
    }

    public NBTTagCompound func_189511_e(NBTTagCompound compound) {
        compound.func_74782_a("group", (NBTBase)this.group.serializeNBT());
        compound.func_74772_a("beamPos", this.beamLocation.func_177986_g());
        compound.func_74778_a("lootTable", this.loot.toString());
        return super.func_189511_e(compound);
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.group.deserializeNBT(compound.func_74775_l("group"));
        this.beamLocation = BlockPos.func_177969_a((long)compound.func_74763_f("beamPos"));
        this.loot = new ResourceLocation(compound.func_74779_i("lootTable"));
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (this.field_70170_p.func_175667_e(this.beamLocation)) {
            this.field_70170_p.func_175656_a(this.beamLocation, Blocks.field_150350_a.func_176223_P());
        }
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return this.loot;
    }

    public void initGroup(AyeracoGroup group) {
        this.group = group;
    }

    protected void teleportRandomUp() {
        this.func_184185_a(SoundRegistry.AYERACO_TELEPORT, 2.0f, 0.4f / (this.field_70146_Z.nextFloat() * 0.4f + 0.8f));
        this.field_70181_x = 20.0;
        this.field_70159_w = this.field_70146_Z.nextInt(5);
        this.field_70179_y = this.field_70146_Z.nextInt(5);
    }
}

