/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.objects.entities.entity.boss;

import divinerpg.objects.blocks.vethea.BlockHelioticBeam;
import divinerpg.objects.blocks.vethea.BlockKarosDispenser;
import divinerpg.objects.entities.entity.EntityDivineBoss;
import divinerpg.registry.BlockRegistry;
import divinerpg.registry.LootTableRegistry;
import divinerpg.registry.SoundRegistry;
import divinerpg.utils.LocalizeUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollow;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class EntityKaros
extends EntityDivineBoss {
    private int ability;
    private final int DEFAULT = 0;
    private final int CEILING = 1;
    private final int CANNONS = 2;
    private final int FLOOR = 3;
    private int abilityCooldown;
    private boolean hasLoadedBlocks = false;
    private List<BlockPos> ceiling = new ArrayList<BlockPos>();
    private List<BlockPos> cannons = new ArrayList<BlockPos>();

    public EntityKaros(World worldIn) {
        super(worldIn);
        this.func_70105_a(1.0f, 3.0f);
        this.ability = 0;
    }

    protected ResourceLocation func_184647_J() {
        return LootTableRegistry.ENTITIES_KAROS;
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(35.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.32);
    }

    protected void func_70619_bc() {
        this.manageAbilities();
        super.func_70619_bc();
    }

    @Override
    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, true));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIFollow((EntityLiving)this, 1.0, 1.0f, 1.0f));
        this.applyEntityAI();
    }

    private void applyEntityAI() {
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[]{EntityPigZombie.class}));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
    }

    public void manageAbilities() {
        block9: {
            block8: {
                if (this.abilityCooldown != 0) break block8;
                this.abilityCooldown = 200;
                switch (this.field_70146_Z.nextInt(3)) {
                    case 0: {
                        this.ability = 1;
                        this.func_184185_a(SoundRegistry.CEILING_EXPLOSIONS, 1.0f, 1.0f);
                        if (!this.field_70170_p.field_72995_K) {
                            List players = this.field_70170_p.func_72872_a(EntityPlayer.class, this.func_174813_aQ().func_72321_a(30.0, 30.0, 30.0));
                            for (EntityPlayer p : players) {
                                p.func_145747_a(LocalizeUtils.getClientSideTranslation((ICommandSender)p, "message.karos.explosion", new Object[0]));
                            }
                        }
                        break block9;
                    }
                    case 1: {
                        this.ability = 2;
                        break;
                    }
                    case 2: {
                        this.ability = 3;
                        break;
                    }
                }
                break block9;
            }
            if (this.abilityCooldown > 0) {
                --this.abilityCooldown;
            }
        }
    }

    public boolean func_70097_a(DamageSource source, float par2) {
        if (source.func_94541_c()) {
            return false;
        }
        return super.func_70097_a(source, par2);
    }

    public void func_70636_d() {
        BlockPos currentPos;
        Block currentBlock;
        int var2;
        super.func_70636_d();
        if (!this.hasLoadedBlocks) {
            if (!this.field_70170_p.field_72995_K) {
                List players = this.field_70170_p.func_72872_a(EntityPlayer.class, this.func_174813_aQ().func_72321_a(30.0, 30.0, 30.0));
                for (EntityPlayer p : players) {
                    this.field_70170_p.func_184133_a(p, p.func_180425_c(), SoundRegistry.KAROS_INTRO, SoundCategory.HOSTILE, 1.0f, 1.0f);
                    p.func_145747_a(LocalizeUtils.getClientSideTranslation((ICommandSender)p, "message.karos.game", new Object[0]));
                    p.func_145747_a(LocalizeUtils.getClientSideTranslation((ICommandSender)p, "message.karos.begin", new Object[0]));
                }
            }
            for (int x = -40; x < 40; ++x) {
                for (int y = -5; y < 20; ++y) {
                    for (int z = -40; z < 40; ++z) {
                        BlockPos currentPos2 = this.func_180425_c().func_177982_a(x, y, z);
                        Block currentBlock2 = this.field_70170_p.func_180495_p(currentPos2).func_177230_c();
                        if (currentBlock2 == BlockRegistry.helioticBeam) {
                            this.ceiling.add(currentPos2);
                            continue;
                        }
                        if (currentBlock2 != BlockRegistry.karosDispenser) continue;
                        this.cannons.add(currentPos2);
                    }
                }
            }
            this.hasLoadedBlocks = true;
        }
        if (this.ability == 1 && this.ceiling.size() != 0) {
            var2 = this.field_70146_Z.nextInt(46);
            if (this.abilityCooldown % 8 == 0 && (currentBlock = this.field_70170_p.func_180495_p(currentPos = this.ceiling.get(this.field_70146_Z.nextInt(this.ceiling.size()))).func_177230_c()) instanceof BlockHelioticBeam) {
                ((BlockHelioticBeam)currentBlock).dropBomb(this.field_70170_p, currentPos);
            }
        } else if (this.ability == 2 && this.cannons.size() != 0) {
            var2 = this.field_70146_Z.nextInt(36);
            if (this.abilityCooldown % 4 == 0 && (currentBlock = this.field_70170_p.func_180495_p(currentPos = this.cannons.get(this.field_70146_Z.nextInt(this.cannons.size()))).func_177230_c()) instanceof BlockKarosDispenser) {
                ((BlockKarosDispenser)currentBlock).dispense(this.field_70170_p, currentPos);
            }
        } else if (this.ability == 3) {
            for (int i = 0; i < 3; ++i) {
                for (double var4 = 0.0; var4 < Math.PI * 2; var4 += 0.39269908169872414) {
                    int var3;
                    int var1 = (int)Math.round(Math.sin(var4) * (double)i);
                    BlockPos currentPos3 = new BlockPos((int)this.field_70165_t + var1, (int)this.field_70163_u - 1, (int)this.field_70161_v + (var3 = (int)Math.round(Math.cos(var4) * (double)i)));
                    if (this.field_70170_p.func_180495_p(currentPos3).func_177230_c() != BlockRegistry.karosHeatTileGreen) continue;
                    this.field_70170_p.func_175656_a(currentPos3, BlockRegistry.karosHeatTileRed.func_176223_P());
                }
            }
        }
    }

    protected float func_70599_aP() {
        return 0.7f;
    }

    protected SoundEvent func_184639_G() {
        SoundEvent sound;
        String langKey;
        int s = this.field_70146_Z.nextInt(4);
        switch (this.field_70146_Z.nextInt(4)) {
            case 0: {
                langKey = "message.karos.laugh";
                sound = SoundRegistry.KAROS_LAUGH;
                break;
            }
            case 1: {
                langKey = "message.karos.doom";
                sound = SoundRegistry.MEET_DOOM;
                break;
            }
            case 2: {
                langKey = "message.karos.cmon";
                sound = SoundRegistry.TRY_YOUR_BEST;
                break;
            }
            default: {
                langKey = "message.karos.weak";
                sound = SoundRegistry.YOU_CANT_KILL_ME;
            }
        }
        this.field_70170_p.func_72872_a(EntityPlayer.class, this.func_174813_aQ().func_72321_a(30.0, 30.0, 30.0)).forEach(x -> x.func_145747_a(LocalizeUtils.getClientSideTranslation((ICommandSender)x, langKey, new Object[0])));
        return sound;
    }

    public SoundEvent func_184601_bQ(DamageSource damageSource) {
        return null;
    }

    public SoundEvent func_184615_bR() {
        return null;
    }
}

