/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.objects.blocks.tile.entity.base;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;

public interface IFuelProvider
extends IInventory {
    public boolean needFuel();

    public int consumeFuel();

    public void onFinished();

    public void onStart();

    public boolean haveItemsToSmelt();

    public int getBurningTicks();

    public void setBurningTicks(int var1);

    public int getCurrentCookTime();

    public void setCookTime(int var1);

    public int getCookTimeLength();

    public void changeBurnState(boolean var1);

    public NonNullList<ItemStack> getInventoryRef();

    default public void updateBurningTick() {
        int currentBurnTime = this.getBurningTicks();
        int cookTime = this.getCurrentCookTime();
        boolean hasRecipe = this.haveItemsToSmelt();
        if (!hasRecipe) {
            this.cooldownFurnace();
            return;
        }
        if (currentBurnTime <= 0) {
            int n = currentBurnTime = this.needFuel() ? this.consumeFuel() : 20;
        }
        if (currentBurnTime <= 0) {
            this.cooldownFurnace();
            return;
        }
        if (cookTime <= 0) {
            this.onStart();
            this.changeBurnState(true);
        }
        this.setBurningTicks(Math.max(currentBurnTime - 1, 0));
        this.setCookTime(Math.max(cookTime + 1, 0));
        if (this.getCurrentCookTime() >= this.getCookTimeLength()) {
            this.setCookTime(0);
            this.onFinished();
        }
    }

    default public void cooldownFurnace() {
        int burningTicks = this.getBurningTicks();
        if (burningTicks > 0) {
            this.changeBurnState(false);
        }
        this.setBurningTicks(Math.max(burningTicks - 1, 0));
        this.setCookTime(Math.max(this.getCurrentCookTime() - 1, 0));
    }

    default public ItemStack func_70301_a(int index) {
        if (0 <= index && index < this.func_70302_i_()) {
            return (ItemStack)this.getInventoryRef().get(index);
        }
        return ItemStack.field_190927_a;
    }

    default public ItemStack func_70298_a(int index, int count) {
        ItemStack result = ItemStackHelper.func_188382_a(this.getInventoryRef(), (int)index, (int)count);
        this.func_70296_d();
        return result;
    }

    default public ItemStack func_70304_b(int index) {
        ItemStack result = ItemStackHelper.func_188383_a(this.getInventoryRef(), (int)index);
        this.func_70296_d();
        return result;
    }

    default public int func_70302_i_() {
        return this.getInventoryRef().size();
    }

    default public int func_70297_j_() {
        return 64;
    }

    default public void func_70299_a(int index, ItemStack stack) {
        this.getInventoryRef().set(index, (Object)stack);
        if (!stack.func_190926_b() && stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        this.func_70296_d();
    }

    default public boolean func_191420_l() {
        return this.getInventoryRef().stream().noneMatch(ItemStack::func_190926_b);
    }

    default public void func_174888_l() {
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            this.func_70299_a(i, ItemStack.field_190927_a);
        }
    }

    default public void func_174889_b(EntityPlayer player) {
    }

    default public void func_174886_c(EntityPlayer player) {
    }

    default public int func_174890_g() {
        return 2;
    }

    default public int func_174887_a_(int id) {
        switch (id) {
            case 0: {
                return this.getBurningTicks();
            }
            case 1: {
                return this.getCurrentCookTime();
            }
        }
        return 0;
    }

    default public void func_174885_b(int id, int value) {
        switch (id) {
            case 0: {
                this.setBurningTicks(value);
                return;
            }
            case 1: {
                this.setCookTime(value);
                return;
            }
        }
    }
}

