/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.objects.blocks;

import divinerpg.DivineRPG;
import divinerpg.enums.ParticleType;
import divinerpg.objects.blocks.BlockMod;
import divinerpg.objects.blocks.tile.entity.TileEntitySingleUseSpawner;
import java.util.Random;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockSingleUseSpawner
extends BlockMod
implements ITileEntityProvider {
    private final Class<? extends Entity> entityClass;
    private final int delay;
    private String name;
    private int nearDistance;
    private BlockPos spawnOffset;
    protected Supplier<Item> activationItemSupplier;

    public BlockSingleUseSpawner(String name, Class<? extends Entity> entityClass, Supplier<Item> activationItemSupplier, int delay, int nearDistance) {
        this(name, entityClass, activationItemSupplier, delay, nearDistance, BlockPos.field_177992_a);
    }

    public BlockSingleUseSpawner(String name, Class<? extends Entity> entityClass, Supplier<Item> activationItemSupplier, int delay, int nearDistance, BlockPos spawnOffset) {
        super(name, 1.0f, Material.field_151573_f);
        this.entityClass = entityClass;
        this.activationItemSupplier = activationItemSupplier;
        this.delay = delay;
        this.name = name;
        this.nearDistance = nearDistance;
        this.spawnOffset = spawnOffset;
    }

    @Nullable
    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntitySingleUseSpawner(this.entityClass, this.delay, this.nearDistance, this.spawnOffset);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack heldItem = player.func_184586_b(hand);
        Item activationItem = this.activationItemSupplier.get();
        if (heldItem.func_77973_b() != activationItem && activationItem != null) {
            if (!world.field_72995_K && hand == EnumHand.MAIN_HAND) {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("message.spawner.item", new Object[]{String.format("%s", activationItem.func_77653_i(new ItemStack(activationItem)))}));
            }
            return false;
        }
        if (world.func_175659_aa() == EnumDifficulty.PEACEFUL) {
            if (!world.field_72995_K && hand == EnumHand.MAIN_HAND) {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("message.spawner.peaceful", new Object[0]));
            }
            return false;
        }
        TileEntity spawnerTile = world.func_175625_s(pos);
        if (spawnerTile instanceof TileEntitySingleUseSpawner) {
            if (!world.field_72995_K && hand == EnumHand.MAIN_HAND) {
                ((TileEntitySingleUseSpawner)spawnerTile).activate(player);
                if (!player.func_184812_l_()) {
                    heldItem.func_190918_g(1);
                }
            }
            return true;
        }
        return false;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Items.field_190931_a;
    }

    public int getExpDrop(IBlockState state, IBlockAccess world, BlockPos pos, int fortune) {
        return 15 + RANDOM.nextInt(15) + RANDOM.nextInt(15);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return ItemStack.field_190927_a;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        super.func_180655_c(stateIn, worldIn, pos, rand);
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (!(tileEntity instanceof TileEntitySingleUseSpawner) || !((TileEntitySingleUseSpawner)tileEntity).isActivated()) {
            return;
        }
        DivineRPG.proxy.spawnParticle(worldIn, ParticleType.BLACK_FLAME, (double)pos.func_177956_o() + Math.random() - Math.random(), (double)pos.func_177956_o() + Math.random(), (double)pos.func_177952_p() + Math.random() - Math.random(), Math.random(), Math.random(), Math.random());
    }
}

