/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.objects.blocks;

import divinerpg.objects.blocks.BlockMod;
import divinerpg.objects.blocks.BlockModCrop;
import divinerpg.objects.blocks.BlockModDirt;
import divinerpg.objects.blocks.twilight.BlockBrambles;
import divinerpg.objects.blocks.twilight.BlockModDoublePlant;
import divinerpg.objects.blocks.twilight.BlockTwilightFlower;
import divinerpg.objects.items.base.ItemModSeeds;
import java.util.ArrayList;
import java.util.Random;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;

public abstract class BlockModGrass
extends BlockMod
implements IGrowable {
    protected ArrayList<Supplier<Block>> growablePlantsList = new ArrayList();
    protected Supplier<BlockModDirt> dirtSupplier;
    private MapColor mapColor;

    public BlockModGrass(String name, Supplier<BlockModDirt> dirtSupplier, float hardness, @Nonnull MapColor mapColorIn) {
        super(name, hardness, Material.field_151577_b);
        this.setMapColor(mapColorIn);
        this.dirtSupplier = dirtSupplier;
        this.setHarvestLevel("shovel", 0);
        this.func_149675_a(true);
        this.func_149672_a(SoundType.field_185849_b);
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)this.dirtSupplier.get());
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (!world.field_72995_K) {
            if (!world.func_175697_a(pos, 3)) {
                return;
            }
            Block dirt = this.dirtSupplier.get();
            if (world.func_175671_l(pos.func_177984_a()) < 4 && world.func_180495_p(pos.func_177984_a()).getLightOpacity((IBlockAccess)world, pos.func_177984_a()) > 2) {
                world.func_175656_a(pos, dirt.func_176223_P());
            } else {
                for (int l = 0; l < 4; ++l) {
                    BlockPos blockpos = pos.func_177982_a(rand.nextInt(3) - 1, rand.nextInt(5) - 3, rand.nextInt(3) - 1);
                    if (blockpos.func_177956_o() >= 0 && blockpos.func_177956_o() < 256 && !world.func_175667_e(blockpos)) {
                        return;
                    }
                    IBlockState iblockstate = world.func_180495_p(blockpos.func_177984_a());
                    IBlockState iblockstate1 = world.func_180495_p(blockpos);
                    if (iblockstate1.func_177230_c() != dirt || world.func_175671_l(blockpos.func_177984_a()) < 4 || iblockstate.getLightOpacity((IBlockAccess)world, pos.func_177984_a()) > 2) continue;
                    world.func_175656_a(blockpos, this.func_176223_P());
                }
            }
        }
    }

    public boolean func_176473_a(World worldIn, BlockPos pos, IBlockState state, boolean isClient) {
        return this.growablePlantsList.size() > 0;
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        return this.growablePlantsList.size() > 0;
    }

    public void func_176474_b(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        if (this.growablePlantsList.size() <= 0) {
            return;
        }
        BlockPos blockpos = pos.func_177984_a();
        block0: for (int i = 0; i < 128; ++i) {
            IBlockState flowerState;
            Block flower;
            BlockPos blockpos1 = blockpos;
            for (int j = 0; j < i / 16; ++j) {
                if (worldIn.func_180495_p((blockpos1 = blockpos1.func_177982_a(rand.nextInt(3) - 1, (rand.nextInt(3) - 1) * rand.nextInt(3) / 2, rand.nextInt(3) - 1)).func_177977_b()).func_177230_c() != this || worldIn.func_180495_p(blockpos1).func_185915_l()) continue block0;
            }
            if (!worldIn.func_175623_d(blockpos1) || (flower = this.growablePlantsList.get(rand.nextInt(this.growablePlantsList.size())).get()) == null || !(flower instanceof BlockBush) || !((BlockBush)flower).func_180671_f(worldIn, blockpos1, flowerState = flower.func_176223_P())) continue;
            worldIn.func_180501_a(blockpos1, flowerState, 3);
        }
    }

    protected void addGrowablePlant(Supplier<Block> blockSupplier) {
        this.growablePlantsList.add(blockSupplier);
    }

    public boolean canSustainPlant(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing direction, IPlantable plantable) {
        Item seed;
        ItemStack item;
        if (plantable instanceof BlockModCrop && (item = ((BlockModCrop)plantable).func_185473_a((World)world, pos, state)) != null && (seed = item.func_77973_b()) instanceof ItemModSeeds) {
            plantable = (ItemModSeeds)seed;
        }
        if (plantable instanceof BlockModDoublePlant) {
            return ((BlockModDoublePlant)plantable).getGrass() == this;
        }
        if (plantable instanceof BlockBrambles) {
            return ((BlockBrambles)plantable).getGrass() == this;
        }
        if (plantable instanceof BlockTwilightFlower) {
            return ((BlockTwilightFlower)plantable).getGrass() == this;
        }
        if (plantable instanceof ItemModSeeds) {
            return ((ItemModSeeds)plantable).soilSupplier.get() == this;
        }
        return false;
    }

    private void setMapColor(MapColor mapColorIn) {
        this.mapColor = mapColorIn == null ? Material.field_151577_b.func_151565_r() : mapColorIn;
    }

    public MapColor func_180659_g(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return this.mapColor;
    }
}

