/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.networking.message;

import divinerpg.DivineRPG;
import divinerpg.api.DivineAPI;
import divinerpg.api.arcana.IArcana;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class MessageArcanaBar
implements IMessage {
    private int delay;
    private float arcana;
    private float max;

    public MessageArcanaBar() {
    }

    public MessageArcanaBar(IArcana arcana) {
        if (arcana == null) {
            return;
        }
        this.delay = arcana.getRegenDelay();
        this.arcana = arcana.getArcana();
        this.max = arcana.getMaxArcana();
    }

    public void fromBytes(ByteBuf byteBuf) {
        this.max = byteBuf.readFloat();
        this.arcana = byteBuf.readFloat();
        this.delay = byteBuf.readInt();
    }

    public void toBytes(ByteBuf byteBuf) {
        byteBuf.writeFloat(this.max);
        byteBuf.writeFloat(this.arcana);
        byteBuf.writeInt(this.delay);
    }

    public static class Handler
    implements IMessageHandler<MessageArcanaBar, IMessage> {
        public IMessage onMessage(MessageArcanaBar msg, MessageContext ctx) {
            IArcana capability;
            if (ctx.side == Side.CLIENT && (capability = DivineAPI.getArcana((Entity)DivineRPG.proxy.getPlayer())) != null) {
                capability.setMaxArcana(msg.max);
                capability.setRegenDelay(msg.delay);
                capability.set(msg.arcana);
            }
            return null;
        }
    }
}

