/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.dimensions.mortum;

import com.google.common.base.Predicate;
import divinerpg.registry.BlockRegistry;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.state.IBlockState;
import net.minecraft.block.state.pattern.BlockMatcher;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.NoiseGeneratorOctaves;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.event.terraingen.InitNoiseGensEvent;
import net.minecraftforge.event.terraingen.OreGenEvent;
import net.minecraftforge.event.terraingen.TerrainGen;

public class MortumChunkGenerator
implements IChunkGenerator {
    protected static final IBlockState AIR = Blocks.field_150350_a.func_176223_P();
    protected static final IBlockState STONE = BlockRegistry.twilightStone.func_176223_P();
    protected static final IBlockState BEDROCK = Blocks.field_150357_h.func_176223_P();
    protected static final IBlockState TAR = BlockRegistry.smolderingTar.func_176223_P();
    protected static final IBlockState GRASS = BlockRegistry.mortumGrass.func_176223_P();
    protected static final IBlockState DIRT = BlockRegistry.mortumDirt.func_176223_P();
    private final World world;
    private final Random rand;
    private double[] slowsandNoise = new double[256];
    private double[] gravelNoise = new double[256];
    private double[] depthBuffer = new double[256];
    private double[] buffer;
    double[] pnr;
    double[] ar;
    double[] br;
    double[] noiseData4;
    double[] dr;
    private NoiseGeneratorOctaves lperlinNoise1;
    private NoiseGeneratorOctaves lperlinNoise2;
    private NoiseGeneratorOctaves perlinNoise1;
    private NoiseGeneratorOctaves slowsandGravelNoiseGen;
    private NoiseGeneratorOctaves netherrackExculsivityNoiseGen;
    public NoiseGeneratorOctaves scaleNoise;
    public NoiseGeneratorOctaves depthNoise;
    private final WorldGenerator ore = new WorldGenMinable(BlockRegistry.mortumOre.func_176223_P(), 8, (Predicate)BlockMatcher.func_177642_a((Block)STONE.func_177230_c()));

    public MortumChunkGenerator(World worldIn, long seed) {
        this.world = worldIn;
        this.rand = new Random(seed);
        this.lperlinNoise1 = new NoiseGeneratorOctaves(this.rand, 16);
        this.lperlinNoise2 = new NoiseGeneratorOctaves(this.rand, 16);
        this.perlinNoise1 = new NoiseGeneratorOctaves(this.rand, 8);
        this.slowsandGravelNoiseGen = new NoiseGeneratorOctaves(this.rand, 4);
        this.netherrackExculsivityNoiseGen = new NoiseGeneratorOctaves(this.rand, 4);
        this.scaleNoise = new NoiseGeneratorOctaves(this.rand, 10);
        this.depthNoise = new NoiseGeneratorOctaves(this.rand, 16);
        worldIn.func_181544_b(63);
        InitNoiseGensEvent.ContextHell ctx = new InitNoiseGensEvent.ContextHell(this.lperlinNoise1, this.lperlinNoise2, this.perlinNoise1, this.slowsandGravelNoiseGen, this.netherrackExculsivityNoiseGen, this.scaleNoise, this.depthNoise);
        ctx = (InitNoiseGensEvent.ContextHell)TerrainGen.getModdedNoiseGenerators((World)worldIn, (Random)this.rand, (InitNoiseGensEvent.Context)ctx);
        this.lperlinNoise1 = ctx.getLPerlin1();
        this.lperlinNoise2 = ctx.getLPerlin2();
        this.perlinNoise1 = ctx.getPerlin();
        this.slowsandGravelNoiseGen = ctx.getPerlin2();
        this.netherrackExculsivityNoiseGen = ctx.getPerlin3();
        this.scaleNoise = ctx.getScale();
        this.depthNoise = ctx.getDepth();
    }

    private void generateBedrockLayers(ChunkPrimer primer) {
        for (int posX = 0; posX < 16; ++posX) {
            for (int posZ = 0; posZ < 16; ++posZ) {
                primer.func_177855_a(posX, 0, posZ, Blocks.field_150357_h.func_176223_P());
                primer.func_177855_a(posX, 128, posZ, Blocks.field_150357_h.func_176223_P());
            }
        }
    }

    public void prepareHeights(int p_185936_1_, int p_185936_2_, ChunkPrimer primer) {
        int i = 4;
        int j = this.world.func_181545_F() / 2 + 1;
        int k = 5;
        int l = 17;
        int i1 = 5;
        this.buffer = this.getHeights(this.buffer, p_185936_1_ * 4, 0, p_185936_2_ * 4, 5, 17, 5);
        for (int j1 = 0; j1 < 4; ++j1) {
            for (int k1 = 0; k1 < 4; ++k1) {
                for (int l1 = 0; l1 < 16; ++l1) {
                    double d0 = 0.125;
                    double d1 = this.buffer[((j1 + 0) * 5 + k1 + 0) * 17 + l1 + 0];
                    double d2 = this.buffer[((j1 + 0) * 5 + k1 + 1) * 17 + l1 + 0];
                    double d3 = this.buffer[((j1 + 1) * 5 + k1 + 0) * 17 + l1 + 0];
                    double d4 = this.buffer[((j1 + 1) * 5 + k1 + 1) * 17 + l1 + 0];
                    double d5 = (this.buffer[((j1 + 0) * 5 + k1 + 0) * 17 + l1 + 1] - d1) * 0.125;
                    double d6 = (this.buffer[((j1 + 0) * 5 + k1 + 1) * 17 + l1 + 1] - d2) * 0.125;
                    double d7 = (this.buffer[((j1 + 1) * 5 + k1 + 0) * 17 + l1 + 1] - d3) * 0.125;
                    double d8 = (this.buffer[((j1 + 1) * 5 + k1 + 1) * 17 + l1 + 1] - d4) * 0.125;
                    for (int i2 = 0; i2 < 8; ++i2) {
                        double d9 = 0.25;
                        double d10 = d1;
                        double d11 = d2;
                        double d12 = (d3 - d1) * 0.25;
                        double d13 = (d4 - d2) * 0.25;
                        for (int j2 = 0; j2 < 4; ++j2) {
                            double d14 = 0.25;
                            double d15 = d10;
                            double d16 = (d11 - d10) * 0.25;
                            for (int k2 = 0; k2 < 4; ++k2) {
                                IBlockState iblockstate = null;
                                if (l1 * 8 + i2 < j) {
                                    iblockstate = TAR;
                                }
                                if (d15 > 0.0) {
                                    iblockstate = STONE;
                                }
                                int l2 = j2 + j1 * 4;
                                int i3 = i2 + l1 * 8;
                                int j3 = k2 + k1 * 4;
                                primer.func_177855_a(l2, i3, j3, iblockstate);
                                d15 += d16;
                            }
                            d10 += d12;
                            d11 += d13;
                        }
                        d1 += d5;
                        d2 += d6;
                        d3 += d7;
                        d4 += d8;
                    }
                }
            }
        }
    }

    protected void buildSurfaces(int i, int j, ChunkPrimer chunkPrimer) {
        for (int k = 0; k < 16; ++k) {
            for (int l = 0; l < 16; ++l) {
                int j1 = -1;
                int i1 = (int)(3.0 + this.rand.nextDouble() * 0.25);
                IBlockState top = GRASS;
                IBlockState filler = DIRT;
                for (int k1 = 127; k1 >= 0; --k1) {
                    IBlockState state = chunkPrimer.func_177856_a(k, k1, l);
                    if (state == AIR) {
                        j1 = -1;
                        continue;
                    }
                    if (state != STONE) continue;
                    if (j1 == -1) {
                        if (i1 <= 0) {
                            top = AIR;
                            filler = STONE;
                        }
                        j1 = i1;
                        if (k1 >= 0) {
                            chunkPrimer.func_177855_a(k, k1, l, top);
                            continue;
                        }
                        chunkPrimer.func_177855_a(k, k1, l, filler);
                        continue;
                    }
                    if (j1 <= 0) continue;
                    --j1;
                    chunkPrimer.func_177855_a(k, k1, l, filler);
                }
            }
        }
    }

    public Chunk func_185932_a(int x, int z) {
        this.rand.setSeed((long)x * 341873128712L + (long)z * 132897987541L);
        ChunkPrimer chunkPrimer = new ChunkPrimer();
        this.prepareHeights(x, z, chunkPrimer);
        this.buildSurfaces(x, z, chunkPrimer);
        this.generateBedrockLayers(chunkPrimer);
        Chunk chunk = new Chunk(this.world, chunkPrimer, x, z);
        chunk.func_76603_b();
        return chunk;
    }

    private double[] getHeights(double[] noise, int x, int y, int z, int sizeX, int sizeY, int sizeZ) {
        if (noise == null) {
            noise = new double[sizeX * sizeY * sizeZ];
        }
        double d = 684.412;
        double d1 = 2053.236;
        this.noiseData4 = this.netherrackExculsivityNoiseGen.func_76304_a(this.noiseData4, x, y, z, sizeX, 1, sizeZ, 1.0, 0.0, 1.0);
        this.dr = this.scaleNoise.func_76304_a(this.dr, x, y, z, sizeX, 1, sizeZ, 100.0, 0.0, 100.0);
        this.pnr = this.perlinNoise1.func_76304_a(this.pnr, x, y, z, sizeX, sizeY, sizeZ, d * 0.0125, d1 / 60.0, d * 0.0125);
        this.ar = this.lperlinNoise1.func_76304_a(this.ar, x, y, z, sizeX, sizeY, sizeZ, d, d1, d);
        this.br = this.lperlinNoise2.func_76304_a(this.br, x, y, z, sizeX, sizeY, sizeZ, d, d1, d);
        int index = 0;
        int j = 0;
        double[] ad = new double[sizeY];
        double oneOver512 = 0.001953125;
        double groundNoiseMp = 4.8828125E-4;
        for (int k = 0; k < sizeY; ++k) {
            ad[k] = Math.cos((double)k * Math.PI * 6.0 / (double)sizeY) * 2.0;
            double d2 = k;
            if (k > sizeY / 2) {
                d2 = sizeY - 1 - k;
            }
            if (!(d2 < 4.0)) continue;
            d2 = 4.0 - d2;
            int n = k;
            ad[n] = ad[n] - d2 * d2 * d2 * 10.0;
        }
        for (int xx = 0; xx < sizeX; ++xx) {
            for (int zz = 0; zz < sizeZ; ++zz) {
                double d3 = (this.noiseData4[j] + 256.0) * oneOver512;
                if (d3 > 1.0) {
                    d3 = 1.0;
                }
                double d4 = 0.0;
                double d5 = this.dr[j] * 1.25E-4;
                if (d5 < 0.0) {
                    d5 = -d5;
                }
                if ((d5 = d5 * 3.0 - 3.0) < 0.0) {
                    if ((d5 /= 2.0) < -1.0) {
                        d5 = -1.0;
                    }
                    d5 /= 1.4;
                    d5 *= 0.5;
                    d3 = 0.0;
                } else {
                    if (d5 > 1.0) {
                        d5 = 1.0;
                    }
                    d5 /= 6.0;
                }
                d3 += 0.5;
                d5 = d5 * (double)sizeY * 0.0625;
                ++j;
                for (int yy = 0; yy < sizeY; ++yy) {
                    double d6 = 0.0;
                    double d7 = ad[yy];
                    double d8 = this.ar[index] * groundNoiseMp;
                    double d9 = this.br[index] * groundNoiseMp;
                    double d10 = (this.pnr[index] * 0.1 + 1.0) * 0.5;
                    d6 = d10 < 0.0 ? d8 : (d10 > 1.0 ? d9 : d8 + (d9 - d8) * d10);
                    d6 -= d7;
                    if (yy > sizeY - 4) {
                        double d11 = (float)(yy - (sizeY - 4)) / 3.0f;
                        d6 = d6 * (1.0 - d11) + -10.0 * d11;
                    }
                    if ((double)yy < d4) {
                        double d12 = (d4 - (double)yy) * 0.25;
                        if (d12 < 0.0) {
                            d12 = 0.0;
                        }
                        if (d12 > 1.0) {
                            d12 = 1.0;
                        }
                        d6 = d6 * (1.0 - d12) + -10.0 * d12;
                    }
                    noise[index] = d6;
                    ++index;
                }
            }
        }
        return noise;
    }

    public void func_185931_b(int x, int z) {
        BlockFalling.field_149832_M = true;
        int i = x * 16;
        int j = z * 16;
        BlockPos blockpos = new BlockPos(i, 0, j);
        Biome biome = this.world.func_180494_b(blockpos.func_177982_a(16, 0, 16));
        if (TerrainGen.generateOre((World)this.world, (Random)this.rand, (WorldGenerator)this.ore, (BlockPos)blockpos, (OreGenEvent.GenerateMinable.EventType)OreGenEvent.GenerateMinable.EventType.QUARTZ)) {
            for (int var13 = 0; var13 < 2; ++var13) {
                int var14 = i + this.rand.nextInt(16);
                int var15 = this.rand.nextInt(128);
                int var16 = j + this.rand.nextInt(16);
                this.ore.func_180709_b(this.world, this.rand, blockpos);
            }
        }
        BlockFalling.field_149832_M = false;
        biome.func_180624_a(this.world, this.rand, blockpos);
    }

    public boolean func_185933_a(Chunk chunkIn, int x, int z) {
        return false;
    }

    public List<Biome.SpawnListEntry> func_177458_a(EnumCreatureType creatureType, BlockPos pos) {
        Biome biome = this.world.func_180494_b(pos);
        return biome.func_76747_a(creatureType);
    }

    @Nullable
    public BlockPos func_180513_a(World worldIn, String structureName, BlockPos position, boolean findUnexplored) {
        return null;
    }

    public void func_180514_a(Chunk chunkIn, int x, int z) {
    }

    public boolean func_193414_a(World worldIn, String structureName, BlockPos pos) {
        return false;
    }
}

