/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.dimensions;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;

public class LargeTwilightTree
extends WorldGenAbstractTree {
    protected int minTrunkHeight;
    protected IBlockState log;
    protected IBlockState leaves;
    protected Block grass;

    public LargeTwilightTree(boolean notify, int minTrunkHeight, IBlockState log, IBlockState leaves, Block grass) {
        super(notify);
        this.minTrunkHeight = minTrunkHeight;
        this.log = log;
        this.leaves = leaves;
        this.grass = grass;
    }

    public boolean func_180709_b(World world, Random random, BlockPos blockPos) {
        int trunkHeight = random.nextInt(4) + this.minTrunkHeight;
        int treeHeight = 10 + trunkHeight;
        if (blockPos.func_177956_o() < 1 || blockPos.func_177956_o() + treeHeight + 1 > 256 || world.func_180495_p(blockPos.func_177977_b()).func_177230_c() != this.grass || blockPos.func_177956_o() >= 256 - treeHeight - 1) {
            return false;
        }
        for (int x = -5; x <= 5; ++x) {
            for (int z = -5; z <= 5; ++z) {
                for (int y = trunkHeight; y <= treeHeight; ++y) {
                    if (world.func_175623_d(new BlockPos(blockPos.func_177958_n() + x, blockPos.func_177956_o() + y, blockPos.func_177952_p() + z))) continue;
                    return false;
                }
            }
        }
        return this.generateTree(world, blockPos, treeHeight, trunkHeight);
    }

    protected boolean generateTree(World world, BlockPos blockPos, int treeHeight, int trunkHeight) {
        this.buildLeaves1(world, blockPos, trunkHeight + 2);
        this.buildLeaves2(world, blockPos, trunkHeight + 3);
        this.buildLeaves3(world, blockPos, trunkHeight + 4);
        this.buildLeaves4(world, blockPos, trunkHeight + 5);
        this.buildLeaves5(world, blockPos, trunkHeight + 6);
        this.buildLeaves4(world, blockPos, trunkHeight + 7);
        this.buildLeaves6(world, blockPos, trunkHeight + 8);
        this.buildLeaves6(world, blockPos, treeHeight);
        this.buildTrunk(world, blockPos, treeHeight);
        this.buildBranchBase(world, blockPos, trunkHeight);
        this.buildBranches(world, blockPos, trunkHeight + 2);
        this.buildBranchBase(world, blockPos, trunkHeight + 4);
        this.buildBranches2(world, blockPos, trunkHeight + 6);
        this.setTreeHeight(world, blockPos, treeHeight);
        return true;
    }

    private void buildLeaves6(World world, BlockPos blockPos, int height) {
        this.func_175903_a(world, blockPos.func_177982_a(0, height, -1), this.leaves);
        this.func_175903_a(world, blockPos.func_177982_a(0, height, 1), this.leaves);
        this.func_175903_a(world, blockPos.func_177982_a(-1, height, 0), this.leaves);
        this.func_175903_a(world, blockPos.func_177982_a(1, height, 0), this.leaves);
        this.func_175903_a(world, blockPos.func_177982_a(0, height + 1, 0), this.leaves);
    }

    private void buildLeaves5(World world, BlockPos blockPos, int height) {
        int z;
        int x;
        for (x = 0; x < 3; ++x) {
            for (z = 0; z < 5; ++z) {
                this.func_175903_a(world, blockPos.func_177982_a(x - 1, height, z - 2), this.leaves);
            }
        }
        for (x = 0; x < 5; ++x) {
            for (z = 0; z < 3; ++z) {
                this.func_175903_a(world, blockPos.func_177982_a(x - 2, height, z - 1), this.leaves);
            }
        }
        this.func_175903_a(world, blockPos.func_177982_a(0, height, -3), this.leaves);
        this.func_175903_a(world, blockPos.func_177982_a(0, height, 3), this.leaves);
        this.func_175903_a(world, blockPos.func_177982_a(-3, height, 0), this.leaves);
        this.func_175903_a(world, blockPos.func_177982_a(3, height, 0), this.leaves);
    }

    private void buildLeaves4(World world, BlockPos blockPos, int height) {
        this.func_175903_a(world, blockPos.func_177982_a(0, height, -1), this.leaves);
        this.func_175903_a(world, blockPos.func_177982_a(0, height, 1), this.leaves);
        this.func_175903_a(world, blockPos.func_177982_a(-1, height, 0), this.leaves);
        this.func_175903_a(world, blockPos.func_177982_a(1, height, 0), this.leaves);
        this.func_175903_a(world, blockPos.func_177982_a(0, height, -2), this.leaves);
        this.func_175903_a(world, blockPos.func_177982_a(1, height, -1), this.leaves);
        this.func_175903_a(world, blockPos.func_177982_a(2, height, 0), this.leaves);
        this.func_175903_a(world, blockPos.func_177982_a(1, height, 1), this.leaves);
        this.func_175903_a(world, blockPos.func_177982_a(0, height, 2), this.leaves);
        this.func_175903_a(world, blockPos.func_177982_a(-1, height, 1), this.leaves);
        this.func_175903_a(world, blockPos.func_177982_a(-2, height, 0), this.leaves);
        this.func_175903_a(world, blockPos.func_177982_a(-1, height, -1), this.leaves);
    }

    private void buildLeaves3(World world, BlockPos blockPos, int height) {
        for (int x = 0; x <= 4; ++x) {
            for (int z = 0; z <= 4; ++z) {
                this.func_175903_a(world, blockPos.func_177982_a(x - 2, height, z - 2), this.leaves);
            }
        }
        for (int length = 2; length <= 3; ++length) {
            this.func_175903_a(world, blockPos.func_177982_a(0, height, -length - 1), this.leaves);
            this.func_175903_a(world, blockPos.func_177982_a(length, height, -length), this.leaves);
            this.func_175903_a(world, blockPos.func_177982_a(length + 1, height, 0), this.leaves);
            this.func_175903_a(world, blockPos.func_177982_a(length, height, length), this.leaves);
            this.func_175903_a(world, blockPos.func_177982_a(0, height, length + 1), this.leaves);
            this.func_175903_a(world, blockPos.func_177982_a(-length, height, length), this.leaves);
            this.func_175903_a(world, blockPos.func_177982_a(-length - 1, height, 0), this.leaves);
            this.func_175903_a(world, blockPos.func_177982_a(-length, height, -length), this.leaves);
        }
    }

    private void buildLeaves2(World world, BlockPos blockPos, int height) {
        this.func_175903_a(world, blockPos.func_177982_a(0, height, -5), this.leaves);
        this.func_175903_a(world, blockPos.func_177982_a(0, height, 5), this.leaves);
        this.func_175903_a(world, blockPos.func_177982_a(-5, height, 0), this.leaves);
        this.func_175903_a(world, blockPos.func_177982_a(5, height, 0), this.leaves);
        this.func_175903_a(world, blockPos.func_177982_a(1, height, -4), this.leaves);
        this.func_175903_a(world, blockPos.func_177982_a(1, height, 4), this.leaves);
        this.func_175903_a(world, blockPos.func_177982_a(-4, height, 1), this.leaves);
        this.func_175903_a(world, blockPos.func_177982_a(4, height, 1), this.leaves);
        this.func_175903_a(world, blockPos.func_177982_a(-1, height, -4), this.leaves);
        this.func_175903_a(world, blockPos.func_177982_a(-1, height, 4), this.leaves);
        this.func_175903_a(world, blockPos.func_177982_a(-4, height, -1), this.leaves);
        this.func_175903_a(world, blockPos.func_177982_a(4, height, -1), this.leaves);
        this.func_175903_a(world, blockPos.func_177982_a(3, height, 4), this.leaves);
        this.func_175903_a(world, blockPos.func_177982_a(3, height, -4), this.leaves);
        this.func_175903_a(world, blockPos.func_177982_a(-3, height, 4), this.leaves);
        this.func_175903_a(world, blockPos.func_177982_a(-3, height, -4), this.leaves);
        this.func_175903_a(world, blockPos.func_177982_a(4, height, 3), this.leaves);
        this.func_175903_a(world, blockPos.func_177982_a(4, height, -3), this.leaves);
        this.func_175903_a(world, blockPos.func_177982_a(-4, height, 3), this.leaves);
        this.func_175903_a(world, blockPos.func_177982_a(-4, height, -3), this.leaves);
        for (int x = -1; x <= 5; ++x) {
            for (int z = -1; z <= 5; ++z) {
                this.func_175903_a(world, blockPos.func_177982_a(x - 2, height, z - 2), this.leaves);
            }
        }
    }

    private void buildLeaves1(World world, BlockPos blockPos, int height) {
        this.func_175903_a(world, blockPos.func_177982_a(0, height, -1), this.leaves);
        this.func_175903_a(world, blockPos.func_177982_a(0, height, 1), this.leaves);
        this.func_175903_a(world, blockPos.func_177982_a(-1, height, 0), this.leaves);
        this.func_175903_a(world, blockPos.func_177982_a(1, height, 0), this.leaves);
    }

    private void buildBranches2(World world, BlockPos blockPos, int height) {
        this.func_175903_a(world, blockPos.func_177982_a(0, height, -2), this.log);
        this.func_175903_a(world, blockPos.func_177982_a(0, height, 2), this.log);
        this.func_175903_a(world, blockPos.func_177982_a(-2, height, 0), this.log);
        this.func_175903_a(world, blockPos.func_177982_a(2, height, 0), this.log);
    }

    private void buildBranches(World world, BlockPos blockPos, int height) {
        this.func_175903_a(world, blockPos.func_177982_a(0, height, -2), this.log);
        this.func_175903_a(world, blockPos.func_177982_a(1, height, -1), this.log);
        this.func_175903_a(world, blockPos.func_177982_a(2, height, 0), this.log);
        this.func_175903_a(world, blockPos.func_177982_a(1, height, 1), this.log);
        this.func_175903_a(world, blockPos.func_177982_a(0, height, 2), this.log);
        this.func_175903_a(world, blockPos.func_177982_a(-1, height, 1), this.log);
        this.func_175903_a(world, blockPos.func_177982_a(-2, height, 0), this.log);
        this.func_175903_a(world, blockPos.func_177982_a(-1, height, -1), this.log);
        for (int length = 2; length <= 3; ++length) {
            this.func_175903_a(world, blockPos.func_177982_a(0, height + 1, -length - 1), this.log);
            this.func_175903_a(world, blockPos.func_177982_a(length, height + 1, -length), this.log);
            this.func_175903_a(world, blockPos.func_177982_a(length + 1, height + 1, 0), this.log);
            this.func_175903_a(world, blockPos.func_177982_a(length, height + 1, length), this.log);
            this.func_175903_a(world, blockPos.func_177982_a(0, height + 1, length + 1), this.log);
            this.func_175903_a(world, blockPos.func_177982_a(-length, height + 1, length), this.log);
            this.func_175903_a(world, blockPos.func_177982_a(-length - 1, height + 1, 0), this.log);
            this.func_175903_a(world, blockPos.func_177982_a(-length, height + 1, -length), this.log);
        }
    }

    private void buildBranchBase(World world, BlockPos blockPos, int trunkHeight) {
        for (int dy = trunkHeight; dy <= trunkHeight + 1; ++dy) {
            this.func_175903_a(world, blockPos.func_177982_a(0, dy, -1), this.log);
            this.func_175903_a(world, blockPos.func_177982_a(0, dy, 1), this.log);
            this.func_175903_a(world, blockPos.func_177982_a(-1, dy, 0), this.log);
            this.func_175903_a(world, blockPos.func_177982_a(1, dy, 0), this.log);
        }
    }

    private void buildTrunk(World world, BlockPos blockPos, int treeHeight) {
        this.func_175903_a(world, blockPos.func_177982_a(0, -1, -1), this.log);
        this.func_175903_a(world, blockPos.func_177982_a(0, -1, 1), this.log);
        this.func_175903_a(world, blockPos.func_177982_a(-1, -1, 0), this.log);
        this.func_175903_a(world, blockPos.func_177982_a(1, -1, 0), this.log);
        for (int dy = -1; dy <= treeHeight; ++dy) {
            this.func_175903_a(world, blockPos.func_177982_a(0, dy, 0), this.log);
        }
    }

    @Deprecated
    private int setTreeHeight(World world, BlockPos pos, int treeHeight) {
        return treeHeight;
    }
}

