/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.dimensions;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.NoiseGeneratorOctaves;

public abstract class IslandChunkGeneratorBase
implements IChunkGenerator {
    private final NoiseGeneratorOctaves noiseGen1;
    private final NoiseGeneratorOctaves perlinNoise1;
    protected final Random rand;
    protected final World world;
    private static final IBlockState AIR = Blocks.field_150350_a.func_176223_P();
    private final IBlockState STONE;
    private final IBlockState GRASS;
    private final IBlockState DIRT;
    private double[] buffer;
    private double[] pnr;
    private double[] ar;
    private double[] br;

    public IslandChunkGeneratorBase(World world, Block stone, Block grass, Block dirt) {
        this.rand = new Random(world.func_72905_C() + (long)world.field_73011_w.getDimension());
        this.world = world;
        this.noiseGen1 = new NoiseGeneratorOctaves(this.rand, 16);
        this.perlinNoise1 = new NoiseGeneratorOctaves(this.rand, 8);
        this.STONE = stone.func_176223_P();
        this.GRASS = grass.func_176223_P();
        this.DIRT = dirt.func_176223_P();
    }

    public Chunk func_185932_a(int x, int z) {
        this.rand.setSeed((long)x * 341873128712L + (long)z * 132897987541L);
        ChunkPrimer chunkPrimer = new ChunkPrimer();
        this.setBlocksInChunk(x, z, chunkPrimer);
        this.buildSurfaces(x, z, chunkPrimer);
        Chunk chunk = new Chunk(this.world, chunkPrimer, x, z);
        chunk.func_76603_b();
        return chunk;
    }

    public boolean func_185933_a(Chunk chunk, int i, int i1) {
        return false;
    }

    public List<Biome.SpawnListEntry> func_177458_a(EnumCreatureType creatureType, BlockPos pos) {
        Biome biome = this.world.func_72959_q().func_180631_a(pos);
        return biome.func_76747_a(creatureType);
    }

    @Nullable
    public BlockPos func_180513_a(World world, String s, BlockPos blockPos, boolean b) {
        return null;
    }

    public void func_180514_a(Chunk chunk, int i, int i1) {
    }

    public boolean func_193414_a(World world, String s, BlockPos blockPos) {
        return false;
    }

    protected void setBlocksInChunk(int x, int z, ChunkPrimer chunkPrimer) {
        this.buffer = this.setupNoiseGenerators(this.buffer, x * 2, z * 2);
        for (int i1 = 0; i1 < 2; ++i1) {
            for (int j1 = 0; j1 < 2; ++j1) {
                for (int k1 = 0; k1 < 32; ++k1) {
                    double d1 = this.buffer[(i1 * 3 + j1) * 33 + k1];
                    double d2 = this.buffer[(i1 * 3 + (j1 + 1)) * 33 + k1];
                    double d3 = this.buffer[((i1 + 1) * 3 + j1) * 33 + k1];
                    double d4 = this.buffer[((i1 + 1) * 3 + (j1 + 1)) * 33 + k1];
                    double d5 = (this.buffer[(i1 * 3 + j1) * 33 + (k1 + 1)] - d1) * 0.25;
                    double d6 = (this.buffer[(i1 * 3 + (j1 + 1)) * 33 + (k1 + 1)] - d2) * 0.25;
                    double d7 = (this.buffer[((i1 + 1) * 3 + j1) * 33 + (k1 + 1)] - d3) * 0.25;
                    double d8 = (this.buffer[((i1 + 1) * 3 + (j1 + 1)) * 33 + (k1 + 1)] - d4) * 0.25;
                    for (int l1 = 0; l1 < 4; ++l1) {
                        double d10 = d1;
                        double d11 = d2;
                        double d12 = (d3 - d1) * 0.125;
                        double d13 = (d4 - d2) * 0.125;
                        for (int i2 = 0; i2 < 8; ++i2) {
                            double d15 = d10;
                            double d16 = (d11 - d10) * 0.125;
                            for (int k2 = 0; k2 < 8; ++k2) {
                                int x1 = i2 + i1 * 8;
                                int y = l1 + k1 * 4;
                                int z1 = k2 + j1 * 8;
                                IBlockState filler = AIR;
                                if (d15 > 0.0) {
                                    filler = this.STONE;
                                }
                                chunkPrimer.func_177855_a(x1, y, z1, filler);
                                d15 += d16;
                            }
                            d10 += d12;
                            d11 += d13;
                        }
                        d1 += d5;
                        d2 += d6;
                        d3 += d7;
                        d4 += d8;
                    }
                }
            }
        }
    }

    protected void buildSurfaces(int i, int j, ChunkPrimer chunkPrimer) {
        for (int k = 0; k < 16; ++k) {
            for (int l = 0; l < 16; ++l) {
                int j1 = -1;
                int i1 = (int)(3.0 + this.rand.nextDouble() * 0.25);
                IBlockState top = this.GRASS;
                IBlockState filler = this.DIRT;
                for (int k1 = 127; k1 >= 0; --k1) {
                    IBlockState state = chunkPrimer.func_177856_a(k, k1, l);
                    if (state == AIR) {
                        j1 = -1;
                        continue;
                    }
                    if (state != this.STONE) continue;
                    if (j1 == -1) {
                        if (i1 <= 0) {
                            top = AIR;
                            filler = this.STONE;
                        }
                        j1 = i1;
                        if (k1 >= 0) {
                            chunkPrimer.func_177855_a(k, k1, l, top);
                            continue;
                        }
                        chunkPrimer.func_177855_a(k, k1, l, filler);
                        continue;
                    }
                    if (j1 <= 0) continue;
                    --j1;
                    chunkPrimer.func_177855_a(k, k1, l, filler);
                }
            }
        }
    }

    protected double[] setupNoiseGenerators(double[] buffer, int x, int z) {
        if (buffer == null) {
            buffer = new double[3366];
        }
        double d = 1368.824;
        double d1 = 684.412;
        this.pnr = this.perlinNoise1.func_76304_a(this.pnr, x, 0, z, 3, 33, 3, d / 80.0, d1 / 160.0, d / 80.0);
        this.ar = this.noiseGen1.func_76304_a(this.ar, x, 0, z, 3, 33, 3, d, d1, d);
        this.br = this.noiseGen1.func_76304_a(this.br, x, 0, z, 3, 33, 3, d, d1, d);
        int id = 0;
        for (int j2 = 0; j2 < 3; ++j2) {
            for (int l2 = 0; l2 < 3; ++l2) {
                for (int j3 = 0; j3 < 33; ++j3) {
                    double d10 = this.ar[id] / 512.0;
                    double d11 = this.br[id] / 512.0;
                    double d12 = (this.pnr[id] / 10.0 + 1.0) / 2.0;
                    double d8 = d12 < 0.0 ? d10 : (d12 > 1.0 ? d11 : d10 + (d11 - d10) * d12);
                    d8 -= 8.0;
                    if (j3 > 1) {
                        double d13 = (float)(j3 - 1) / 31.0f;
                        d8 = d8 * (1.0 - d13) + -30.0 * d13;
                    }
                    if (j3 < 8) {
                        double d14 = (float)(8 - j3) / 7.0f;
                        d8 = d8 * (1.0 - d14) + -30.0 * d14;
                    }
                    buffer[id] = d8;
                    ++id;
                }
            }
        }
        return buffer;
    }
}

