/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.treasure.loot.provider;

import com.github.fnar.minecraft.block.BlockType;
import com.github.fnar.minecraft.item.ArmourType;
import com.github.fnar.minecraft.item.Dye;
import com.github.fnar.minecraft.item.Enchantment;
import com.github.fnar.minecraft.item.Food;
import com.github.fnar.minecraft.item.Material;
import com.github.fnar.minecraft.item.Miscellaneous;
import com.github.fnar.minecraft.item.Record;
import com.github.fnar.minecraft.item.RldItemStack;
import com.github.fnar.minecraft.item.ToolType;
import com.github.fnar.minecraft.item.WeaponType;
import com.github.fnar.util.Color;
import com.google.common.base.Functions;
import greymerk.roguelike.treasure.loot.Quality;
import greymerk.roguelike.util.DyeColor;
import greymerk.roguelike.util.TextFormat;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

public enum ItemNovelty {
    AMLP,
    ASHLEA,
    AVIDYA,
    BAJ,
    BDOUBLEO,
    CLEO,
    DINNERBONE,
    DOCM,
    ENIKOBOW,
    ENIKOSWORD,
    ETHO,
    FOURLES,
    GENERIKB,
    GINGER,
    GREYMERK,
    GRIM,
    GUUDE,
    KAMEIB,
    KURT,
    MANPANTS,
    MMILLSS,
    NEBRISCROWN,
    NOTCH,
    NULL,
    QUANTUMLEAP,
    RLEAHY,
    VALANDRAH,
    VECHS,
    ZISTEAUSIGN,
    BDUBSSWEATER;

    public static final Map<String, ItemNovelty> names;

    public static RldItemStack getItemByName(String name) {
        return ItemNovelty.getItemByNamePrivate(name.toUpperCase());
    }

    private static RldItemStack getItemByNamePrivate(String name) {
        return names.containsKey(name) ? ItemNovelty.getItem(names.get(name)) : null;
    }

    public static RldItemStack getItem(ItemNovelty choice) {
        switch (choice) {
            case AMLP: {
                return ItemNovelty.lascerator();
            }
            case ASHLEA: {
                return ItemNovelty.ashleasOatmealCookie();
            }
            case AVIDYA: {
                return ItemNovelty.avidyasWhiteRussian();
            }
            case BAJ: {
                return ItemNovelty.bajsLastResort();
            }
            case BDOUBLEO: {
                return ItemNovelty.bDoubleOsDigJob();
            }
            case BDUBSSWEATER: {
                return ItemNovelty.bDoubleOspinkSweater();
            }
            case CLEO: {
                return ItemNovelty.cleophianDiggingFeesh();
            }
            case DINNERBONE: {
                return ItemNovelty.oldDinnerbone();
            }
            case DOCM: {
                return ItemNovelty.docmRodOfCommand();
            }
            case ENIKOBOW: {
                return ItemNovelty.enikosStringTheory();
            }
            case ENIKOSWORD: {
                return ItemNovelty.enikosEarring();
            }
            case ETHO: {
                return ItemNovelty.ethosYourMomJoke();
            }
            case FOURLES: {
                return ItemNovelty.fourlesDarkroastBeans();
            }
            case GENERIKB: {
                return ItemNovelty.generikBsHotPotato();
            }
            case GINGER: {
                return ItemNovelty.gingerSpiceChicken();
            }
            case GREYMERK: {
                return ItemNovelty.greymerksHatchet();
            }
            case GRIM: {
                return ItemNovelty.grimChewToy();
            }
            case GUUDE: {
                return ItemNovelty.boulderfistianGoldenRecord();
            }
            case KAMEIB: {
                return ItemNovelty.kameibShell();
            }
            case KURT: {
                return ItemNovelty.farlandTravellers();
            }
            case MANPANTS: {
                return ItemNovelty.manPants();
            }
            case MMILLSS: {
                return ItemNovelty.mmillssSpiderBane();
            }
            case NEBRISCROWN: {
                return ItemNovelty.nebrisCrown();
            }
            case NOTCH: {
                return ItemNovelty.notchsApple();
            }
            case NULL: {
                return ItemNovelty.nullPointer();
            }
            case QUANTUMLEAP: {
                return ItemNovelty.quantumleapsSwissCheese();
            }
            case RLEAHY: {
                return ItemNovelty.rleahianBattleSub();
            }
            case VALANDRAH: {
                return ItemNovelty.valandrahsKiss();
            }
            case VECHS: {
                return ItemNovelty.vechsLegendaryStick();
            }
            case ZISTEAUSIGN: {
                return ItemNovelty.zisteauSign();
            }
        }
        return null;
    }

    public static RldItemStack greymerksHatchet() {
        return ToolType.AXE.asItem().withQuality(Quality.IRON).withEnchantment(Enchantment.Effect.SHARPNESS.atLevel(3)).withEnchantment(Enchantment.Effect.KNOCKBACK).withEnchantment(Enchantment.Effect.UNBREAKING.atLevel(2)).asStack().withDisplayName("novelty.roguelike.greymerk.name").withDisplayLore(TextFormat.DARKGREEN.apply("Pointlessly sharp")).withDisplayLocLore("novelty.roguelike.greymerk.lore");
    }

    public static RldItemStack nebrisCrown() {
        return ArmourType.HELMET.asItem().golden().withEnchantment(Enchantment.Effect.PROTECTION.atLevel(4)).withEnchantment(Enchantment.Effect.UNBREAKING.atLevel(3)).asStack().withDisplayName("novelty.roguelike.nebriscrown.name").withDisplayLore(TextFormat.DARKGREEN.apply("Adorned with precious gemstones")).withDisplayLocLore("novelty.roguelike.nebriscrown.lore");
    }

    public static RldItemStack nullPointer() {
        return WeaponType.SWORD.asItem().diamond().withEnchantment(Enchantment.Effect.SHARPNESS.atLevel(5)).withEnchantment(Enchantment.Effect.KNOCKBACK.atLevel(2)).withEnchantment(Enchantment.Effect.UNBREAKING.atLevel(3)).asStack().withDisplayName("novelty.roguelike.nebrissword.name").withDisplayLore(TextFormat.DARKGREEN.apply("Exceptional")).withDisplayLocLore("novelty.roguelike.nebrissword.lore");
    }

    public static RldItemStack manPants() {
        return ArmourType.LEGGINGS.asItem().leather().withColor(Color.SMOKED_SALMON).withEnchantment(Enchantment.Effect.FIRE_PROTECTION.atLevel(4)).withEnchantment(Enchantment.Effect.UNBREAKING.atLevel(3)).asStack().withDisplayName("novelty.roguelike.zisteaupants.name").withDisplayLore(TextFormat.DARKGREEN.apply("Yessss, Manpants!")).withDisplayLocLore("novelty.roguelike.zisteaupants.lore");
    }

    public static RldItemStack zisteauSign() {
        return Miscellaneous.Type.SIGN.asItem().withEnchantment(Enchantment.Effect.SHARPNESS.atLevel(5)).withEnchantment(Enchantment.Effect.KNOCKBACK.atLevel(3)).withEnchantment(Enchantment.Effect.FIRE_ASPECT).asStack().withDisplayName("novelty.roguelike.zisteausign.name").withDisplayLore(TextFormat.DARKGREEN.apply("\"That's what you get!\"")).withDisplayLocLore("novelty.roguelike.zisteausign.lore");
    }

    public static RldItemStack avidyasWhiteRussian() {
        return Food.Type.MILK_BUCKET.asItem().withEnchantment(Enchantment.Effect.BANE_OF_ARTHROPODS.atLevel(4)).withEnchantment(Enchantment.Effect.KNOCKBACK).withEnchantment(Enchantment.Effect.FIRE_ASPECT).asStack().withDisplayName("novelty.roguelike.avidya.name").withDisplayLore(TextFormat.DARKGREEN.apply("The dude's favourite")).withDisplayLocLore("novelty.roguelike.avidya.lore");
    }

    public static RldItemStack ashleasOatmealCookie() {
        return Food.Type.COOKIE.asItem().withEnchantment(Enchantment.Effect.SHARPNESS.atLevel(2)).withEnchantment(Enchantment.Effect.KNOCKBACK).asStack().withDisplayName("novelty.roguelike.ashlea.name").withDisplayLore(TextFormat.DARKGREEN.apply("Perfect for elevensies")).withDisplayLocLore("novelty.roguelike.ashlea.lore");
    }

    public static RldItemStack farlandTravellers() {
        return ArmourType.BOOTS.asItem().leather().withColor(Color.HARISSA_RED).withEnchantment(Enchantment.Effect.PROTECTION.atLevel(3)).withEnchantment(Enchantment.Effect.FEATHER_FALLING.atLevel(2)).withEnchantment(Enchantment.Effect.UNBREAKING.atLevel(3)).asStack().withDisplayName("novelty.roguelike.kurt.name").withDisplayLore(TextFormat.DARKGREEN.apply("Indeed!")).withDisplayLocLore("novelty.roguelike.kurt.lore");
    }

    public static RldItemStack lascerator() {
        return ToolType.SHEARS.asItem().withEnchantment(Enchantment.Effect.SHARPNESS.atLevel(3)).withEnchantment(Enchantment.Effect.KNOCKBACK.atLevel(2)).withEnchantment(Enchantment.Effect.FIRE_ASPECT).asStack().withDisplayName("novelty.roguelike.amlp.name").withDisplayLore(TextFormat.DARKGREEN.apply("The wool collector")).withDisplayLocLore("novelty.roguelike.amlp.lore");
    }

    public static RldItemStack cleophianDiggingFeesh() {
        return Food.Type.COD.asItem().withEnchantment(Enchantment.Effect.EFFICIENCY.atLevel(10)).withEnchantment(Enchantment.Effect.KNOCKBACK.atLevel(5)).withEnchantment(Enchantment.Effect.FORTUNE.atLevel(5)).withEnchantment(Enchantment.Effect.UNBREAKING.atLevel(10)).asStack().withDisplayName("novelty.roguelike.cleo.name").withDisplayLore(TextFormat.DARKGREEN.apply("Feesh are not efeeshent for digging")).withDisplayLocLore("novelty.roguelike.cleo.lore");
    }

    public static RldItemStack bDoubleOspinkSweater() {
        return ArmourType.CHESTPLATE.asItem().withQuality(Quality.WOOD).withColor(Color.CHINESE_RED).asStack().withDisplayName("novelty.roguelike.pinksweater.name").withDisplayLore("\"It's chinese red!\"").withDisplayLocLore("novelty.roguelike.pinksweater.lore");
    }

    public static RldItemStack bDoubleOsDigJob() {
        return ToolType.SHOVEL.asItem().diamond().withEnchantment(Enchantment.Effect.EFFICIENCY.atLevel(5)).withEnchantment(Enchantment.Effect.UNBREAKING.atLevel(3)).asStack().withDisplayName("novelty.roguelike.bdoubleo.name").withDisplayLore(TextFormat.DARKGREEN.apply("Recovered from hell's blazes")).withDisplayLocLore("novelty.roguelike.bdoubleo.lore");
    }

    public static RldItemStack boulderfistianGoldenRecord() {
        return Record.newRecord().withSong(Record.Song.THIRTEEN).withEnchantment(Enchantment.Effect.SHARPNESS.atLevel(3)).withEnchantment(Enchantment.Effect.KNOCKBACK).withEnchantment(Enchantment.Effect.BLAST_PROTECTION.atLevel(3)).asStack().withDisplayName("novelty.roguelike.guude.name").withDisplayLore(TextFormat.DARKGREEN.apply("\"You're Watching Guude Boulderfist...\"")).withDisplayLocLore("novelty.roguelike.guude.lore");
    }

    public static RldItemStack rleahianBattleSub() {
        return Food.Type.BREAD.asItem().withEnchantment(Enchantment.Effect.SHARPNESS.atLevel(2)).withEnchantment(Enchantment.Effect.KNOCKBACK).withEnchantment(Enchantment.Effect.FIRE_ASPECT.atLevel(2)).asStack().withDisplayName("novelty.roguelike.rleahy.name").withDisplayLore(TextFormat.DARKGREEN.apply("With extra pastrami")).withDisplayLocLore("novelty.roguelike.rleahy.lore");
    }

    public static RldItemStack ethosYourMomJoke() {
        return ToolType.PICKAXE.asItem().wooden().withEnchantment(Enchantment.Effect.EFFICIENCY.atLevel(5)).withEnchantment(Enchantment.Effect.UNBREAKING.atLevel(3)).asStack().withDisplayName("novelty.roguelike.etho.name").withDisplayLore(TextFormat.DARKGREEN.apply("The original")).withDisplayLocLore("novelty.roguelike.etho.lore");
    }

    public static RldItemStack enikosStringTheory() {
        return WeaponType.BOW.asItem().withEnchantment(Enchantment.Effect.POWER.atLevel(5)).withEnchantment(Enchantment.Effect.KNOCKBACK.atLevel(2)).withEnchantment(Enchantment.Effect.INFINITY).withEnchantment(Enchantment.Effect.UNBREAKING.atLevel(3)).asStack().withDisplayName("novelty.roguelike.enikobow.name").withDisplayLore(TextFormat.DARKGREEN.apply("For Science!")).withDisplayLocLore("novelty.roguelike.enikobow.lore");
    }

    public static RldItemStack enikosEarring() {
        return WeaponType.SWORD.asItem().diamond().withEnchantment(Enchantment.Effect.SHARPNESS.atLevel(5)).withEnchantment(Enchantment.Effect.LOOTING.atLevel(3)).withEnchantment(Enchantment.Effect.UNBREAKING.atLevel(3)).asStack().withDisplayName("novelty.roguelike.enikosword.name").withDisplayLore(TextFormat.DARKGREEN.apply("\"She do the loot take boogie\"")).withDisplayLocLore("novelty.roguelike.enikosword.lore");
    }

    public static RldItemStack bajsLastResort() {
        return ToolType.HOE.asItem().golden().withEnchantment(Enchantment.Effect.SHARPNESS.atLevel(2)).withEnchantment(Enchantment.Effect.KNOCKBACK).withEnchantment(Enchantment.Effect.FORTUNE.atLevel(5)).asStack().withDisplayName("novelty.roguelike.baj.name").withDisplayLore(TextFormat.DARKGREEN.apply("\"Starvation could be fatal\"")).withDisplayLocLore("novelty.roguelike.baj.lore");
    }

    public static RldItemStack docmRodOfCommand() {
        return ToolType.FISHING_ROD.asItem().withEnchantment(Enchantment.Effect.SHARPNESS.atLevel(3)).withEnchantment(Enchantment.Effect.KNOCKBACK).asStack().withDisplayName("novelty.roguelike.docm.name").withDisplayLore(TextFormat.DARKGREEN.apply("\"Get to the dang land!\"")).withDisplayLocLore("novelty.roguelike.docm.lore");
    }

    public static RldItemStack gingerSpiceChicken() {
        return Food.Type.COOKED_CHICKEN.asItem().withEnchantment(Enchantment.Effect.KNOCKBACK).withEnchantment(Enchantment.Effect.UNBREAKING.atLevel(3)).withEnchantment(Enchantment.Effect.SHARPNESS).asStack().withDisplayName("novelty.roguelike.ginger.name").withDisplayLore(TextFormat.DARKGREEN.apply("\"Kung Pao!\"")).withDisplayLocLore("novelty.roguelike.ginger.lore");
    }

    public static RldItemStack vechsLegendaryStick() {
        return Material.Type.STICK.asItem().withEnchantment(Enchantment.Effect.UNBREAKING).asStack().withDisplayName("novelty.roguelike.vechs.name").withDisplayLore(TextFormat.DARKGREEN.apply("\"Really?!\"")).withDisplayLocLore("novelty.roguelike.vechs.lore");
    }

    public static RldItemStack notchsApple() {
        return Food.Type.APPLE.asItem().withEnchantment(Enchantment.Effect.SHARPNESS.atLevel(10)).withEnchantment(Enchantment.Effect.KNOCKBACK.atLevel(10)).asStack().withDisplayName("novelty.roguelike.notch.name").withDisplayLore(TextFormat.DARKGREEN.apply("Imbued with the creator's power")).withDisplayLocLore("novelty.roguelike.notch.lore");
    }

    public static RldItemStack quantumleapsSwissCheese() {
        return BlockType.SPONGE.asItem().withEnchantment(Enchantment.Effect.SHARPNESS.atLevel(4)).asStack().withDisplayName("novelty.roguelike.quantumleap.name").withDisplayLore(TextFormat.DARKGREEN.apply("\"Oh boy\"")).withDisplayLocLore("novelty.roguelike.quantumleap.lore");
    }

    public static RldItemStack generikBsHotPotato() {
        return Food.Type.BAKED_POTATO.asItem().withEnchantment(Enchantment.Effect.FIRE_ASPECT.atLevel(3)).withEnchantment(Enchantment.Effect.SHARPNESS.atLevel(2)).withEnchantment(Enchantment.Effect.KNOCKBACK).asStack().withDisplayName("novelty.roguelike.generikb.name").withDisplayLore(TextFormat.DARKGREEN.apply("All a hermit needs")).withDisplayLocLore("novelty.roguelike.generikb.lore");
    }

    public static RldItemStack fourlesDarkroastBeans() {
        return new Dye(DyeColor.BROWN).withEnchantment(Enchantment.Effect.FIRE_ASPECT.atLevel(2)).withEnchantment(Enchantment.Effect.SHARPNESS.atLevel(2)).asStack().withDisplayName("novelty.roguelike.fourles.name").withDisplayLore(TextFormat.DARKGREEN.apply("\"Mmmm... Dark Roast\"")).withDisplayLocLore("novelty.roguelike.fourles.lore");
    }

    public static RldItemStack oldDinnerbone() {
        return Material.Type.BONE.asItem().withEnchantment(Enchantment.Effect.SHARPNESS.atLevel(3)).withEnchantment(Enchantment.Effect.FIRE_ASPECT.atLevel(2)).asStack().withDisplayName("novelty.roguelike.dinnerbone.name").withDisplayLore(TextFormat.DARKGREEN.apply("\"Dang Skellies!\"")).withDisplayLocLore("novelty.roguelike.dinnerbone.lore");
    }

    public static RldItemStack grimChewToy() {
        return Food.Type.ROTTEN_FLESH.asItem().withEnchantment(Enchantment.Effect.SMITE.atLevel(2)).withEnchantment(Enchantment.Effect.LOOTING).asStack().withDisplayName("novelty.roguelike.grim.name").withDisplayLore(TextFormat.DARKGREEN.apply("\"Come on Grim, let's do this!\"")).withDisplayLocLore("novelty.roguelike.grim.lore");
    }

    public static RldItemStack mmillssSpiderBane() {
        return BlockType.CACTUS.asItem().withEnchantment(Enchantment.Effect.BANE_OF_ARTHROPODS.atLevel(4)).withEnchantment(Enchantment.Effect.THORNS.atLevel(2)).withEnchantment(Enchantment.Effect.LOOTING).asStack().withDisplayName("novelty.roguelike.mmillss.name").withDisplayLore(TextFormat.DARKGREEN.apply("\"I really don't need anymore string...\"")).withDisplayLocLore("novelty.roguelike.mmillss.lore");
    }

    public static RldItemStack valandrahsKiss() {
        return WeaponType.SWORD.asItem().iron().withEnchantment(Enchantment.Effect.SHARPNESS.atLevel(4)).withEnchantment(Enchantment.Effect.FIRE_ASPECT).withEnchantment(Enchantment.Effect.KNOCKBACK).withEnchantment(Enchantment.Effect.UNBREAKING.atLevel(2)).asStack().withDisplayName("novelty.roguelike.valandrah.name").withDisplayLore(TextFormat.DARKGREEN.apply("\"Feel the kiss of my blade\"")).withDisplayLocLore("novelty.roguelike.valandrah.lore");
    }

    public static RldItemStack kameibShell() {
        return ArmourType.HELMET.asItem().diamond().withEnchantment(Enchantment.Effect.RESPIRATION.atLevel(5)).withEnchantment(Enchantment.Effect.LUCK_OF_THE_SEA.atLevel(2)).withEnchantment(Enchantment.Effect.THORNS.atLevel(1)).asStack().withDisplayName("novelty.roguelike.kameib.name").withDisplayLore(TextFormat.DARKGREEN.apply("Fishing and chill")).withDisplayLocLore("novelty.roguelike.kameib.lore");
    }

    static {
        names = Arrays.stream(ItemNovelty.values()).collect(Collectors.toMap(Enum::toString, Functions.identity()));
    }
}

