/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.dungeon.settings.builtin.dungeon;

import com.github.fnar.minecraft.item.Material;
import com.github.fnar.minecraft.world.BiomeTag;
import greymerk.roguelike.dungeon.base.RoomType;
import greymerk.roguelike.dungeon.base.RoomsSetting;
import greymerk.roguelike.dungeon.base.SecretsSetting;
import greymerk.roguelike.dungeon.layout.LayoutGenerator;
import greymerk.roguelike.dungeon.segment.Segment;
import greymerk.roguelike.dungeon.segment.SegmentGenerator;
import greymerk.roguelike.dungeon.settings.DungeonSettings;
import greymerk.roguelike.dungeon.settings.LevelSettings;
import greymerk.roguelike.dungeon.settings.SettingIdentifier;
import greymerk.roguelike.dungeon.settings.TowerSettings;
import greymerk.roguelike.dungeon.settings.builtin.BuiltinBaseSettings;
import greymerk.roguelike.dungeon.towers.TowerType;
import greymerk.roguelike.theme.Theme;
import greymerk.roguelike.treasure.loot.MinecraftItemLootItem;
import greymerk.roguelike.treasure.loot.rule.SingleUseLootRule;

public class BuiltinDesertDungeonSettings
extends DungeonSettings {
    public static final SettingIdentifier ID = new SettingIdentifier("builtin", "desert");

    public BuiltinDesertDungeonSettings() {
        super(ID);
        this.setExclusive(true);
        this.getInherit().add(BuiltinBaseSettings.ID);
        this.getCriteria().addBiomeTags(BiomeTag.SANDY);
        this.setTowerSettings(new TowerSettings(TowerType.PYRAMID, Theme.PYRAMID));
        for (int i = 0; i < 5; ++i) {
            this.getLootRules().add(new SingleUseLootRule(new MinecraftItemLootItem(Material.Type.GOLD_INGOT.asItem(), 0, 1, 1 + i, 1), i, 6));
        }
        Theme[] themes = new Theme[]{Theme.PYRAMID, Theme.SANDSTONE, Theme.SANDSTONERED, Theme.ENDER, Theme.NETHER};
        for (int level = 0; level < 5; ++level) {
            RoomsSetting factory;
            SegmentGenerator segments;
            LevelSettings levelSettings = new LevelSettings(level);
            levelSettings.setTheme(themes[level]);
            if (level == 0) {
                levelSettings.setLevel(2);
                segments = new SegmentGenerator(Segment.SQUAREARCH);
                segments.add(Segment.WALL, 10);
                segments.add(Segment.ANKH, 5);
                segments.add(Segment.SKULL, 2);
                segments.add(Segment.TOMB, 1);
                levelSettings.setSegments(segments);
                factory = new RoomsSetting();
                factory.add(RoomType.PYRAMIDTOMB.newSingleRoomSetting());
                factory.add(RoomType.PYRAMIDSPAWNER.newRandomRoomSetting(5));
                factory.add(RoomType.PYRAMIDCORNER.newRandomRoomSetting(3));
                levelSettings.setRooms(factory);
                SecretsSetting secrets = new SecretsSetting();
                secrets.add(RoomType.PYRAMIDTOMB.newSingleRoomSetting());
                levelSettings.setSecrets(secrets);
                levelSettings.setGenerator(LayoutGenerator.Type.CLASSIC);
            }
            if (level == 1) {
                levelSettings.setLevel(2);
                segments = new SegmentGenerator(Segment.SQUAREARCH);
                segments.add(Segment.SPAWNER, 1);
                segments.add(Segment.WALL, 10);
                segments.add(Segment.INSET, 5);
                segments.add(Segment.SHELF, 5);
                segments.add(Segment.CHEST, 1);
                segments.add(Segment.ANKH, 1);
                segments.add(Segment.SKULL, 2);
                segments.add(Segment.TOMB, 1);
                levelSettings.setSegments(segments);
                factory = new RoomsSetting();
                factory.add(RoomType.PYRAMIDTOMB.newRandomRoomSetting(2));
                factory.add(RoomType.PYRAMIDSPAWNER.newRandomRoomSetting(10));
                factory.add(RoomType.PYRAMIDCORNER.newRandomRoomSetting(5));
                levelSettings.setRooms(factory);
                levelSettings.setGenerator(LayoutGenerator.Type.CLASSIC);
            }
            if (level == 2) {
                levelSettings.setLevel(2);
                segments = new SegmentGenerator(Segment.SQUAREARCH);
                segments.add(Segment.SPAWNER, 1);
                segments.add(Segment.WALL, 10);
                segments.add(Segment.INSET, 5);
                segments.add(Segment.SHELF, 5);
                segments.add(Segment.CHEST, 1);
                segments.add(Segment.SKULL, 2);
                segments.add(Segment.TOMB, 1);
                levelSettings.setSegments(segments);
                factory = new RoomsSetting();
                factory.add(RoomType.PYRAMIDTOMB.newRandomRoomSetting(1));
                factory.add(RoomType.CRYPT.newRandomRoomSetting(4));
                factory.add(RoomType.OSSUARY.newSingleRoomSetting());
                factory.add(RoomType.SPIDER.newRandomRoomSetting(2));
                factory.add(RoomType.PYRAMIDSPAWNER.newRandomRoomSetting(5));
                factory.add(RoomType.PYRAMIDCORNER.newRandomRoomSetting(4));
                levelSettings.setRooms(factory);
                levelSettings.setGenerator(LayoutGenerator.Type.CLASSIC);
            }
            if (level == 3) {
                levelSettings.setLevel(2);
                segments = new SegmentGenerator(Segment.SQUAREARCH);
                segments.add(Segment.SPAWNER, 1);
                segments.add(Segment.WALL, 10);
                segments.add(Segment.INSET, 5);
                segments.add(Segment.SHELF, 5);
                segments.add(Segment.CHEST, 1);
                segments.add(Segment.SKULL, 2);
                segments.add(Segment.TOMB, 1);
                levelSettings.setSegments(segments);
                factory = new RoomsSetting();
                factory.add(RoomType.PYRAMIDTOMB.newRandomRoomSetting(1));
                factory.add(RoomType.SLIME.newRandomRoomSetting(2));
                factory.add(RoomType.FIRE.newRandomRoomSetting(2));
                factory.add(RoomType.PYRAMIDSPAWNER.newRandomRoomSetting(5));
                factory.add(RoomType.PYRAMIDCORNER.newRandomRoomSetting(4));
                factory.add(RoomType.SPIDER.newRandomRoomSetting(2));
                levelSettings.setRooms(factory);
                levelSettings.setGenerator(LayoutGenerator.Type.CLASSIC);
            }
            this.getLevelSettings().put(level, levelSettings);
        }
    }
}

