/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.dungeon.settings;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import greymerk.roguelike.dungeon.settings.DungeonSettingParseException;
import greymerk.roguelike.dungeon.towers.TowerType;
import greymerk.roguelike.theme.Theme;
import greymerk.roguelike.theme.ThemeParser;
import greymerk.roguelike.theme.builtin.ThemeTower;

public class TowerSettings {
    private final TowerType type;
    private final Theme theme;

    public TowerSettings(TowerType type, Theme theme) {
        this.type = type;
        this.theme = theme;
    }

    public TowerSettings(JsonElement e) throws Exception {
        JsonObject data = e.getAsJsonObject();
        this.type = data.has("type") ? (TowerType)TowerType.get(data.get("type").getAsString()).orElse(null) : null;
        try {
            this.theme = data.has("theme") ? ThemeParser.parse(data.get("theme").getAsJsonObject()) : null;
        }
        catch (DungeonSettingParseException exception) {
            throw new DungeonSettingParseException("While parsing tower: " + exception.getMessage());
        }
    }

    public TowerSettings(TowerSettings base, TowerSettings override) {
        if (base == null) {
            this.type = override.type;
            this.theme = override.theme;
            return;
        }
        if (override == null) {
            this.type = base.type;
            this.theme = base.theme;
            return;
        }
        this.type = override.type == null ? base.type : override.type;
        this.theme = override.theme == null ? base.theme : override.theme;
    }

    public TowerSettings(TowerSettings toCopy) {
        this.type = toCopy.type;
        this.theme = toCopy.theme;
    }

    public TowerType getType() {
        if (this.type == null) {
            return TowerType.ROGUE;
        }
        return this.type;
    }

    public Theme getTheme() {
        if (this.theme == null) {
            return new ThemeTower();
        }
        return this.theme;
    }
}

