/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.dungeon.settings;

import com.github.fnar.minecraft.world.BiomeTag;
import greymerk.roguelike.config.RogueConfig;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.WorldEditor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class SpawnCriteria {
    private int weight = 1;
    private final List<Integer> validDimensions = new ArrayList<Integer>();
    private final Set<String> biomes = new HashSet<String>();
    private final Set<BiomeTag> biomeTags = new HashSet<BiomeTag>();

    public SpawnCriteria inherit(SpawnCriteria toInherit) {
        this.setWeight(toInherit.getWeight());
        this.addBiomes(toInherit.biomes);
        this.addBiomeTags(toInherit.biomeTags);
        this.addDimensions(toInherit.getValidDimensions());
        return this;
    }

    public static boolean isValidDimension(int dimension) {
        return SpawnCriteria.isValidDimension(dimension, RogueConfig.DIMENSIONWL.getIntList(), RogueConfig.DIMENSIONBL.getIntList());
    }

    public static boolean isValidDimension(int dimension, List<Integer> whiteList, List<Integer> blackList) {
        return !blackList.contains(dimension) && (whiteList.isEmpty() || whiteList.contains(dimension));
    }

    public int getWeight() {
        return this.weight;
    }

    public void setWeight(int weight) {
        this.weight = weight;
    }

    public void addBiomes(Collection<String> biomes) {
        this.biomes.addAll(biomes);
    }

    public void addBiomeTags(BiomeTag ... biomeTags) {
        Collections.addAll(this.biomeTags, biomeTags);
    }

    public void addBiomeTags(Collection<BiomeTag> biomeTags) {
        this.biomeTags.addAll(biomeTags);
    }

    public void addDimensions(Collection<Integer> dimensions) {
        this.validDimensions.addAll(dimensions);
    }

    public boolean isValid(WorldEditor worldEditor, Coord coord) {
        return this.isBiomeValid(worldEditor, coord) && this.isBiomeTypeValid(worldEditor, coord) && this.isDimensionValid(worldEditor);
    }

    private boolean isBiomeValid(WorldEditor worldEditor, Coord coord) {
        return this.biomes.isEmpty() || this.includesBiome(worldEditor, coord);
    }

    private boolean includesBiome(WorldEditor worldEditor, Coord coord) {
        return this.biomes.contains(worldEditor.getBiomeName(coord));
    }

    private boolean isBiomeTypeValid(WorldEditor worldEditor, Coord coord) {
        return this.biomeTags.isEmpty() || this.includesBiomeType(worldEditor, coord);
    }

    private boolean includesBiomeType(WorldEditor worldEditor, Coord coord) {
        return this.biomeTags.stream().anyMatch(biomeType -> worldEditor.isBiomeTypeAt((BiomeTag)((Object)biomeType), coord));
    }

    private boolean isDimensionValid(WorldEditor worldEditor) {
        return SpawnCriteria.isValidDimension(worldEditor.getDimension()) && this.validDimensions.isEmpty() || this.includesDimension(worldEditor);
    }

    private boolean includesDimension(WorldEditor worldEditor) {
        return this.validDimensions.contains(worldEditor.getDimension());
    }

    public List<Integer> getValidDimensions() {
        return this.validDimensions;
    }
}

