/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.dungeon.settings;

import com.github.fnar.forge.ModLoader;
import com.github.fnar.roguelike.settings.exception.SettingsNotFoundException;
import greymerk.roguelike.config.RogueConfig;
import greymerk.roguelike.dungeon.settings.DungeonSettings;
import greymerk.roguelike.dungeon.settings.SettingIdentifier;
import greymerk.roguelike.dungeon.settings.SettingsContainer;
import greymerk.roguelike.util.WeightedChoice;
import greymerk.roguelike.util.WeightedRandomizer;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.WorldEditor;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class SettingsResolver {
    private final SettingsContainer settingsContainer;

    public static SettingsResolver getInstance(ModLoader modLoader) {
        return new SettingsResolver(new SettingsContainer(modLoader).loadFiles());
    }

    public SettingsResolver(SettingsContainer settingsContainer) {
        this.settingsContainer = settingsContainer;
    }

    public DungeonSettings resolve(String settingName) {
        DungeonSettings dungeonSettings = this.settingsContainer.get(new SettingIdentifier(settingName));
        DungeonSettings inflatedDungeonSettings = this.processInheritance(dungeonSettings);
        return Optional.ofNullable(inflatedDungeonSettings).orElseThrow(() -> new SettingsNotFoundException(settingName));
    }

    public Optional<DungeonSettings> chooseRandom(WorldEditor editor, Coord coord) {
        return Optional.ofNullable(this.chooseRandomCustom(editor, coord).orElse(this.chooseRandomBuiltin(editor, coord).orElse(null)));
    }

    public DungeonSettings processInheritance(DungeonSettings dungeonSettings) {
        DungeonSettings accumulatedInheritedSettings = dungeonSettings.getInherit().stream().map(this.settingsContainer::get).map(this::processInheritance).reduce(new DungeonSettings(), (accumulation, toInherit) -> toInherit.inherit((DungeonSettings)accumulation));
        return dungeonSettings.inherit(accumulatedInheritedSettings);
    }

    private Optional<DungeonSettings> chooseRandomBuiltin(WorldEditor editor, Coord coord) {
        if (!RogueConfig.SPAWNBUILTIN.getBoolean()) {
            return Optional.empty();
        }
        return this.chooseRandomValid(editor, coord, this.settingsContainer.getBuiltinSettings());
    }

    private Optional<DungeonSettings> chooseRandomCustom(WorldEditor editor, Coord coord) {
        return this.chooseRandomValid(editor, coord, this.settingsContainer.getCustomSettings());
    }

    private Optional<DungeonSettings> chooseRandomValid(WorldEditor editor, Coord coord, Collection<DungeonSettings> settings) {
        List<DungeonSettings> inflatedSettings = settings.stream().map(this::processInheritance).filter(this.isValid(editor, coord)).collect(Collectors.toList());
        WeightedRandomizer<DungeonSettings> settingsRandomizer = this.newWeightedRandomizer(inflatedSettings);
        return Optional.ofNullable(settingsRandomizer.get(editor.getRandom()));
    }

    private Predicate<DungeonSettings> isValid(WorldEditor editor, Coord coord) {
        return setting -> setting.isExclusive() && setting.isValid(editor, coord);
    }

    private WeightedRandomizer<DungeonSettings> newWeightedRandomizer(List<DungeonSettings> dungeonSettings) {
        WeightedRandomizer<DungeonSettings> settingsRandomizer = new WeightedRandomizer<DungeonSettings>();
        dungeonSettings.stream().map(setting -> new WeightedChoice<DungeonSettings>((DungeonSettings)setting, setting.getCriteria().getWeight())).forEach(settingsRandomizer::add);
        return settingsRandomizer;
    }

    public String toString(String namespace) {
        return this.settingsContainer.getByNamespace(namespace).stream().map(DungeonSettings::getId).map(SettingIdentifier::toString).collect(Collectors.joining(" "));
    }

    public String toString() {
        return this.settingsContainer.toString();
    }

    public Set<SettingIdentifier> getAllSettingIdentifiers() {
        return this.settingsContainer.getAllSettingIdentifiers();
    }
}

