/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.dungeon.settings;

import com.github.fnar.util.Pair;
import java.util.Objects;

public class SettingIdentifier {
    public static final char DELIMITER = ':';
    private final Pair<String, String> identifier;

    public SettingIdentifier(String namespace, String name) {
        this.identifier = new Pair<String, String>(namespace, name);
    }

    public SettingIdentifier(String name) {
        String[] parts = name.split(":");
        String namespace = parts.length > 1 ? parts[0] : "default";
        String uniqueName = parts.length > 1 ? parts[1] : name;
        this.identifier = new Pair<String, String>(namespace, uniqueName);
    }

    public String getNamespace() {
        return this.identifier.getKey();
    }

    public String getName() {
        return this.identifier.getValue();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SettingIdentifier that = (SettingIdentifier)o;
        return Objects.equals(this.identifier, that.identifier);
    }

    public int hashCode() {
        return Objects.hash(this.identifier);
    }

    public String toString() {
        return this.getNamespace() + ':' + this.getName();
    }
}

