/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.dungeon.segment.part;

import com.github.fnar.minecraft.block.SingleBlockBrush;
import com.github.fnar.minecraft.block.normal.StairsBlock;
import greymerk.roguelike.dungeon.DungeonLevel;
import greymerk.roguelike.dungeon.base.BaseRoom;
import greymerk.roguelike.dungeon.base.SecretsSetting;
import greymerk.roguelike.dungeon.segment.part.SegmentBase;
import greymerk.roguelike.theme.Theme;
import greymerk.roguelike.worldgen.BlockBrush;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.Direction;
import greymerk.roguelike.worldgen.WorldEditor;
import greymerk.roguelike.worldgen.shapes.RectSolid;
import java.util.Optional;

public class SegmentWall
extends SegmentBase {
    @Override
    protected void genWall(WorldEditor editor, DungeonLevel level, Direction dir, Theme theme, Coord origin) {
        StairsBlock stair = this.getSecondaryStairs(theme);
        Direction[] orthogonals = dir.orthogonals();
        Coord cursor = origin.copy();
        cursor.translate(dir, 2);
        Coord start = cursor.copy();
        start.translate(orthogonals[0], 1);
        Coord end = cursor.copy();
        end.translate(orthogonals[1], 1);
        end.up(2);
        SingleBlockBrush.AIR.fill(editor, RectSolid.newRect(start, end));
        SecretsSetting secrets = level.getSettings().getSecrets();
        Optional<BaseRoom> room = this.generateSecret(secrets, editor, level.getSettings(), dir, origin.copy());
        start.translate(dir, 1);
        end.translate(dir, 1);
        RectSolid.newRect(start, end).fill(editor, this.getSecondaryWall(theme), false, true);
        cursor.up(2);
        for (Direction d : orthogonals) {
            Coord c = cursor.copy();
            c.translate(d, 1);
            stair.setUpsideDown(true).setFacing(d.reverse());
            stair.stroke(editor, c);
        }
        if (room.isPresent()) {
            cursor = origin.copy();
            BlockBrush wall = SegmentWall.getPrimaryWalls(theme);
            cursor.translate(dir, 3);
            wall.stroke(editor, cursor);
            cursor.up();
            wall.stroke(editor, cursor);
        }
    }
}

