/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.dungeon.layout.classic;

import greymerk.roguelike.dungeon.layout.DungeonNode;
import greymerk.roguelike.dungeon.layout.DungeonTunnel;
import greymerk.roguelike.dungeon.layout.LayoutGenerator;
import greymerk.roguelike.dungeon.layout.LevelLayout;
import greymerk.roguelike.dungeon.layout.classic.Edge;
import greymerk.roguelike.dungeon.layout.classic.Node;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.Direction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;

public class LayoutGeneratorClassic
implements LayoutGenerator {
    private static final int MIN_ROOMS = 6;
    private final LevelLayout layout;
    private Coord start;
    private final int numRooms;
    private final int scatter;
    private final int range;
    private final Map<Node, Set<Edge>> graph = new HashMap<Node, Set<Edge>>();

    public LayoutGeneratorClassic(int numRooms, int scatter, int range) {
        this.layout = new LevelLayout();
        this.numRooms = numRooms;
        this.scatter = scatter;
        this.range = range;
    }

    @Override
    public LevelLayout generate(Coord start, Random random) {
        this.start = start;
        Node node = this.createNode(start, Direction.randomCardinal(random));
        while (!this.isDone()) {
            this.update(random);
        }
        this.getNodes().forEach(this::cull);
        return this.generateLayoutFromGraph(node, random);
    }

    private boolean isDone(Node node) {
        return this.getEdges(node).stream().allMatch(Edge::isDone);
    }

    private List<DungeonTunnel> createTunnels(Node node) {
        return this.getEdges(node).stream().map(Edge::asDungeonTunnel).collect(Collectors.toList());
    }

    private Set<Node> getNodes() {
        return this.graph.keySet();
    }

    private Set<Edge> getEdges(Node node) {
        return this.graph.get(node);
    }

    private Node createNode(Coord coord, Direction direction) {
        Node node = new Node(coord, direction);
        this.graph.put(node, new HashSet());
        if (this.start.distance(coord) <= (double)this.range) {
            Direction.cardinals().stream().filter(dir -> !dir.equals((Object)direction.reverse())).map(dir -> new Edge(coord.copy(), (Direction)((Object)dir))).forEach(edge -> this.graph.get(node).add((Edge)edge));
        }
        return node;
    }

    private LevelLayout generateLayoutFromGraph(Node startNode, Random random) {
        DungeonNode startDungeonNode = null;
        for (Node node : this.getNodes()) {
            DungeonNode dungeonNode = this.asDungeonNode(node);
            if (node == startNode) {
                startDungeonNode = dungeonNode;
            }
            this.layout.addNode(dungeonNode);
            this.layout.addTunnels(this.createTunnels(node));
        }
        this.layout.setStartEnd(random, startDungeonNode);
        return this.layout;
    }

    private DungeonNode asDungeonNode(Node node) {
        return new DungeonNode(this.getEntrances(node), node.getCoord());
    }

    private List<Direction> getEntrances(Node node) {
        ArrayList<Direction> entrances = new ArrayList<Direction>();
        entrances.add(node.getDirection().reverse());
        this.getEdges(node).stream().map(Edge::getDir).forEach(entrances::add);
        return entrances;
    }

    public void update(Random random) {
        if (this.isFull()) {
            return;
        }
        this.defeatConcurrentModification().forEach(node -> this.updateNode(random, (Node)node));
    }

    private HashSet<Node> defeatConcurrentModification() {
        return new HashSet<Node>(this.getNodes());
    }

    private boolean isDone() {
        return this.getNodes().stream().allMatch(this::isDone) || this.isFull();
    }

    private boolean isFull() {
        return this.getNodes().size() >= Math.max(this.numRooms, 6);
    }

    public void updateNode(Random random, Node node) {
        this.getEdges(node).forEach(edge -> this.updateEdge(random, (Edge)edge));
    }

    public void updateEdge(Random random, Edge edge) {
        if (edge.isDone()) {
            return;
        }
        if (this.hasNodeNearby(edge.getEnd())) {
            edge.getEnd().translate(edge.getDir(), this.scatter);
        } else if (random.nextInt(edge.getExtensionsRemaining()) > 0) {
            edge.getEnd().translate(edge.getDir(), this.scatter);
            edge.setExtensionsRemaining(edge.getExtensionsRemaining() - 1);
        } else {
            this.createNode(edge.getEnd().copy(), edge.getDir());
            edge.setDone(true);
        }
    }

    private boolean hasNodeNearby(Coord coord) {
        return this.getNodes().stream().map(Node::getCoord).mapToInt(coord::distanceAsInt).anyMatch(distance -> distance < this.scatter);
    }

    private void cull(Node node) {
        this.graph.put(node, this.graph.get(node).stream().filter(Edge::isDone).collect(Collectors.toSet()));
    }

    @Override
    public LevelLayout getLayout() {
        return this.layout;
    }
}

