/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.dungeon.base;

import com.google.common.collect.Lists;
import greymerk.roguelike.dungeon.base.RoomType;
import greymerk.roguelike.dungeon.rooms.RoomSetting;
import java.util.List;
import java.util.Random;
import java.util.stream.IntStream;

public class SecretsSetting {
    private final List<RoomSetting> secretRoomSettings = Lists.newArrayList();

    public SecretsSetting() {
    }

    public SecretsSetting(SecretsSetting toCopy) {
        this.secretRoomSettings.addAll(toCopy.secretRoomSettings);
    }

    public SecretsSetting(SecretsSetting base, SecretsSetting other) {
        if (base != null) {
            this.secretRoomSettings.addAll(base.secretRoomSettings);
        }
        if (other != null) {
            this.secretRoomSettings.addAll(other.secretRoomSettings);
        }
    }

    public static SecretsSetting getRandom(Random rand, int count) {
        SecretsSetting secrets = new SecretsSetting();
        IntStream.range(0, count).mapToObj(i -> RoomType.getRandomSecret(rand)).forEach(type -> secrets.add(type.newSingleRoomSetting()));
        return secrets;
    }

    public void add(RoomSetting roomSetting) {
        IntStream.range(0, roomSetting.getCount()).forEach(value -> this.secretRoomSettings.add(roomSetting));
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SecretsSetting)) {
            return false;
        }
        SecretsSetting other = (SecretsSetting)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<RoomSetting> this$secretRoomSettings = this.getSecretRoomSettings();
        List<RoomSetting> other$secretRoomSettings = other.getSecretRoomSettings();
        return !(this$secretRoomSettings == null ? other$secretRoomSettings != null : !((Object)this$secretRoomSettings).equals(other$secretRoomSettings));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SecretsSetting;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<RoomSetting> $secretRoomSettings = this.getSecretRoomSettings();
        result = result * 59 + ($secretRoomSettings == null ? 43 : ((Object)$secretRoomSettings).hashCode());
        return result;
    }

    public List<RoomSetting> getSecretRoomSettings() {
        return this.secretRoomSettings;
    }

    public String toString() {
        return "SecretsSetting(secretRoomSettings=" + this.getSecretRoomSettings() + ")";
    }
}

