/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemTooltip {
    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onItemTooltip(ItemTooltipEvent event) {
        List<String> itemLocLore = ItemTooltip.getLocLore(event.getItemStack());
        if (event.isCanceled() || itemLocLore == null || itemLocLore.isEmpty()) {
            return;
        }
        ItemStack itemStack = event.getItemStack();
        List tooltip = event.getToolTip();
        List<String> itemLore = ItemTooltip.getLore(itemStack);
        if (itemLore != null && !itemLore.isEmpty()) {
            int iLore = 0;
            for (int iTooltip = 1; iTooltip < tooltip.size(); iTooltip = (int)((short)(iTooltip + 1))) {
                if (!((String)tooltip.get(iTooltip)).contains(itemLore.get(0))) continue;
                while (iLore < itemLore.size() && iTooltip < tooltip.size()) {
                    tooltip.remove(iTooltip);
                    iLore = (short)(iLore + 1);
                }
                break;
            }
        }
        for (int i = 0; i < itemLocLore.size(); i = (int)((short)(i + 1))) {
            tooltip.add(i + 1, I18n.func_135052_a((String)itemLocLore.get(i), (Object[])new Object[0]));
        }
    }

    public static List<String> getLocLore(ItemStack itemStack) {
        if (!itemStack.func_77942_o() || !itemStack.func_77978_p().func_74764_b("display")) {
            return null;
        }
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        NBTTagCompound nbtDisplay = tagCompound.func_74775_l("display");
        if (!nbtDisplay.func_74764_b("rldLocLore")) {
            return null;
        }
        NBTTagList loreTagList = nbtDisplay.func_150295_c("rldLocLore", 8);
        ArrayList<String> loreStringList = new ArrayList<String>();
        for (int i = 0; i < loreTagList.func_74745_c(); i = (int)((short)(i + 1))) {
            loreStringList.add(loreTagList.func_150307_f(i));
        }
        return loreStringList;
    }

    public static List<String> getLore(ItemStack itemStack) {
        if (!itemStack.func_77942_o() || !itemStack.func_77978_p().func_74764_b("display")) {
            return null;
        }
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        NBTTagCompound nbtDisplay = tagCompound.func_74775_l("display");
        if (!nbtDisplay.func_74764_b("Lore")) {
            return null;
        }
        NBTTagList loreTagList = nbtDisplay.func_150295_c("Lore", 8);
        ArrayList<String> loreStringList = new ArrayList<String>();
        for (int i = 0; i < loreTagList.func_74745_c(); i = (int)((short)(i + 1))) {
            loreStringList.add(loreTagList.func_150307_f(i));
        }
        return loreStringList;
    }
}

