/*
 * Decompiled with CFR 0.152.
 */
package com.github.fnar.roguelike.command.commands;

import com.github.fnar.minecraft.item.RldItemStack;
import com.github.fnar.roguelike.command.CommandContext;
import com.github.fnar.roguelike.command.commands.BaseRoguelikeCommand;
import greymerk.roguelike.treasure.loot.provider.ItemNovelty;

public class GiveCommand
extends BaseRoguelikeCommand {
    private final String itemName;

    public GiveCommand(CommandContext commandContext, String itemName) {
        super(commandContext);
        this.itemName = itemName;
    }

    @Override
    public boolean onRun() {
        if (this.itemName == null) {
            this.context.sendInfo("notif.roguelike.usage_", "/roguelike give <novelty_name>");
            this.context.sendInfo("notif.roguelike.example_", "/roguelike give BDOUBLEO");
            return false;
        }
        RldItemStack item = ItemNovelty.getItemByName(this.itemName);
        if (item == null) {
            this.context.sendFailure("nosuchitem");
            return false;
        }
        this.context.give(item);
        return true;
    }

    @Override
    public void onSuccess() {
        this.context.sendSuccess("given", this.itemName);
    }

    private static RldItemStack onRun(String name) {
        return ItemNovelty.getItemByName(name);
    }
}

