/*
 * Decompiled with CFR 0.152.
 */
package com.github.fnar.minecraft.item.mapper;

import com.github.fnar.minecraft.Effect;
import com.github.fnar.minecraft.item.Potion;
import com.github.fnar.minecraft.item.mapper.BaseItemMapper1_12;
import java.util.Optional;
import net.minecraft.init.Items;
import net.minecraft.init.PotionTypes;
import net.minecraft.item.Item;
import net.minecraft.item.ItemPotion;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;

public class PotionMapper1_12
extends BaseItemMapper1_12<Potion> {
    private static void mapEffectTags(NBTTagCompound effectTag, NBTTagCompound tags) {
        String customPotionEffectsTag = "CustomPotionEffects";
        NBTTagList effects = tags.func_150295_c("CustomPotionEffects", 10);
        effects.func_74742_a((NBTBase)effectTag);
        tags.func_74782_a("CustomPotionEffects", (NBTBase)effects);
    }

    @Override
    public Class<Potion> getClazz() {
        return Potion.class;
    }

    @Override
    public ItemStack map(Potion potion) {
        ItemPotion potionForm = this.mapForm(potion.getForm());
        PotionType potionType = this.mapPotionType(potion);
        ItemStack itemStack = PotionUtils.func_185188_a((ItemStack)this.addEnchantmentNbtTags(potion, (Item)potionForm), (PotionType)potionType);
        NBTTagCompound tags = this.getNbtTagCompound(itemStack);
        Optional.ofNullable(potion.getColor()).ifPresent(color -> tags.func_74768_a("CustomPotionColor", color.asInt()));
        potion.getEffects().stream().map(this::mapEffectToTag).forEach(effectTag -> PotionMapper1_12.mapEffectTags(effectTag, tags));
        return itemStack;
    }

    private NBTTagCompound getNbtTagCompound(ItemStack itemStack) {
        NBTTagCompound tags = Optional.ofNullable(itemStack.func_77978_p()).orElseGet(NBTTagCompound::new);
        itemStack.func_77982_d(tags);
        return tags;
    }

    private PotionType mapPotionType(Potion potion) {
        return this.mapToPotionType(potion.getEffect(), potion.isAmplified(), potion.isExtended());
    }

    private ItemPotion mapForm(Potion.Form form) {
        return form == Potion.Form.REGULAR ? Items.field_151068_bn : (form == Potion.Form.SPLASH ? Items.field_185155_bH : Items.field_185156_bI);
    }

    private NBTTagCompound mapEffectToTag(Effect effect) {
        int ticksPerSecond = 20;
        NBTTagCompound effectTag = new NBTTagCompound();
        effectTag.func_74774_a("Id", (byte)effect.getType().getEffectID());
        effectTag.func_74774_a("Amplifier", (byte)effect.getAmplification());
        effectTag.func_74768_a("Duration", effect.getDuration() * 20);
        effectTag.func_74757_a("Ambient", false);
        return effectTag;
    }

    public PotionType mapToPotionType(Potion.Effect effect, boolean isAmplified, boolean isExtended) {
        switch (effect) {
            case HEALING: {
                return isAmplified ? PotionTypes.field_185251_w : PotionTypes.field_185250_v;
            }
            case HARMING: {
                return isAmplified ? PotionTypes.field_185253_y : PotionTypes.field_185252_x;
            }
            case REGENERATION: {
                return isExtended ? PotionTypes.field_185221_D : (isAmplified ? PotionTypes.field_185222_E : PotionTypes.field_185220_C);
            }
            case POISON: {
                return isExtended ? PotionTypes.field_185218_A : (isAmplified ? PotionTypes.field_185219_B : PotionTypes.field_185254_z);
            }
            case STRENGTH: {
                return isExtended ? PotionTypes.field_185224_G : (isAmplified ? PotionTypes.field_185225_H : PotionTypes.field_185223_F);
            }
            case WEAKNESS: {
                return isExtended ? PotionTypes.field_185227_J : PotionTypes.field_185226_I;
            }
            case SLOWNESS: {
                return isExtended ? PotionTypes.field_185247_s : PotionTypes.field_185246_r;
            }
            case SWIFTNESS: {
                return isExtended ? PotionTypes.field_185244_p : (isAmplified ? PotionTypes.field_185245_q : PotionTypes.field_185243_o);
            }
            case FIRE_RESISTANCE: {
                return isExtended ? PotionTypes.field_185242_n : PotionTypes.field_185241_m;
            }
            case INVISIBILITY: {
                return isExtended ? PotionTypes.field_185237_i : PotionTypes.field_185236_h;
            }
            case LEAPING: {
                return isExtended ? PotionTypes.field_185239_k : PotionTypes.field_185238_j;
            }
            case NIGHT_VISION: {
                return isExtended ? PotionTypes.field_185235_g : PotionTypes.field_185234_f;
            }
            case WATER_BREATHING: {
                return isExtended ? PotionTypes.field_185249_u : PotionTypes.field_185248_t;
            }
        }
        return PotionTypes.field_185233_e;
    }
}

