/*
 * Decompiled with CFR 0.152.
 */
package com.github.fnar.minecraft.item.mapper;

import com.github.fnar.minecraft.item.Armour;
import com.github.fnar.minecraft.item.ArmourType;
import com.github.fnar.minecraft.item.CouldNotMapItemException;
import com.github.fnar.minecraft.item.mapper.BaseItemMapper1_12;
import com.github.fnar.minecraft.item.mapper.EquipmentMapper1_12;
import com.github.fnar.util.Color;
import greymerk.roguelike.treasure.loot.Quality;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class ArmourMapper1_12
extends BaseItemMapper1_12<Armour> {
    private static void applyColourTags(Armour rldItem, ItemStack itemStack) {
        Color color = rldItem.getColor();
        if (color == null) {
            return;
        }
        if (!Quality.WOOD.equals((Object)rldItem.getQuality())) {
            return;
        }
        if (ArmourType.HORSE.equals((Object)rldItem.getArmourType())) {
            return;
        }
        NBTTagCompound tags = itemStack.func_77978_p();
        if (tags == null) {
            tags = new NBTTagCompound();
            itemStack.func_77982_d(tags);
        }
        NBTTagCompound displayTag = tags.func_74775_l("display");
        if (!tags.func_74764_b("display")) {
            tags.func_74782_a("display", (NBTBase)displayTag);
        }
        displayTag.func_74768_a("color", color.asInt());
    }

    @Override
    public Class<Armour> getClazz() {
        return Armour.class;
    }

    @Override
    public ItemStack map(Armour rldItem) throws CouldNotMapItemException {
        Item item = this.map(rldItem, rldItem.getArmourType(), rldItem.getQuality());
        ItemStack itemStack = this.addEnchantmentNbtTags(rldItem, item);
        ArmourMapper1_12.applyColourTags(rldItem, itemStack);
        return itemStack;
    }

    public Item map(Armour item, ArmourType armourType, Quality quality) throws CouldNotMapItemException {
        switch (armourType) {
            case HELMET: {
                return EquipmentMapper1_12.map(quality, (Item)Items.field_151024_Q, (Item)Items.field_151020_U, (Item)Items.field_151028_Y, (Item)Items.field_151169_ag, (Item)Items.field_151161_ac);
            }
            case CHESTPLATE: {
                return EquipmentMapper1_12.map(quality, (Item)Items.field_151027_R, (Item)Items.field_151023_V, (Item)Items.field_151030_Z, (Item)Items.field_151171_ah, (Item)Items.field_151163_ad);
            }
            case HORSE: {
                return EquipmentMapper1_12.map(quality, Items.field_151141_av, Items.field_151141_av, Items.field_151138_bX, Items.field_151136_bY, Items.field_151125_bZ);
            }
            case LEGGINGS: {
                return EquipmentMapper1_12.map(quality, (Item)Items.field_151026_S, (Item)Items.field_151022_W, (Item)Items.field_151165_aa, (Item)Items.field_151149_ai, (Item)Items.field_151173_ae);
            }
            case BOOTS: {
                return EquipmentMapper1_12.map(quality, (Item)Items.field_151021_T, (Item)Items.field_151029_X, (Item)Items.field_151167_ab, (Item)Items.field_151151_aj, (Item)Items.field_151175_af);
            }
        }
        throw new CouldNotMapItemException(item);
    }
}

