/*
 * Decompiled with CFR 0.152.
 */
package com.github.fnar.minecraft.block.spawner;

import com.github.fnar.minecraft.EffectType;
import com.github.fnar.minecraft.block.spawner.SpawnPotential;
import com.github.fnar.minecraft.item.CouldNotMapItemException;
import com.github.fnar.minecraft.item.RldItem;
import com.github.fnar.minecraft.item.mapper.ItemMapper1_12;
import com.github.fnar.roguelike.Roguelike;
import greymerk.roguelike.config.RogueConfig;
import greymerk.roguelike.monster.Mob;
import java.util.List;
import java.util.Random;
import java.util.stream.IntStream;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagList;

public class SpawnPotentialMapper1_12 {
    public static NBTTagList mapToNbt(List<SpawnPotential> spawnerPotentials, Random random, int level) {
        NBTTagList potentialsNbtTagList = new NBTTagList();
        spawnerPotentials.stream().map(potential -> SpawnPotentialMapper1_12.mapToNbt(potential, random, level)).forEach(potentials -> potentials.forEach(arg_0 -> ((NBTTagList)potentialsNbtTagList).func_74742_a(arg_0)));
        return potentialsNbtTagList;
    }

    private static NBTTagList mapToNbt(SpawnPotential spawnPotential, Random random, int level) {
        NBTTagList potentials = new NBTTagList();
        IntStream.range(0, 12).mapToObj(i -> spawnPotential.generateMob(random, level)).map(mob -> SpawnPotentialMapper1_12.mapToNbt(spawnPotential, level, mob)).forEach(arg_0 -> ((NBTTagList)potentials).func_74742_a(arg_0));
        return potentials;
    }

    private static NBTTagCompound mapToNbt(SpawnPotential spawnPotential, int level, Mob mob) {
        NBTTagCompound entityNbt = SpawnPotentialMapper1_12.createEntityNbt(level, SpawnPotentialMapper1_12.jsonToNbt(spawnPotential.getNbt()), spawnPotential.getName());
        SpawnPotentialMapper1_12.addHandTags(entityNbt, mob.getMainhand(), mob.getOffhand());
        SpawnPotentialMapper1_12.addArmourTags(entityNbt, mob.getBoots(), mob.getLeggings(), mob.getChestplate(), mob.getHelmet());
        return SpawnPotentialMapper1_12.buildSpawnPotentialNbt(entityNbt, spawnPotential.getWeight());
    }

    private static NBTTagCompound createEntityNbt(int level, NBTTagCompound entityNbt, String entityName) {
        NBTTagCompound entityNbtCopy = entityNbt.func_74737_b();
        SpawnPotentialMapper1_12.addRoguelikeNbtData(entityNbtCopy, entityName, level);
        return entityNbtCopy;
    }

    private static void addHandTags(NBTTagCompound entityNbt, RldItem mainhand, RldItem offhand) {
        NBTTagList hands = new NBTTagList();
        SpawnPotentialMapper1_12.appendItemTag(hands, mainhand);
        SpawnPotentialMapper1_12.appendItemTag(hands, offhand);
        entityNbt.func_74782_a("HandItems", (NBTBase)hands);
    }

    private static NBTTagCompound mapItemToTag(RldItem mainhand) {
        if (mainhand == null) {
            return null;
        }
        try {
            String itemName = new ItemMapper1_12().map(mainhand.asStack()).func_77973_b().getRegistryName().toString();
            NBTTagCompound item = new NBTTagCompound();
            item.func_74778_a("id", itemName);
            item.func_74768_a("Count", 1);
            return item;
        }
        catch (CouldNotMapItemException | NullPointerException e) {
            Roguelike.LOGGER.error((Object)e);
            return null;
        }
    }

    private static NBTTagCompound buildSpawnPotentialNbt(NBTTagCompound entityNbt, int weight) {
        NBTTagCompound spawnPotentialNbt = new NBTTagCompound();
        spawnPotentialNbt.func_74782_a("Entity", (NBTBase)entityNbt);
        spawnPotentialNbt.func_74768_a("Weight", weight);
        return spawnPotentialNbt;
    }

    private static void addArmourTags(NBTTagCompound entityNbt, RldItem boots, RldItem leggings, RldItem chestplate, RldItem helmet) {
        NBTTagList armour = new NBTTagList();
        SpawnPotentialMapper1_12.appendItemTag(armour, boots);
        SpawnPotentialMapper1_12.appendItemTag(armour, leggings);
        SpawnPotentialMapper1_12.appendItemTag(armour, chestplate);
        SpawnPotentialMapper1_12.appendItemTag(armour, helmet);
        entityNbt.func_74782_a("ArmorItems", (NBTBase)armour);
    }

    private static void appendItemTag(NBTTagList parent, RldItem item) {
        NBTTagCompound itemTag = SpawnPotentialMapper1_12.mapItemToTag(item);
        if (itemTag == null) {
            return;
        }
        parent.func_74742_a((NBTBase)itemTag);
    }

    private static void addRoguelikeNbtData(NBTTagCompound entityNbt, String type, int level) {
        entityNbt.func_74778_a("id", type);
        SpawnPotentialMapper1_12.tagEntityAsFromRoguelikeSpawner(entityNbt, level);
        SpawnPotentialMapper1_12.setLootingRateTags(entityNbt);
    }

    private static void tagEntityAsFromRoguelikeSpawner(NBTTagCompound entityNbt, int level) {
        NBTTagList activeEffects = new NBTTagList();
        activeEffects.func_74742_a((NBTBase)SpawnPotentialMapper1_12.getMiningFatigueBuff(level));
        entityNbt.func_74782_a("ActiveEffects", (NBTBase)activeEffects);
    }

    private static NBTTagCompound getMiningFatigueBuff(int level) {
        NBTTagCompound buff = new NBTTagCompound();
        buff.func_74774_a("Id", (byte)EffectType.FATIGUE.getEffectID());
        buff.func_74774_a("Amplifier", (byte)level);
        buff.func_74768_a("Duration", 10);
        buff.func_74774_a("Ambient", (byte)0);
        return buff;
    }

    private static void setLootingRateTags(NBTTagCompound entityNbt) {
        float mobItemsDropChance = (float)RogueConfig.MOBS_ITEMS_DROP_CHANCE.getDouble();
        NBTTagList handDropChances = new NBTTagList();
        NBTTagFloat mainHandDropChance = new NBTTagFloat(mobItemsDropChance);
        NBTTagFloat offHandDropChance = new NBTTagFloat(mobItemsDropChance);
        handDropChances.func_74742_a((NBTBase)mainHandDropChance);
        handDropChances.func_74742_a((NBTBase)offHandDropChance);
        entityNbt.func_74782_a("HandDropChances", (NBTBase)handDropChances);
        NBTTagList armorDropChances = new NBTTagList();
        NBTTagFloat feetDropChance = new NBTTagFloat(mobItemsDropChance);
        NBTTagFloat legsDropChance = new NBTTagFloat(mobItemsDropChance);
        NBTTagFloat chestDropChance = new NBTTagFloat(mobItemsDropChance);
        NBTTagFloat headDropChance = new NBTTagFloat(mobItemsDropChance);
        armorDropChances.func_74742_a((NBTBase)feetDropChance);
        armorDropChances.func_74742_a((NBTBase)legsDropChance);
        armorDropChances.func_74742_a((NBTBase)chestDropChance);
        armorDropChances.func_74742_a((NBTBase)headDropChance);
        entityNbt.func_74782_a("ArmorDropChances", (NBTBase)armorDropChances);
    }

    private static NBTTagCompound jsonToNbt(String entityNbt) {
        try {
            return JsonToNBT.func_180713_a((String)entityNbt);
        }
        catch (NBTException e) {
            return new NBTTagCompound();
        }
    }
}

