/*
 * Decompiled with CFR 0.152.
 */
package com.github.fnar.minecraft.block.spawner;

import com.github.fnar.minecraft.block.spawner.SpawnPotential;
import com.github.fnar.minecraft.block.spawner.Spawner;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;

public enum MobType {
    BAT("bat"),
    BLAZE("blaze"),
    CAVESPIDER("cave_spider"),
    CREEPER("creeper"),
    ELDER_GUARDIAN("elder_guardian"),
    ENDERMAN("enderman"),
    ENDERMITE("endermite"),
    ENDER_DRAGON("dragon"),
    EVOKER("evocation_illager"),
    GHAST("ghast"),
    GUARDIAN("guardian"),
    HUSK("husk"),
    ILLUSIONER("illusion_illager"),
    MAGMA_CUBE("magma_cube"),
    SHULKER("shulker"),
    SILVERFISH("silverfish"),
    SKELETON("skeleton"),
    SLIME("slime"),
    SPIDER("spider"),
    STRAY("stray"),
    VEX("vex"),
    VINDICATOR("vindication_illager"),
    WITCH("witch"),
    WITHER("wither"),
    WITHER_SKELETON("wither_skeleton"),
    ZOMBIE("zombie"),
    ZOMBIE_PIGMAN("zombie_pigman"),
    ZOMBIE_VILLAGER("zombie_villager");

    public static final Set<MobType> EQUIPPABLE_MOB_TYPES;
    public static final MobType[] COMMON_MOBS;
    public static final MobType[] UNCOMMON_MOBS;
    public static final MobType[] RARE_MOBS;
    public static final MobType[] EPIC_MOBS;
    public static final MobType[] LEGENDARY_MOBS;
    public static final MobType[] COMMON_DESERT;
    public static final MobType[] COMMON_SNOW;
    public static final MobType[] COMMON_SWAMP;
    public static final MobType[] HUMANOID_MOBS;
    public static final MobType[] UNDEAD_MOBS;
    public static final MobType[] NETHER_MOBS;
    public static final MobType[] ILLAGERS;
    public static final MobType[] NIGHTMARE_MOBS;
    public static final MobType[] END_MOBS;
    public static final MobType[] SKELETONS;
    public static final MobType[] ZOMBIES;
    public static final MobType[] SPIDERS;
    private final String name;

    private MobType(String name) {
        this.name = "minecraft:" + name;
    }

    public static MobType chooseAmong(MobType[] mobTypes, Random random) {
        return mobTypes[random.nextInt(mobTypes.length)];
    }

    public String getName() {
        return this.name;
    }

    public boolean isEquippable() {
        return EQUIPPABLE_MOB_TYPES.contains((Object)this);
    }

    public Spawner asSpawner() {
        return MobType.asSpawner(this);
    }

    public static Spawner asSpawner(MobType ... mobTypes) {
        return new Spawner(Arrays.stream(mobTypes).map(MobType::getName).map(SpawnPotential::new).collect(Collectors.toList()));
    }

    static {
        EQUIPPABLE_MOB_TYPES = Sets.newHashSet((Object[])new MobType[]{HUSK, SKELETON, STRAY, VEX, VINDICATOR, WITHER_SKELETON, ZOMBIE, ZOMBIE_PIGMAN, ZOMBIE_VILLAGER});
        COMMON_MOBS = new MobType[]{SKELETON, SPIDER, ZOMBIE};
        UNCOMMON_MOBS = new MobType[]{CAVESPIDER, CREEPER};
        RARE_MOBS = new MobType[]{ENDERMAN, SLIME, WITCH};
        EPIC_MOBS = new MobType[]{ENDER_DRAGON, WITHER};
        LEGENDARY_MOBS = new MobType[0];
        COMMON_DESERT = new MobType[]{SKELETON, SPIDER, HUSK};
        COMMON_SNOW = new MobType[]{STRAY, SPIDER, ZOMBIE};
        COMMON_SWAMP = new MobType[]{SKELETON, SLIME, WITCH};
        HUMANOID_MOBS = new MobType[]{SKELETON, WITCH, ZOMBIE};
        UNDEAD_MOBS = new MobType[]{SKELETON, ZOMBIE};
        NETHER_MOBS = new MobType[]{BLAZE, MAGMA_CUBE, ZOMBIE_PIGMAN, WITHER_SKELETON};
        ILLAGERS = new MobType[]{EVOKER, ILLUSIONER, VINDICATOR};
        NIGHTMARE_MOBS = new MobType[]{CREEPER, ENDERMAN, GHAST, SILVERFISH, VEX};
        END_MOBS = new MobType[]{ENDERMAN, ENDERMITE, SHULKER};
        SKELETONS = new MobType[]{SKELETON, STRAY, WITHER_SKELETON};
        ZOMBIES = new MobType[]{ZOMBIE, ZOMBIE_VILLAGER, HUSK};
        SPIDERS = new MobType[]{SPIDER, CAVESPIDER};
    }
}

