/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.client.model;

import com.jaquadro.minecraft.chameleon.Chameleon;
import com.jaquadro.minecraft.chameleon.model.ChamModel;
import com.jaquadro.minecraft.chameleon.render.ChamRender;
import com.jaquadro.minecraft.chameleon.resources.register.DefaultRegister;
import com.jaquadro.minecraft.storagedrawers.block.BlockFramingTable;
import com.jaquadro.minecraft.storagedrawers.client.model.dynamic.CommonFramingRenderer;
import com.jaquadro.minecraft.storagedrawers.core.ModBlocks;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemTransformVec3f;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import org.lwjgl.util.vector.Vector3f;

public class FramingTableModel
extends ChamModel {
    private TextureAtlasSprite iconParticle;
    ItemTransformVec3f transformGui = new ItemTransformVec3f(new Vector3f(30.0f, 225.0f, 0.0f), new Vector3f(0.15f, 0.0f, 0.0f), new Vector3f(0.45f, 0.45f, 0.45f));
    ItemTransformVec3f transformFirstRight = new ItemTransformVec3f(new Vector3f(0.0f, -30.0f, 0.0f), new Vector3f(-0.15f, 0.05f, 0.0f), new Vector3f(0.3f, 0.3f, 0.3f));
    ItemTransformVec3f transformFirstLeft = new ItemTransformVec3f(new Vector3f(0.0f, 150.0f, 0.0f), new Vector3f(-0.15f, 0.05f, 0.0f), new Vector3f(0.3f, 0.3f, 0.3f));
    ItemTransformVec3f transformThirdRight = new ItemTransformVec3f(new Vector3f(75.0f, -30.0f, 0.0f), new Vector3f(-0.2f, 0.2f, -0.15f), new Vector3f(0.3f, 0.3f, 0.3f));
    ItemTransformVec3f transformThirdLeft = new ItemTransformVec3f(new Vector3f(75.0f, 150.0f, 0.0f), new Vector3f(-0.2f, 0.2f, -0.15f), new Vector3f(0.3f, 0.3f, 0.3f));
    ItemTransformVec3f transformHead = new ItemTransformVec3f(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.5f, 0.5f, 0.5f));
    ItemTransformVec3f transformFixed = new ItemTransformVec3f(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.5f, 0.5f, 0.5f));
    ItemTransformVec3f transformGround = new ItemTransformVec3f(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.25f, 0.25f, 0.25f));
    ItemCameraTransforms transform = new ItemCameraTransforms(this.transformThirdLeft, this.transformThirdRight, this.transformFirstLeft, this.transformFirstRight, this.transformHead, this.transformGui, this.transformGround, this.transformFixed);

    public FramingTableModel(IBlockState state) {
        this(state, false);
    }

    protected FramingTableModel(IBlockState state, boolean mergeLayers) {
        super(state, mergeLayers, new Object[0]);
    }

    protected void renderStart(ChamRender renderer, IBlockState state, Object ... args) {
        renderer.state.setRotateTransform(3, ((EnumFacing)state.func_177229_b((IProperty)BlockFramingTable.FACING)).func_176745_a());
    }

    protected void renderEnd(ChamRender renderer, IBlockState state, Object ... args) {
        renderer.state.clearRotateTransform();
    }

    protected void renderSolidLayer(ChamRender renderer, IBlockState state, Object ... args) {
        TextureAtlasSprite iconBase = Chameleon.instance.iconRegistry.getIcon(Register.iconBaseOak);
        TextureAtlasSprite iconTrim = Chameleon.instance.iconRegistry.getIcon(Register.iconTrimOak);
        this.renderSolidLayer(state, new CommonFramingRenderer(renderer), iconBase, iconTrim);
        this.iconParticle = iconBase;
    }

    protected void renderTransLayer(ChamRender renderer, IBlockState state, Object ... args) {
        TextureAtlasSprite iconOverlayLeft = Chameleon.instance.iconRegistry.getIcon(Register.iconOverlayLeft);
        TextureAtlasSprite iconOverlayRight = Chameleon.instance.iconRegistry.getIcon(Register.iconOverlayRight);
        this.renderTransLayer(state, new CommonFramingRenderer(renderer), iconOverlayLeft, iconOverlayRight);
    }

    protected void renderSolidLayer(IBlockState state, CommonFramingRenderer common, TextureAtlasSprite iconBase, TextureAtlasSprite iconTrim) {
        if (((Boolean)state.func_177229_b((IProperty)BlockFramingTable.RIGHT_SIDE)).booleanValue()) {
            common.renderRight(null, state, BlockPos.field_177992_a, iconBase, iconTrim);
        } else {
            common.renderLeft(null, state, BlockPos.field_177992_a, iconBase, iconTrim);
        }
    }

    protected void renderTransLayer(IBlockState state, CommonFramingRenderer common, TextureAtlasSprite iconLeft, TextureAtlasSprite iconRight) {
        if (((Boolean)state.func_177229_b((IProperty)BlockFramingTable.RIGHT_SIDE)).booleanValue()) {
            common.renderOverlayRight(null, state, BlockPos.field_177992_a, iconRight);
        } else {
            common.renderOverlayLeft(null, state, BlockPos.field_177992_a, iconLeft);
        }
    }

    public TextureAtlasSprite func_177554_e() {
        return this.iconParticle;
    }

    public ItemCameraTransforms func_177552_f() {
        return this.transform;
    }

    public static class Register
    extends DefaultRegister {
        public static final ResourceLocation iconBaseOak = new ResourceLocation("storagedrawers:blocks/base/base_oak");
        public static final ResourceLocation iconTrimOak = new ResourceLocation("storagedrawers:blocks/base/trim_oak");
        public static final ResourceLocation iconOverlayLeft = new ResourceLocation("storagedrawers:blocks/overlay/shading_worktable_left");
        public static final ResourceLocation iconOverlayRight = new ResourceLocation("storagedrawers:blocks/overlay/shading_worktable_right");

        public Register() {
            super((Block)ModBlocks.framingTable);
        }

        public List<IBlockState> getBlockStates() {
            ArrayList<IBlockState> states = new ArrayList<IBlockState>();
            for (EnumFacing dir : EnumFacing.field_176754_o) {
                for (Boolean side : new Boolean[]{false, true}) {
                    states.add(ModBlocks.framingTable.func_176223_P().func_177226_a((IProperty)BlockFramingTable.FACING, (Comparable)dir).func_177226_a((IProperty)BlockFramingTable.RIGHT_SIDE, (Comparable)side));
                }
            }
            return states;
        }

        public List<ResourceLocation> getTextureResources() {
            return Arrays.asList(iconBaseOak, iconTrimOak, iconOverlayLeft, iconOverlayRight);
        }

        public IBakedModel getModel(IBlockState state, IBakedModel existingModel) {
            return new FramingTableModel(state);
        }

        public IBakedModel getModel(ItemStack stack, IBakedModel existingModel) {
            return new ItemModel(stack);
        }
    }

    public static class ItemModel
    extends FramingTableModel {
        public ItemModel(@Nonnull ItemStack stack) {
            super(ModBlocks.framingTable.func_176203_a(stack.func_77960_j()), true);
        }

        @Override
        protected void renderSolidLayer(IBlockState state, CommonFramingRenderer common, TextureAtlasSprite iconBase, TextureAtlasSprite iconTrim) {
            common.renderRight(null, state, BlockPos.field_177992_a, iconBase, iconTrim);
            common.renderLeft(null, state, BlockPos.field_177992_a.func_177974_f(), iconBase, iconTrim);
        }

        @Override
        protected void renderTransLayer(IBlockState state, CommonFramingRenderer common, TextureAtlasSprite iconLeft, TextureAtlasSprite iconRight) {
            common.renderOverlayRight(null, state, BlockPos.field_177992_a, iconRight);
            common.renderOverlayLeft(null, state, BlockPos.field_177992_a.func_177974_f(), iconLeft);
        }
    }
}

