/*
 * Decompiled with CFR 0.152.
 */
package technicianlp.reauth.session;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import technicianlp.reauth.ReAuth;
import technicianlp.reauth.authentication.YggdrasilAPI;
import technicianlp.reauth.authentication.http.UnreachableServiceException;
import technicianlp.reauth.session.SessionStatus;

public final class SessionChecker {
    private static final long cacheTime = 300000L;
    private static SessionStatus status = SessionStatus.UNKNOWN;
    private static long lastCheck = 0L;

    public static SessionStatus getSessionStatus(String token, String uuid) {
        if (lastCheck + 300000L < System.currentTimeMillis()) {
            status = SessionStatus.UNKNOWN;
        }
        if (status == SessionStatus.UNKNOWN) {
            status = SessionStatus.REFRESHING;
            lastCheck = System.currentTimeMillis();
            CompletableFuture<String> tokenFuture = CompletableFuture.completedFuture(token);
            CompletableFuture<String> uuidFuture = CompletableFuture.completedFuture(uuid);
            ((CompletableFuture)tokenFuture.thenCombineAsync(uuidFuture, SessionChecker::getSessionStatus0, (Executor)ReAuth.executor)).thenAccept(SessionChecker::setStatus);
        }
        return status;
    }

    public static void invalidate() {
        status = SessionStatus.UNKNOWN;
    }

    private static SessionStatus getSessionStatus0(String accessToken, String uuid) {
        try {
            return YggdrasilAPI.validate(accessToken, uuid) ? SessionStatus.VALID : SessionStatus.INVALID;
        }
        catch (UnreachableServiceException e) {
            ReAuth.log.error("Failed to check session validity", (Throwable)e);
            return SessionStatus.ERROR;
        }
    }

    private static void setStatus(SessionStatus newStatus) {
        status = newStatus;
    }
}

