/*
 * Decompiled with CFR 0.152.
 */
package technicianlp.reauth.configuration;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;

public final class ProfileConstants {
    public static final String PROFILE_TYPE = "type";
    public static final String PROFILE_TYPE_NONE = "none";
    public static final String PROFILE_TYPE_MOJANG = "mojang";
    public static final String PROFILE_TYPE_MICROSOFT = "microsoft";
    public static final String NAME = "name";
    public static final String UUID = "uuid";
    public static final String USERNAME = "username";
    public static final String PASSWORD = "password";
    public static final String REFRESH_TOKEN = "refresh-token";
    public static final String XBL_TOKEN = "xbl-token";
    public static final String KEY = "key";
    public static final String KEY_AUTO = "auto";
    public static final String KEY_NONE = "none";
    public static final String SALT = "salt";
    private static final List<String> propertyOrder = ImmutableList.of((Object)"type", (Object)"name", (Object)"uuid", (Object)"username", (Object)"xbl-token", (Object)"password", (Object)"refresh-token", (Object)"key", (Object)"salt");

    static List<String> getOrderedProfileKeys() {
        return new ArrayList<String>(propertyOrder);
    }

    static int compareProfileKeys(String key1, String key2) {
        if (key1.equals(key2)) {
            return 0;
        }
        if (propertyOrder.contains(key1)) {
            if (propertyOrder.contains(key2)) {
                return Integer.compare(propertyOrder.indexOf(key1), propertyOrder.indexOf(key2));
            }
            return -1;
        }
        if (propertyOrder.contains(key2)) {
            return 1;
        }
        return key1.compareTo(key2);
    }
}

