/*
 * Decompiled with CFR 0.152.
 */
package technicianlp.reauth.authentication.flows.impl;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import technicianlp.reauth.authentication.MsAuthAPI;
import technicianlp.reauth.authentication.SessionData;
import technicianlp.reauth.authentication.dto.microsoft.MicrosoftAuthResponse;
import technicianlp.reauth.authentication.dto.xbox.XboxAuthResponse;
import technicianlp.reauth.authentication.flows.FlowCallback;
import technicianlp.reauth.authentication.flows.FlowStage;
import technicianlp.reauth.authentication.flows.Tokens;
import technicianlp.reauth.authentication.flows.impl.FlowBase;
import technicianlp.reauth.authentication.flows.impl.XboxAuthenticationFlow;
import technicianlp.reauth.authentication.flows.impl.util.Futures;
import technicianlp.reauth.configuration.Profile;
import technicianlp.reauth.configuration.ProfileBuilder;
import technicianlp.reauth.crypto.Crypto;
import technicianlp.reauth.crypto.ProfileEncryption;

public final class MicrosoftProfileFlow
extends FlowBase {
    private final CompletableFuture<ProfileEncryption> encryption;
    private final CompletableFuture<SessionData> session = new CompletableFuture();
    private final XboxAuthenticationFlow xboxFlow1;
    private final CompletableFuture<Boolean> refreshRequired;
    private final CompletableFuture<Profile> profileFuture;

    public MicrosoftProfileFlow(Profile profile, FlowCallback callback) {
        super(callback);
        this.session.whenComplete(this::onSessionComplete);
        CompletableFuture<Profile> profileFuture = CompletableFuture.completedFuture(profile);
        this.encryption = profileFuture.thenApplyAsync(this.wrapStep(FlowStage.CRYPTO_INIT, Crypto::getProfileEncryption), this.executor);
        this.refreshRequired = new CompletableFuture();
        CompletionStage xblTokenDec = this.encryption.thenCombineAsync(profile.get("xbl-token"), ProfileEncryption::decryptFieldOne, this.executor);
        this.xboxFlow1 = new XboxAuthenticationFlow((CompletableFuture<String>)xblTokenDec, callback);
        this.xboxFlow1.getSession().whenComplete(this::onComplete);
        this.registerDependantStages(new CompletableFuture[]{this.encryption, xblTokenDec});
        this.registerDependantFlow(this.xboxFlow1);
        CompletableFuture<String> refreshTokenEnc = Futures.composeConditional(this.refreshRequired, profile.get("refresh-token"), Futures.cancelled());
        CompletionStage refreshTokenDec = this.encryption.thenCombineAsync(refreshTokenEnc, ProfileEncryption::decryptFieldTwo, this.executor);
        CompletionStage auth = ((CompletableFuture)refreshTokenDec).thenApplyAsync(this.wrapStep(FlowStage.MS_REDEEM_REFRESH_TOKEN, MsAuthAPI::redeemRefreshToken), this.executor);
        CompletionStage xasu = ((CompletableFuture)((CompletableFuture)auth).thenApply(MicrosoftAuthResponse::getAccessToken)).thenApplyAsync(this.wrapStep(FlowStage.MS_AUTH_XASU, MsAuthAPI::authenticateXASU), this.executor);
        CompletionStage xblToken = ((CompletableFuture)xasu).thenApply(XboxAuthResponse::getToken);
        XboxAuthenticationFlow xboxFlow2 = new XboxAuthenticationFlow((CompletableFuture<String>)xblToken, callback);
        xboxFlow2.getSession().whenComplete(this::onComplete);
        this.registerDependantStages(new CompletableFuture[]{this.refreshRequired, refreshTokenDec, auth});
        this.registerDependantFlow(xboxFlow2);
        CompletionStage tokens = ((CompletableFuture)auth).thenCombine(xasu, Tokens::new);
        this.profileFuture = Futures.composeConditional(this.refreshRequired, () -> this.lambda$new$0((CompletableFuture)tokens), CompletableFuture.completedFuture(profile));
        this.profileFuture.whenComplete(this::onProfileComplete);
    }

    private void onComplete(SessionData sessionData, Throwable throwable) {
        if (throwable == null) {
            this.session.complete(sessionData);
            this.refreshRequired.complete(false);
        } else {
            if (this.refreshRequired.isDone()) {
                this.session.completeExceptionally(throwable);
                this.profileFuture.cancel(true);
            }
            if (this.xboxFlow1.hasExpiredTokenError()) {
                this.refreshRequired.complete(true);
            } else {
                this.session.completeExceptionally(throwable);
                this.refreshRequired.cancel(true);
            }
        }
    }

    @Override
    public final CompletableFuture<SessionData> getSession() {
        return this.session;
    }

    @Override
    public final boolean hasProfile() {
        return true;
    }

    @Override
    public final CompletableFuture<Profile> getProfile() {
        return this.profileFuture;
    }

    private CompletableFuture<Profile> constructProfile(CompletableFuture<Tokens> tokens) {
        CompletionStage encryption = this.encryption.thenApplyAsync(ProfileEncryption::randomizedCopy, this.executor);
        CompletionStage builder = this.session.thenCombine(encryption, ProfileBuilder::new);
        return ((CompletableFuture)builder).thenCombineAsync(tokens, ProfileBuilder::buildMicrosoft, this.executor);
    }

    private /* synthetic */ CompletableFuture lambda$new$0(CompletableFuture tokens) {
        return this.constructProfile(tokens);
    }
}

