/*
 * Decompiled with CFR 0.152.
 */
package technicianlp.reauth;

import java.io.File;
import java.nio.file.Path;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLFingerprintViolationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import technicianlp.reauth.configuration.Config;
import technicianlp.reauth.configuration.ProfileList;
import technicianlp.reauth.mojangfix.MojangJavaFix;

@Mod(modid="reauth", name="ReAuth", canBeDeactivated=true, clientSideOnly=true, guiFactory="technicianlp.reauth.gui.GuiFactory", updateJSON="https://raw.githubusercontent.com/TechnicianLP/ReAuth/master/update.json", certificateFingerprint="daba0ec4df71b6da841768c49fb873def208a1e3")
@Mod.EventBusSubscriber(value={Side.CLIENT})
public final class ReAuth {
    public static final Logger log = LogManager.getLogger((String)"ReAuth");
    public static final ExecutorService executor;
    @Mod.Instance(value="reauth")
    static ReAuth main;
    public static final Config config;
    public static final ProfileList profiles;
    public static final BiFunction<String, Object[], String> i18n;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        config.loadConfig();
    }

    @SubscribeEvent
    public static void configChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("reauth")) {
            config.loadConfig();
        }
    }

    @Mod.EventHandler
    public void securityError(FMLFingerprintViolationEvent event) {
        if (!event.isDirectory()) {
            throw new SecurityException("ReAuth is not signed! It was likely modified!");
        }
        log.warn("+--------------------------------------------------------------+");
        log.warn("| ReAuth is not packaged. ReAuth has likely been tampered with |");
        log.warn("+--------------------------------------------------------------+");
    }

    static {
        i18n = I18n::func_135052_a;
        MojangJavaFix.fixMojangJava();
        executor = Executors.newCachedThreadPool(new ReAuthThreadFactory());
        Path configFile = new File(Minecraft.func_71410_x().field_71412_D, ".ReAuth.cfg").toPath();
        config = new Config(configFile);
        profiles = config.getProfileList();
    }

    private static final class ReAuthThreadFactory
    implements ThreadFactory {
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private final ThreadGroup group = new ThreadGroup("ReAuth");

        private ReAuthThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread t = new Thread(this.group, runnable, "ReAuth-" + this.threadNumber.getAndIncrement());
            if (t.isDaemon()) {
                t.setDaemon(false);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }
}

