/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftblib.client;

import com.feed_the_beast.ftblib.client.ClientConfig;
import com.feed_the_beast.ftblib.client.FTBLibClient;
import com.feed_the_beast.ftblib.client.GuiSidebarButtonConfig;
import com.feed_the_beast.ftblib.client.SidebarButtonManager;
import com.feed_the_beast.ftblib.lib.client.ClientUtils;
import com.feed_the_beast.ftblib.lib.gui.GuiHelper;
import com.feed_the_beast.ftblib.lib.gui.GuiIcons;
import com.feed_the_beast.ftblib.lib.gui.Panel;
import com.feed_the_beast.ftblib.lib.gui.SimpleTextButton;
import com.feed_the_beast.ftblib.lib.gui.WidgetType;
import com.feed_the_beast.ftblib.lib.gui.misc.GuiButtonListBase;
import com.feed_the_beast.ftblib.lib.gui.misc.GuiLoading;
import com.feed_the_beast.ftblib.lib.icon.Icon;
import com.feed_the_beast.ftblib.lib.util.SidedUtils;
import com.feed_the_beast.ftblib.lib.util.misc.MouseButton;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.config.GuiConfig;
import net.minecraftforge.fml.client.config.GuiMessageDialog;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.eventhandler.Event;

public class GuiClientConfig
extends GuiButtonListBase {
    public GuiClientConfig() {
        this.setTitle(I18n.func_135052_a((String)"sidebar_button.ftblib.settings", (Object[])new Object[0]));
    }

    @Override
    public void addButtons(Panel panel) {
        panel.add(new SimpleTextButton(panel, I18n.func_135052_a((String)"player_config", (Object[])new Object[0]), GuiIcons.SETTINGS_RED){

            @Override
            public void onClicked(MouseButton button) {
                GuiHelper.playClickSound();
                new GuiLoading().openGui();
                ClientUtils.execClientCommand("/my_settings");
            }

            @Override
            public WidgetType getWidgetType() {
                return SidedUtils.isModLoadedOnServer("ftblib") ? super.getWidgetType() : WidgetType.DISABLED;
            }
        });
        panel.add(new SimpleTextButton(panel, I18n.func_135052_a((String)"sidebar_button", (Object[])new Object[0]), Icon.getIcon("ftblib:textures/gui/teams.png")){

            @Override
            public void onClicked(MouseButton button) {
                GuiHelper.playClickSound();
                new GuiSidebarButtonConfig().openGui();
            }
        });
        ArrayList<ButtonClientConfig> buttons = new ArrayList<ButtonClientConfig>();
        for (ClientConfig config : FTBLibClient.CLIENT_CONFIG_MAP.values()) {
            buttons.add(new ButtonClientConfig(panel, config));
        }
        buttons.sort((o1, o2) -> o1.getTitle().compareToIgnoreCase(o2.getTitle()));
        panel.addAll(buttons);
    }

    @Override
    public void onClosed() {
        super.onClosed();
        SidebarButtonManager.INSTANCE.saveConfig();
    }

    private class ButtonClientConfig
    extends SimpleTextButton {
        private final String modId;

        public ButtonClientConfig(Panel panel, ClientConfig config) {
            super(panel, config.name.func_150254_d(), config.icon);
            this.modId = config.id;
        }

        @Override
        public void onClicked(MouseButton button) {
            GuiHelper.playClickSound();
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiCustomConfig(this.modId, this.getTitle()));
        }
    }

    private class GuiCustomConfig
    extends GuiConfig {
        public GuiCustomConfig(String modid, String title) {
            super(Minecraft.func_71410_x().field_71462_r, modid, title);
        }

        protected void func_146284_a(GuiButton button) {
            if (button.field_146127_k == 2000) {
                boolean flag = true;
                try {
                    if ((this.configID != null || !(this.parentScreen instanceof GuiConfig)) && this.entryList.hasChangedEntry(true)) {
                        boolean requiresMcRestart = this.entryList.saveConfigElements();
                        ConfigChangedEvent.OnConfigChangedEvent event = new ConfigChangedEvent.OnConfigChangedEvent(this.modID, this.configID, this.isWorldRunning, requiresMcRestart);
                        MinecraftForge.EVENT_BUS.post((Event)event);
                        if (!event.getResult().equals((Object)Event.Result.DENY)) {
                            MinecraftForge.EVENT_BUS.post((Event)new ConfigChangedEvent.PostConfigChangedEvent(this.modID, this.configID, this.isWorldRunning, requiresMcRestart));
                        }
                        if (requiresMcRestart) {
                            flag = false;
                            this.field_146297_k.func_147108_a((GuiScreen)new GuiMessageDialog(this.parentScreen, "fml.configgui.gameRestartTitle", (ITextComponent)new TextComponentString(I18n.func_135052_a((String)"fml.configgui.gameRestartRequired", (Object[])new Object[0])), "fml.configgui.confirmRestartMessage"));
                        }
                        if (this.parentScreen instanceof GuiConfig) {
                            ((GuiConfig)this.parentScreen).needsRefresh = true;
                        }
                    }
                }
                catch (Throwable e) {
                    FMLLog.log.error("Error performing GuiConfig action:", e);
                }
                if (flag) {
                    this.field_146297_k.func_147108_a(this.parentScreen);
                }
            } else {
                super.func_146284_a(button);
            }
        }
    }
}

