/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.entity;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import io.netty.buffer.ByteBuf;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.client.resources.SkinManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.PacketBuffer;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.tileentity.TileEntitySkull;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import openblocks.common.entity.ai.EntityAIBreakBlock;
import openblocks.common.entity.ai.EntityAIPickupPlayer;
import openmods.Log;
import openmods.api.VisibleForDocumentation;
import openmods.network.event.EventDirection;
import openmods.network.event.NetworkEvent;
import openmods.network.event.NetworkEventMeta;
import openmods.utils.io.GameProfileSerializer;

@VisibleForDocumentation
public class EntityMiniMe
extends EntityCreature
implements IEntityAdditionalSpawnData {
    @SideOnly(value=Side.CLIENT)
    private ResourceLocation locationSkin;
    private GameProfile owner;
    private int pickupCooldown = 0;
    private boolean wasRidden = false;

    public EntityMiniMe(World world, GameProfile owner) {
        this(world);
        this.owner = owner != null ? TileEntitySkull.func_174884_b((GameProfile)owner) : null;
    }

    public EntityMiniMe(World world) {
        super(world);
        this.func_70105_a(0.6f, 0.95f);
        this.func_110163_bv();
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIPickupPlayer(this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIBreakBlock((EntityLiving)this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
    }

    protected PathNavigate func_175447_b(World worldIn) {
        PathNavigateGround navigator = new PathNavigateGround((EntityLiving)this, worldIn);
        this.func_184644_a(PathNodeType.WATER, -1.0f);
        navigator.func_179693_d(true);
        return navigator;
    }

    public void func_70030_z() {
        super.func_70030_z();
        if (this.pickupCooldown > 0) {
            --this.pickupCooldown;
        }
        if (this.wasRidden && !this.func_184207_aI()) {
            this.wasRidden = false;
            this.setPickupCooldown(1200);
        } else if (this.func_184207_aI()) {
            this.wasRidden = true;
        }
    }

    public double func_70042_X() {
        return (double)this.field_70131_O + 0.15;
    }

    public int getPickupCooldown() {
        return this.pickupCooldown;
    }

    public void setPickupCooldown(int cooldown) {
        this.pickupCooldown = cooldown;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(10.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3);
    }

    public void func_96094_a(String name) {
        super.func_96094_a(name);
        if (!(this.field_70170_p.field_72995_K || name == null || this.owner != null && name.equalsIgnoreCase(this.owner.getName()))) {
            try {
                this.owner = TileEntitySkull.func_174884_b((GameProfile)new GameProfile(null, name));
                this.propagateOwnerChange();
            }
            catch (Exception e) {
                Log.warn((Throwable)e, (String)"Failed to change skin to %s", (Object[])new Object[]{name});
            }
        }
    }

    private void propagateOwnerChange() {
        new OwnerChangeEvent(this.func_145782_y(), this.owner).sendToEntity((Entity)this);
    }

    @SideOnly(value=Side.CLIENT)
    public ResourceLocation getSkinResourceLocation() {
        if (this.owner != null) {
            SkinManager manager = Minecraft.func_71410_x().func_152342_ad();
            Map map = manager.func_152788_a(this.owner);
            if (map.containsKey(MinecraftProfileTexture.Type.SKIN)) {
                MinecraftProfileTexture skin = (MinecraftProfileTexture)map.get(MinecraftProfileTexture.Type.SKIN);
                return manager.func_152792_a(skin, MinecraftProfileTexture.Type.SKIN);
            }
            UUID uuid = EntityPlayer.func_146094_a((GameProfile)this.owner);
            return DefaultPlayerSkin.func_177334_a((UUID)uuid);
        }
        return null;
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public boolean func_70631_g_() {
        return true;
    }

    public GameProfile getOwner() {
        return this.owner;
    }

    public void writeSpawnData(ByteBuf data) {
        if (this.owner != null) {
            data.writeBoolean(true);
            GameProfileSerializer.write((GameProfile)this.owner, (PacketBuffer)new PacketBuffer(data));
        } else {
            data.writeBoolean(false);
        }
    }

    public void readSpawnData(ByteBuf data) {
        if (data.readBoolean()) {
            this.owner = GameProfileSerializer.read((PacketBuffer)new PacketBuffer(data));
        }
    }

    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        if (this.owner != null) {
            NBTTagCompound ownerTag = new NBTTagCompound();
            NBTUtil.func_180708_a((NBTTagCompound)ownerTag, (GameProfile)this.owner);
            tag.func_74782_a("Owner", (NBTBase)ownerTag);
        }
        tag.func_74768_a("pickupCooldown", this.pickupCooldown);
    }

    public void func_70037_a(NBTTagCompound tag) {
        this.owner = EntityMiniMe.readOwner(tag);
        super.func_70037_a(tag);
        this.pickupCooldown = tag.func_74762_e("pickupCooldown");
    }

    private static GameProfile readOwner(NBTTagCompound tag) {
        if (tag.func_150297_b("owner", 8)) {
            String ownerName = tag.func_74779_i("owner");
            return TileEntitySkull.func_174884_b((GameProfile)new GameProfile((UUID)null, ownerName));
        }
        if (tag.func_150297_b("OwnerUUID", 8)) {
            String uuidStr = tag.func_74779_i("OwnerUUID");
            try {
                UUID uuid = UUID.fromString(uuidStr);
                return new GameProfile(uuid, null);
            }
            catch (IllegalArgumentException e) {
                Log.warn((Throwable)e, (String)"Failed to parse UUID: %s", (Object[])new Object[]{uuidStr});
            }
        } else if (tag.func_150297_b("Owner", 10)) {
            return NBTUtil.func_152459_a((NBTTagCompound)tag.func_74775_l("Owner"));
        }
        return null;
    }

    public static class OwnerChangeHandler {
        @SubscribeEvent
        public void onProfileChange(OwnerChangeEvent evt) {
            World world = evt.sender.field_70170_p;
            Entity e = world.func_73045_a(evt.entityId);
            if (e instanceof EntityMiniMe) {
                ((EntityMiniMe)e).owner = evt.profile;
            }
        }
    }

    @NetworkEventMeta(direction=EventDirection.S2C)
    public static class OwnerChangeEvent
    extends NetworkEvent {
        private GameProfile profile;
        private int entityId;

        public OwnerChangeEvent(int entityId, GameProfile profile) {
            this.profile = profile;
            this.entityId = entityId;
        }

        protected void readFromStream(PacketBuffer input) {
            this.entityId = input.func_150792_a();
            if (input.readBoolean()) {
                this.profile = GameProfileSerializer.read((PacketBuffer)input);
            }
        }

        protected void writeToStream(PacketBuffer output) {
            output.func_150787_b(this.entityId);
            if (this.profile != null) {
                output.writeBoolean(true);
                GameProfileSerializer.write((GameProfile)this.profile, (PacketBuffer)output);
            } else {
                output.writeBoolean(false);
            }
        }
    }
}

