/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.block;

import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import openblocks.Config;
import openblocks.common.item.ItemTankBlock;
import openblocks.common.tileentity.TileEntityTank;
import openmods.Log;
import openmods.block.OpenBlock;
import openmods.infobook.BookDocumentation;
import openmods.model.variant.VariantModelState;
import openmods.utils.ItemUtils;

@BookDocumentation(hasVideo=true)
public class BlockTank
extends OpenBlock {
    public BlockTank() {
        super(Material.field_151576_e);
    }

    protected BlockStateContainer func_180661_e() {
        return new ExtendedBlockState((Block)this, new IProperty[]{this.getPropertyOrientation()}, new IUnlistedProperty[]{VariantModelState.PROPERTY});
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        IExtendedBlockState oldState = (IExtendedBlockState)state;
        TileEntityTank te = (TileEntityTank)((Object)BlockTank.getTileEntity((IBlockAccess)world, (BlockPos)pos, TileEntityTank.class));
        if (te == null) {
            return state;
        }
        VariantModelState selectors = te.getModelState();
        return oldState.withProperty(VariantModelState.PROPERTY, (Object)selectors);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (!Config.tanksEmitLight) {
            return 0;
        }
        TileEntityTank tile = (TileEntityTank)((Object)BlockTank.getTileEntity((IBlockAccess)world, (BlockPos)pos, TileEntityTank.class));
        return tile != null ? tile.getFluidLightLevel() : 0;
    }

    @Nonnull
    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        IFluidTank tank;
        ItemStack result = new ItemStack((Block)this);
        TileEntityTank tile = (TileEntityTank)((Object)BlockTank.getTileEntity((IBlockAccess)world, (BlockPos)pos, TileEntityTank.class));
        if (tile != null && (tank = tile.getTank()).getFluidAmount() > 0) {
            NBTTagCompound tankTag = tile.getItemNBT();
            if (tankTag.func_74764_b("Amount")) {
                tankTag.func_74768_a("Amount", tank.getCapacity());
            }
            NBTTagCompound nbt = ItemUtils.getItemTag((ItemStack)result);
            nbt.func_74782_a("tank", (NBTBase)tankTag);
        }
        return result;
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState state, World world, BlockPos pos) {
        TileEntityTank tile = (TileEntityTank)((Object)BlockTank.getTileEntity((IBlockAccess)world, (BlockPos)pos, TileEntityTank.class));
        double value = tile.getFluidRatio() * 15.0;
        if (value == 0.0) {
            return 0;
        }
        int trunc = MathHelper.func_76128_c((double)value);
        return Math.max(trunc, 1);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> result) {
        result.add((Object)new ItemStack((Block)this));
        if (tab == CreativeTabs.field_78027_g && Config.displayAllFilledTanks) {
            ItemStack emptyTank = new ItemStack((Block)this);
            for (Fluid fluid : FluidRegistry.getRegisteredFluids().values()) {
                try {
                    ItemStack tankStack = emptyTank.func_77946_l();
                    if (ItemTankBlock.fillTankItem(tankStack, fluid)) {
                        result.add((Object)tankStack);
                        continue;
                    }
                    Log.debug((String)"Failed to create filled tank stack for fluid '%s'. Not registered?", (Object[])new Object[]{fluid.getName()});
                }
                catch (Throwable t) {
                    throw new RuntimeException(String.format("Failed to create item for fluid '%s'Until this is fixed, you can bypass this code with config option 'tanks.displayAllFluids'", fluid.getName()), t);
                }
            }
        }
    }
}

